/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.base;

import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.com.google.common.collect.ImmutableList;
import com.google.gxp.com.google.common.collect.ImmutableMap;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.base.CallVisitor;
import com.google.gxp.compiler.base.ExhaustiveExpressionVisitor;
import com.google.gxp.compiler.base.Expression;
import com.google.gxp.compiler.base.ExpressionVisitor;
import com.google.gxp.compiler.reparent.Attribute;
import com.google.gxp.compiler.schema.Schema;
import java.util.List;
import java.util.Map;

public abstract class Call
extends Expression {
    private final ImmutableMap<String, Attribute> attributes;
    private final ImmutableList<String> attrBundles;

    public Call(SourcePosition sourcePosition, String displayName, Schema schema, Map<String, Attribute> attributes, List<String> attrBundles) {
        super(sourcePosition, displayName, schema);
        this.attributes = ImmutableMap.copyOf(attributes);
        this.attrBundles = ImmutableList.copyOf(attrBundles);
    }

    public Map<String, Attribute> getAttributes() {
        return this.attributes;
    }

    public List<String> getAttrBundles() {
        return this.attrBundles;
    }

    public abstract Call transformParams(ExhaustiveExpressionVisitor var1);

    @Override
    public final <T> T acceptVisitor(ExpressionVisitor<T> visitor) {
        return visitor.visitCall(this);
    }

    public abstract <T> T acceptCallVisitor(CallVisitor<T> var1);

    protected boolean equalsCall(Call that) {
        return this.equalsExpression(that) && Objects.equal(this.getAttributes(), that.getAttributes()) && Objects.equal(this.getAttrBundles(), that.getAttrBundles());
    }

    protected int callHashCode() {
        return Objects.hashCode(this.expressionHashCode(), this.getAttributes(), this.getAttrBundles());
    }
}

