/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config;

import java.net.URL;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseArtifact;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.XMLToObjectMapper;

public class Entry
implements SynapseArtifact {
    private static final Log log = LogFactory.getLog(Entry.class);
    private String key;
    private int type;
    private URL src;
    private Object value;
    private XMLToObjectMapper mapper;
    private long version;
    private long expiryTime;
    private String fileName;
    private String description;
    private Properties entryProperties;
    public static final int INLINE_TEXT = 0;
    public static final int INLINE_XML = 1;
    public static final int URL_SRC = 2;
    public static final int REMOTE_ENTRY = 3;

    public Entry() {
    }

    public Entry(String key) {
        this.key = key;
    }

    public int getType() {
        return this.type;
    }

    public boolean isRemote() {
        return this.type == 3;
    }

    public boolean isURLSource() {
        return this.type == 2;
    }

    public boolean isInlineXML() {
        return this.type == 1;
    }

    public boolean isInlineText() {
        return this.type == 0;
    }

    public void setType(int type) {
        if (type <= 4 && type >= 0) {
            this.type = type;
        } else {
            this.handleException("Invalid entry type for the static entry");
        }
    }

    public URL getSrc() {
        return this.src;
    }

    public void setSrc(URL src) {
        this.src = src;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public XMLToObjectMapper getMapper() {
        return this.mapper;
    }

    public void setMapper(XMLToObjectMapper mapper) {
        this.mapper = mapper;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public long getExpiryTime() {
        return this.expiryTime;
    }

    public void setExpiryTime(long expiryTime) {
        this.expiryTime = expiryTime;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public Properties getEntryProperties() {
        return this.entryProperties;
    }

    public void setEntryProperties(Properties entryProperties) {
        this.entryProperties = entryProperties;
    }

    public boolean isExpired() {
        return this.getType() == 3 && this.getExpiryTime() > 0L && System.currentTimeMillis() > this.expiryTime;
    }

    public boolean isCached() {
        if (this.value != null) {
            return true;
        }
        return this.entryProperties != null && !this.entryProperties.isEmpty();
    }

    public void clearCache() {
        if (this.isDynamic()) {
            this.value = null;
            this.expiryTime = System.currentTimeMillis();
        }
    }

    public boolean isDynamic() {
        return this.type == 3;
    }

    private void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }
}

