/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.ui.commons.markup.html.form;

import java.util.Collection;
import java.util.List;
import org.apache.syncope.client.ui.commons.ajax.markup.html.IndicatorAjaxSubmitLink;
import org.apache.syncope.client.ui.commons.markup.html.form.AbstractFieldPanel;
import org.apache.syncope.client.ui.commons.pages.BaseWebPage;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.springframework.util.CollectionUtils;

public abstract class AbstractMultiPanel<INNER>
extends AbstractFieldPanel<List<INNER>> {
    private static final long serialVersionUID = -6322397761456513324L;
    private final ListView<INNER> view;
    private final WebMarkupContainer container = new WebMarkupContainer("multiValueContainer");
    private final Form<?> form;

    public AbstractMultiPanel(String id, String name, IModel<List<INNER>> model) {
        super(id, name, model);
        this.container.setOutputMarkupId(true);
        this.add(new Component[]{this.container});
        this.form = new Form("innerForm");
        this.form.setDefaultButton(null);
        this.container.add(new Component[]{this.form});
        this.view = new InnerView("view", name, model);
        if (CollectionUtils.isEmpty((Collection)((Collection)model.getObject()))) {
            this.form.addOrReplace(new Component[]{this.getNoDataFragment(name)});
        } else {
            this.form.addOrReplace(new Component[]{this.getDataFragment()});
        }
    }

    public AbstractMultiPanel<INNER> setFormAsMultipart(boolean multipart) {
        this.form.setMultiPart(multipart);
        return this;
    }

    private Fragment getNoDataFragment(String label) {
        Fragment fragment = new Fragment("content", "noDataFragment", (MarkupContainer)this);
        fragment.add(new Component[]{new Label("field-label", (IModel)new ResourceModel(label, label))});
        fragment.add(new Component[]{this.getFragmentPlus()});
        return fragment;
    }

    private Fragment getDataFragment() {
        Fragment fragment = new Fragment("content", "dataFragment", (MarkupContainer)this);
        fragment.add(new Component[]{this.view.setOutputMarkupId(true)});
        return fragment;
    }

    private Fragment getFragmentMinus(final ListItem<INNER> item, final Panel panel, final String label) {
        IndicatorAjaxSubmitLink minus = new IndicatorAjaxSubmitLink("drop"){
            private static final long serialVersionUID = -7978723352517770644L;

            protected void onSubmit(AjaxRequestTarget target) {
                ((List)AbstractMultiPanel.this.view.getModel().getObject()).remove(item.getModelObject());
                AbstractMultiPanel.this.clearInput(panel);
                if (((List)AbstractMultiPanel.this.view.getModel().getObject()).isEmpty()) {
                    AbstractMultiPanel.this.form.addOrReplace(new Component[]{AbstractMultiPanel.this.getNoDataFragment(label)});
                }
                target.add(new Component[]{AbstractMultiPanel.this.container});
            }

            protected void onError(AjaxRequestTarget target) {
                this.onSubmit(target);
            }
        };
        Fragment fragment = new Fragment("panelMinus", "fragmentMinus", (MarkupContainer)this);
        fragment.addOrReplace(new Component[]{minus});
        fragment.setRenderBodyOnly(true);
        fragment.setOutputMarkupPlaceholderTag(true);
        fragment.setVisible(this.container.isEnabled() && this.form.isEnabled());
        return fragment;
    }

    private Fragment getFragmentPlus() {
        IndicatorAjaxSubmitLink plus = new IndicatorAjaxSubmitLink("add"){
            private static final long serialVersionUID = -7978723352517770644L;

            protected void onSubmit(AjaxRequestTarget target) {
                ((List)AbstractMultiPanel.this.view.getModel().getObject()).add(AbstractMultiPanel.this.newModelObject());
                if (((List)AbstractMultiPanel.this.view.getModel().getObject()).size() == 1) {
                    AbstractMultiPanel.this.form.addOrReplace(new Component[]{AbstractMultiPanel.this.getDataFragment()});
                }
                target.add(new Component[]{AbstractMultiPanel.this.container});
            }

            protected void onError(AjaxRequestTarget target) {
                AbstractMultiPanel.this.sendError(this.getString("operation_error"));
                super.onError(target);
                ((BaseWebPage)this.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        };
        Fragment fragment = new Fragment("panelPlus", "fragmentPlus", (MarkupContainer)this);
        fragment.addOrReplace(new Component[]{plus});
        fragment.setRenderBodyOnly(true);
        fragment.setOutputMarkupPlaceholderTag(true);
        fragment.setVisible(this.container.isEnabled() && this.form.isEnabled());
        return fragment;
    }

    public ListView<INNER> getView() {
        return this.view;
    }

    @Override
    public AbstractMultiPanel<INNER> setModelObject(List<INNER> object) {
        this.view.setModelObject(object);
        return this;
    }

    protected abstract INNER newModelObject();

    protected abstract void sendError(String var1);

    protected abstract Panel getItemPanel(ListItem<INNER> var1);

    protected void clearInput(Panel panel) {
    }

    @Override
    public AbstractFieldPanel<List<INNER>> setReadOnly(boolean readOnly) {
        this.container.setEnabled(!readOnly);
        return this;
    }

    public AbstractFieldPanel<List<INNER>> setFormReadOnly(boolean readOnly) {
        this.form.setEnabled(!readOnly);
        return this;
    }

    private final class InnerView
    extends ListView<INNER> {
        private static final long serialVersionUID = -9180479401817023838L;
        private final String label;
        private final IModel<List<INNER>> model;

        private InnerView(String id, String label, IModel<List<INNER>> model) {
            super(id, model);
            this.label = label;
            this.model = model;
        }

        protected void populateItem(ListItem<INNER> item) {
            Panel panel = AbstractMultiPanel.this.getItemPanel(item);
            item.add(new Component[]{panel.setRenderBodyOnly(true)});
            item.add(new Component[]{AbstractMultiPanel.this.getFragmentMinus(item, panel, this.label)});
            Fragment plus = item.getIndex() == ((List)this.model.getObject()).size() - 1 ? AbstractMultiPanel.this.getFragmentPlus() : new Fragment("panelPlus", "emptyFragment", (MarkupContainer)AbstractMultiPanel.this);
            item.add(new Component[]{plus.setRenderBodyOnly(true)});
        }
    }
}

