/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.InternalSDKHelper;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.LDAPURL;
import com.unboundid.ldap.sdk.PLAINBindRequest;
import com.unboundid.ldap.sdk.PooledReferralConnector;
import com.unboundid.ldap.sdk.PostConnectProcessor;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SASLBindRequest;
import com.unboundid.ldap.sdk.SCRAMBindRequest;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import com.unboundid.ldap.sdk.SingleServerSet;
import com.unboundid.ldap.sdk.StartTLSPostConnectProcessor;
import com.unboundid.ldap.sdk.extensions.StartTLSExtendedRequest;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.Validator;
import com.unboundid.util.ssl.AggregateTrustManager;
import com.unboundid.util.ssl.SSLUtil;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;

final class ReferralConnectionPool {
    @NotNull
    private final AtomicReference<Long> lastUsedTimeMillisRef;
    private final boolean checkAuthenticationID;
    private final int serverPort;
    @NotNull
    private final LDAPConnectionPool connectionPool;
    private final long poolCreateTimeMillis;
    @NotNull
    private final PooledReferralConnector referralConnector;
    @NotNull
    private final String serverAddress;
    @Nullable
    private final String authenticationIdentifier;

    ReferralConnectionPool(@NotNull LDAPURL referralURL, @NotNull LDAPConnection connection, @NotNull PooledReferralConnector referralConnector) throws LDAPException {
        this.referralConnector = referralConnector;
        this.serverAddress = referralURL.getHost();
        this.serverPort = referralURL.getPort();
        BindRequest bindRequest = referralConnector.getBindRequest();
        if (bindRequest == null) {
            bindRequest = connection.getLastBindRequest();
            this.checkAuthenticationID = true;
            if (bindRequest == null) {
                this.authenticationIdentifier = "";
            } else {
                this.authenticationIdentifier = ReferralConnectionPool.getAuthenticationIdentifier(connection);
                if (this.authenticationIdentifier == null) {
                    String authenticationType = "SASL " + ((SASLBindRequest)bindRequest).getSASLMechanismName();
                    throw new LDAPException(ResultCode.AUTH_METHOD_NOT_SUPPORTED, LDAPMessages.ERR_REFERRAL_POOL_UNSUPPORTED_BIND_TYPE.get(authenticationType));
                }
            }
        } else {
            this.authenticationIdentifier = null;
            this.checkAuthenticationID = false;
        }
        SocketFactory socketFactory = this.getSocketFactory(referralURL, connection);
        LDAPConnectionOptions connectionOptions = this.getConnectionOptions(connection);
        PostConnectProcessor postConnectProcessor = this.getPostConnectProcessor(referralURL, connection);
        SingleServerSet serverSet = new SingleServerSet(this.serverAddress, this.serverPort, socketFactory, connectionOptions, bindRequest, postConnectProcessor);
        this.connectionPool = new LDAPConnectionPool(serverSet, bindRequest, referralConnector.getInitialConnectionsPerPool(), referralConnector.getMaximumConnectionsPerPool(), 1, null, false, referralConnector.getHealthCheck());
        this.connectionPool.setRetryFailedOperationsDueToInvalidConnections(referralConnector.retryFailedOperationsDueToInvalidConnections());
        this.connectionPool.setHealthCheckIntervalMillis(referralConnector.getHealthCheckIntervalMillis());
        this.connectionPool.setMaxConnectionAgeMillis(referralConnector.getMaximumConnectionAgeMillis());
        this.poolCreateTimeMillis = System.currentTimeMillis();
        this.lastUsedTimeMillisRef = new AtomicReference<Long>(this.poolCreateTimeMillis);
    }

    @NotNull
    private SocketFactory getSocketFactory(@NotNull LDAPURL referralURL, @NotNull LDAPConnection connection) throws LDAPException {
        if (this.useLDAPS(referralURL, connection)) {
            return this.getSSLSocketFactory(connection);
        }
        SocketFactory connectionSocketFactory = connection.getSocketFactory();
        if (!(connectionSocketFactory instanceof SSLSocketFactory)) {
            return connectionSocketFactory;
        }
        return SocketFactory.getDefault();
    }

    private boolean useLDAPS(@NotNull LDAPURL referralURL, @NotNull LDAPConnection connection) {
        if (referralURL.getScheme().equalsIgnoreCase("ldaps")) {
            return true;
        }
        switch (this.referralConnector.getLDAPURLSecurityType()) {
            case ALWAYS_USE_LDAPS: {
                return true;
            }
            case ALWAYS_USE_LDAP_AND_NEVER_USE_START_TLS: 
            case ALWAYS_USE_LDAP_AND_ALWAYS_USE_START_TLS: 
            case ALWAYS_USE_LDAP_AND_CONDITIONALLY_USE_START_TLS: {
                return false;
            }
            case CONDITIONALLY_USE_LDAP_AND_NEVER_USE_START_TLS: 
            case CONDITIONALLY_USE_LDAP_AND_ALWAYS_USE_START_TLS: 
            case CONDITIONALLY_USE_LDAP_AND_CONDITIONALLY_USE_START_TLS: {
                SocketFactory socketFactory = connection.getSocketFactory();
                return socketFactory instanceof SSLSocketFactory;
            }
        }
        Validator.violation("Unrecognized ldapURLSecurityType value '" + this.referralConnector.getLDAPURLSecurityType().name() + "'.");
        return false;
    }

    private boolean useStartTLS(@NotNull LDAPURL referralURL, @NotNull LDAPConnection connection) {
        if (referralURL.getScheme().equalsIgnoreCase("ldaps")) {
            return false;
        }
        switch (this.referralConnector.getLDAPURLSecurityType()) {
            case ALWAYS_USE_LDAPS: {
                return false;
            }
            case ALWAYS_USE_LDAP_AND_NEVER_USE_START_TLS: 
            case CONDITIONALLY_USE_LDAP_AND_NEVER_USE_START_TLS: {
                return false;
            }
            case ALWAYS_USE_LDAP_AND_ALWAYS_USE_START_TLS: {
                return true;
            }
            case ALWAYS_USE_LDAP_AND_CONDITIONALLY_USE_START_TLS: 
            case CONDITIONALLY_USE_LDAP_AND_CONDITIONALLY_USE_START_TLS: {
                return connection.getStartTLSRequest() != null;
            }
            case CONDITIONALLY_USE_LDAP_AND_ALWAYS_USE_START_TLS: {
                SocketFactory socketFactory = connection.getSocketFactory();
                return !(socketFactory instanceof SSLSocketFactory);
            }
        }
        Validator.violation("Unrecognized ldapURLSecurityType value '" + this.referralConnector.getLDAPURLSecurityType().name() + "'.");
        return false;
    }

    @NotNull
    private SSLSocketFactory getSSLSocketFactory(@NotNull LDAPConnection connection) throws LDAPException {
        SSLSocketFactory explicitlyConfiguredSSLSocketFactory = this.referralConnector.getSSLSocketFactory();
        if (explicitlyConfiguredSSLSocketFactory != null) {
            return explicitlyConfiguredSSLSocketFactory;
        }
        SocketFactory connectionSocketFactory = connection.getSocketFactory();
        if (connectionSocketFactory instanceof SSLSocketFactory) {
            return (SSLSocketFactory)connectionSocketFactory;
        }
        ExtendedRequest startTLSRequest = connection.getStartTLSRequest();
        if (startTLSRequest != null && startTLSRequest instanceof StartTLSExtendedRequest) {
            return ((StartTLSExtendedRequest)startTLSRequest).getSSLSocketFactory();
        }
        AggregateTrustManager preferredTrustManagerChain = InternalSDKHelper.getPreferredNonInteractiveTrustManagerChain(new X509TrustManager[0]);
        SSLUtil sslUtil = new SSLUtil(preferredTrustManagerChain);
        try {
            return sslUtil.createSSLSocketFactory();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.CONNECT_ERROR, LDAPMessages.ERR_REFERRAL_POOL_CANNOT_CREATE_SSL_SOCKET_FACTORY.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    private LDAPConnectionOptions getConnectionOptions(@NotNull LDAPConnection connection) {
        LDAPConnectionOptions explicitlyConfiguredConnectionOptions = this.referralConnector.getConnectionOptions();
        LDAPConnectionOptions poolConnectionOptions = explicitlyConfiguredConnectionOptions != null ? explicitlyConfiguredConnectionOptions.duplicate() : connection.getConnectionOptions().duplicate();
        poolConnectionOptions.setFollowReferrals(false);
        poolConnectionOptions.setReferralConnector(null);
        return poolConnectionOptions;
    }

    @Nullable
    private PostConnectProcessor getPostConnectProcessor(@NotNull LDAPURL referralURL, @NotNull LDAPConnection connection) throws LDAPException {
        if (this.useStartTLS(referralURL, connection)) {
            return new StartTLSPostConnectProcessor(this.getSSLSocketFactory(connection));
        }
        return null;
    }

    void close() {
        this.connectionPool.close();
    }

    boolean isApplicableToReferral(@NotNull LDAPURL referralURL, @NotNull LDAPConnection connection) {
        if (!this.serverAddress.equals(referralURL.getHost())) {
            return false;
        }
        if (this.serverPort != referralURL.getPort()) {
            return false;
        }
        return !this.checkAuthenticationID || this.authenticationIdentifier.equals(ReferralConnectionPool.getAuthenticationIdentifier(connection));
    }

    @Nullable
    private static String getAuthenticationIdentifier(@NotNull LDAPConnection connection) {
        BindRequest bindRequest = connection.getLastBindRequest();
        if (bindRequest == null) {
            return "";
        }
        if (bindRequest instanceof SimpleBindRequest) {
            SimpleBindRequest simpleBindRequest = (SimpleBindRequest)bindRequest;
            try {
                return "dn:" + DN.normalize(simpleBindRequest.getBindDN());
            }
            catch (Exception e) {
                Debug.debugException(e);
                return simpleBindRequest.getBindDN();
            }
        }
        if (bindRequest instanceof PLAINBindRequest) {
            PLAINBindRequest plainBindRequest = (PLAINBindRequest)bindRequest;
            if (plainBindRequest.getAuthorizationID() == null) {
                return ReferralConnectionPool.getAuthenticationIdentifier(plainBindRequest.getAuthenticationID());
            }
            return ReferralConnectionPool.getAuthenticationIdentifier(plainBindRequest.getAuthorizationID());
        }
        if (bindRequest instanceof SCRAMBindRequest) {
            SCRAMBindRequest scramBindRequest = (SCRAMBindRequest)bindRequest;
            return ReferralConnectionPool.getAuthenticationIdentifier(scramBindRequest.getUsername());
        }
        return null;
    }

    @NotNull
    private static String getAuthenticationIdentifier(@NotNull String id) {
        if (id.startsWith("dn:")) {
            String dnString = id.substring(3);
            try {
                return "dn:" + new DN(dnString).toNormalizedString();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        return id;
    }

    @NotNull
    LDAPConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    long getPoolCreateTimeMillis() {
        return this.poolCreateTimeMillis;
    }

    long getLastUsedTimeMillis() {
        return this.lastUsedTimeMillisRef.get();
    }
}

