/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.persistence.Query;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.SyncopeConstants;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.persistence.api.attrvalue.validation.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.DynRealmDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.search.AnyCond;
import org.apache.syncope.core.persistence.api.dao.search.AnyTypeCond;
import org.apache.syncope.core.persistence.api.dao.search.AttrCond;
import org.apache.syncope.core.persistence.api.dao.search.AuxClassCond;
import org.apache.syncope.core.persistence.api.dao.search.DynRealmCond;
import org.apache.syncope.core.persistence.api.dao.search.MemberCond;
import org.apache.syncope.core.persistence.api.dao.search.MembershipCond;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.api.dao.search.PrivilegeCond;
import org.apache.syncope.core.persistence.api.dao.search.RelationshipCond;
import org.apache.syncope.core.persistence.api.dao.search.RelationshipTypeCond;
import org.apache.syncope.core.persistence.api.dao.search.ResourceCond;
import org.apache.syncope.core.persistence.api.dao.search.RoleCond;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.DynRealm;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.jpa.dao.AbstractAnySearchDAO;
import org.apache.syncope.core.persistence.jpa.dao.AnySearchNode;
import org.apache.syncope.core.persistence.jpa.dao.OrderBySupport;
import org.apache.syncope.core.persistence.jpa.dao.SearchSupport;
import org.apache.syncope.core.persistence.jpa.dao.SearchViewSupport;
import org.apache.syncope.core.provisioning.api.utils.RealmUtils;

public class JPAAnySearchDAO
extends AbstractAnySearchDAO {
    protected static final String SELECT_COLS_FROM_VIEW = "any_id,creationContext,creationDate,creator,lastChangeContext,lastChangeDate,lastModifier,status,changePwdDate,cipherAlgorithm,failedLogins,lastLoginDate,mustChangePassword,suspended,username";
    protected static final String ALWAYS_FALSE_CLAUSE = "1=2";

    protected static int setParameter(List<Object> parameters, Object parameter) {
        parameters.add(parameter);
        return parameters.size();
    }

    protected static void fillWithParameters(Query query, List<Object> parameters) {
        for (int i = 0; i < parameters.size(); ++i) {
            if (parameters.get(i) instanceof Boolean) {
                query.setParameter(i + 1, (Object)((Boolean)parameters.get(i) != false ? 1 : 0));
                continue;
            }
            query.setParameter(i + 1, parameters.get(i));
        }
    }

    protected static String key(AttrSchemaType schemaType) {
        String key;
        switch (schemaType) {
            case Boolean: {
                key = "booleanValue";
                break;
            }
            case Date: {
                key = "dateValue";
                break;
            }
            case Double: {
                key = "doubleValue";
                break;
            }
            case Long: {
                key = "longValue";
                break;
            }
            case Binary: {
                key = "binaryValue";
                break;
            }
            default: {
                key = "stringValue";
            }
        }
        return key;
    }

    protected static Supplier<SyncopeClientException> syncopeClientException(String message) {
        return () -> {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidSearchParameters);
            sce.getElements().add(message);
            return sce;
        };
    }

    public JPAAnySearchDAO(RealmDAO realmDAO, DynRealmDAO dynRealmDAO, UserDAO userDAO, GroupDAO groupDAO, AnyObjectDAO anyObjectDAO, PlainSchemaDAO plainSchemaDAO, EntityFactory entityFactory, AnyUtilsFactory anyUtilsFactory, PlainAttrValidationManager validator) {
        super(realmDAO, dynRealmDAO, userDAO, groupDAO, anyObjectDAO, plainSchemaDAO, entityFactory, anyUtilsFactory, validator);
    }

    protected SearchSupport.SearchView defaultSV(SearchSupport svs) {
        return svs.field();
    }

    protected String anyId(SearchSupport.SearchView sv) {
        return sv.alias + ".any_id";
    }

    protected String anyId(SearchSupport svs) {
        return this.anyId(this.defaultSV(svs));
    }

    protected Optional<AnySearchNode> getQueryForCustomConds(SearchCond cond, List<Object> parameters, SearchSupport svs, boolean not) {
        return Optional.empty();
    }

    protected Optional<Pair<AnySearchNode, Set<String>>> getQuery(SearchCond cond, List<Object> parameters, SearchSupport svs) {
        boolean not = cond.getType() == SearchCond.Type.NOT_LEAF;
        Optional<Object> node = Optional.empty();
        HashSet plainSchemas = new HashSet();
        switch (cond.getType()) {
            case LEAF: 
            case NOT_LEAF: {
                if (node.isEmpty()) {
                    node = cond.getLeaf(AnyTypeCond.class).filter(leaf -> AnyTypeKind.ANY_OBJECT == svs.anyTypeKind).map(leaf -> this.getQuery((AnyTypeCond)leaf, not, parameters, svs));
                }
                if (node.isEmpty()) {
                    node = cond.getLeaf(AuxClassCond.class).map(leaf -> this.getQuery((AuxClassCond)leaf, not, parameters, svs));
                }
                if (node.isEmpty()) {
                    node = cond.getLeaf(RelationshipTypeCond.class).map(leaf -> this.getQuery((RelationshipTypeCond)leaf, not, parameters, svs));
                }
                if (node.isEmpty()) {
                    node = cond.getLeaf(RelationshipCond.class).map(leaf -> this.getQuery((RelationshipCond)leaf, not, parameters, svs));
                }
                if (node.isEmpty()) {
                    node = cond.getLeaf(MembershipCond.class).map(leaf -> this.getQuery((MembershipCond)leaf, not, parameters, svs));
                }
                if (node.isEmpty()) {
                    node = cond.getLeaf(MemberCond.class).map(leaf -> this.getQuery((MemberCond)leaf, not, parameters, svs));
                }
                if (node.isEmpty()) {
                    node = cond.getLeaf(RoleCond.class).filter(leaf -> AnyTypeKind.USER == svs.anyTypeKind).map(leaf -> this.getQuery((RoleCond)leaf, not, parameters, svs));
                }
                if (node.isEmpty()) {
                    node = cond.getLeaf(PrivilegeCond.class).filter(leaf -> AnyTypeKind.USER == svs.anyTypeKind).map(leaf -> this.getQuery((PrivilegeCond)leaf, not, parameters, svs));
                }
                if (node.isEmpty()) {
                    node = cond.getLeaf(DynRealmCond.class).map(leaf -> this.getQuery((DynRealmCond)leaf, not, parameters, svs));
                }
                if (node.isEmpty()) {
                    node = cond.getLeaf(ResourceCond.class).map(leaf -> this.getQuery((ResourceCond)leaf, not, parameters, svs));
                }
                if (node.isEmpty()) {
                    node = cond.getLeaf(AnyCond.class).map(anyCond -> this.getQuery((AnyCond)anyCond, not, parameters, svs)).or(() -> cond.getLeaf(AttrCond.class).map(attrCond -> {
                        Pair<PlainSchema, PlainAttrValue> checked = this.check((AttrCond)attrCond, svs.anyTypeKind);
                        plainSchemas.add(((PlainSchema)checked.getLeft()).getKey());
                        return this.getQuery((AttrCond)attrCond, not, checked, parameters, svs);
                    }));
                }
                if (!node.isEmpty()) break;
                node = this.getQueryForCustomConds(cond, parameters, svs, not);
                break;
            }
            case AND: {
                AnySearchNode andNode = new AnySearchNode(AnySearchNode.Type.AND);
                this.getQuery(cond.getLeft(), parameters, svs).ifPresent(left -> {
                    andNode.add((AnySearchNode)left.getLeft());
                    plainSchemas.addAll((Collection)left.getRight());
                });
                this.getQuery(cond.getRight(), parameters, svs).ifPresent(right -> {
                    andNode.add((AnySearchNode)right.getLeft());
                    plainSchemas.addAll((Collection)right.getRight());
                });
                if (andNode.getChildren().isEmpty()) break;
                node = Optional.of(andNode);
                break;
            }
            case OR: {
                AnySearchNode orNode = new AnySearchNode(AnySearchNode.Type.OR);
                this.getQuery(cond.getLeft(), parameters, svs).ifPresent(left -> {
                    orNode.add((AnySearchNode)left.getLeft());
                    plainSchemas.addAll((Collection)left.getRight());
                });
                this.getQuery(cond.getRight(), parameters, svs).ifPresent(right -> {
                    orNode.add((AnySearchNode)right.getLeft());
                    plainSchemas.addAll((Collection)right.getRight());
                });
                if (orNode.getChildren().isEmpty()) break;
                node = Optional.of(orNode);
                break;
            }
        }
        return node.map(n -> Pair.of((Object)n, (Object)plainSchemas));
    }

    protected AnySearchNode getQuery(AnyTypeCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        StringBuilder clause = new StringBuilder("type_id");
        if (not) {
            clause.append("<>");
        } else {
            clause.append('=');
        }
        clause.append('?').append(JPAAnySearchDAO.setParameter(parameters, cond.getAnyTypeKey()));
        return new AnySearchNode.Leaf(this.defaultSV(svs), clause.toString());
    }

    protected AnySearchNode getQuery(AuxClassCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        StringBuilder clause = new StringBuilder();
        if (not) {
            clause.append(this.anyId(svs)).append(" NOT IN (");
        } else {
            clause.append(this.anyId(svs)).append(" IN (");
        }
        clause.append("SELECT any_id FROM ").append(svs.auxClass().name).append(" WHERE anyTypeClass_id=?").append(JPAAnySearchDAO.setParameter(parameters, cond.getAuxClass())).append(')');
        return new AnySearchNode.Leaf(this.defaultSV(svs), clause.toString());
    }

    protected AnySearchNode getQuery(RelationshipTypeCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        StringBuilder clause = new StringBuilder();
        if (not) {
            clause.append(this.anyId(svs)).append(" NOT IN (");
        } else {
            clause.append(this.anyId(svs)).append(" IN (");
        }
        clause.append("SELECT any_id ").append("FROM ").append(svs.relationship().name).append(" WHERE type=?").append(JPAAnySearchDAO.setParameter(parameters, cond.getRelationshipTypeKey())).append(" UNION SELECT right_any_id AS any_id FROM ").append(svs.relationship().name).append(" WHERE type=?").append(JPAAnySearchDAO.setParameter(parameters, cond.getRelationshipTypeKey())).append(')');
        return new AnySearchNode.Leaf(this.defaultSV(svs), clause.toString());
    }

    protected AnySearchNode getQuery(RelationshipCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        Set<String> rightAnyObjects = this.check(cond);
        StringBuilder clause = new StringBuilder();
        if (not) {
            clause.append(this.anyId(svs)).append(" NOT IN (");
        } else {
            clause.append(this.anyId(svs)).append(" IN (");
        }
        clause.append("SELECT DISTINCT any_id FROM ").append(svs.relationship().name).append(" WHERE ").append(rightAnyObjects.stream().map(key -> "right_any_id=?" + JPAAnySearchDAO.setParameter(parameters, key)).collect(Collectors.joining(" OR "))).append(')');
        return new AnySearchNode.Leaf(this.defaultSV(svs), clause.toString());
    }

    protected AnySearchNode getQuery(MembershipCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        List<String> groupKeys = this.check(cond);
        String subwhere = groupKeys.stream().map(key -> "group_id=?" + JPAAnySearchDAO.setParameter(parameters, key)).collect(Collectors.joining(" OR "));
        StringBuilder clause = new StringBuilder("(");
        if (not) {
            clause.append(this.anyId(svs)).append(" NOT IN (");
        } else {
            clause.append(this.anyId(svs)).append(" IN (");
        }
        clause.append("SELECT DISTINCT any_id FROM ").append(svs.membership().name).append(" WHERE ").append(subwhere).append(") ");
        if (not) {
            clause.append("AND ").append(this.anyId(svs)).append(" NOT IN (");
        } else {
            clause.append("OR ").append(this.anyId(svs)).append(" IN (");
        }
        clause.append("SELECT DISTINCT any_id FROM ").append(svs.dyngroupmembership().name).append(" WHERE ").append(subwhere).append("))");
        return new AnySearchNode.Leaf(this.defaultSV(svs), clause.toString());
    }

    protected AnySearchNode getQuery(RoleCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        StringBuilder clause = new StringBuilder("(");
        if (not) {
            clause.append(this.anyId(svs)).append(" NOT IN (");
        } else {
            clause.append(this.anyId(svs)).append(" IN (");
        }
        clause.append("SELECT DISTINCT any_id FROM ").append(svs.role().name).append(" WHERE ").append("role_id=?").append(JPAAnySearchDAO.setParameter(parameters, cond.getRole())).append(") ");
        if (not) {
            clause.append("AND ").append(this.anyId(svs)).append(" NOT IN (");
        } else {
            clause.append("OR ").append(this.anyId(svs)).append(" IN (");
        }
        clause.append("SELECT DISTINCT any_id FROM ").append(SearchSupport.dynrolemembership().name).append(" WHERE ").append("role_id=?").append(JPAAnySearchDAO.setParameter(parameters, cond.getRole())).append("))");
        return new AnySearchNode.Leaf(this.defaultSV(svs), clause.toString());
    }

    protected AnySearchNode getQuery(PrivilegeCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        StringBuilder clause = new StringBuilder("(");
        if (not) {
            clause.append(this.anyId(svs)).append(" NOT IN (");
        } else {
            clause.append(this.anyId(svs)).append(" IN (");
        }
        clause.append("SELECT DISTINCT any_id FROM ").append(svs.priv().name).append(" WHERE ").append("privilege_id=?").append(JPAAnySearchDAO.setParameter(parameters, cond.getPrivilege())).append(") ");
        if (not) {
            clause.append("AND ").append(this.anyId(svs)).append(" NOT IN (");
        } else {
            clause.append("OR ").append(this.anyId(svs)).append(" IN (");
        }
        clause.append("SELECT DISTINCT any_id FROM ").append(svs.dynpriv().name).append(" WHERE ").append("privilege_id=?").append(JPAAnySearchDAO.setParameter(parameters, cond.getPrivilege())).append("))");
        return new AnySearchNode.Leaf(this.defaultSV(svs), clause.toString());
    }

    protected AnySearchNode getQuery(DynRealmCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        StringBuilder clause = new StringBuilder("(");
        if (not) {
            clause.append(this.anyId(svs)).append(" NOT IN (");
        } else {
            clause.append(this.anyId(svs)).append(" IN (");
        }
        clause.append("SELECT DISTINCT any_id FROM ").append(SearchSupport.dynrealmmembership().name).append(" WHERE ").append("dynRealm_id=?").append(JPAAnySearchDAO.setParameter(parameters, cond.getDynRealm())).append("))");
        return new AnySearchNode.Leaf(this.defaultSV(svs), clause.toString());
    }

    protected AnySearchNode getQuery(ResourceCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        StringBuilder clause = new StringBuilder();
        if (not) {
            clause.append(this.anyId(svs)).append(" NOT IN (");
        } else {
            clause.append(this.anyId(svs)).append(" IN (");
        }
        clause.append("SELECT DISTINCT any_id FROM ").append(svs.resource().name).append(" WHERE resource_id=?").append(JPAAnySearchDAO.setParameter(parameters, cond.getResource()));
        if (svs.anyTypeKind == AnyTypeKind.USER || svs.anyTypeKind == AnyTypeKind.ANY_OBJECT) {
            clause.append(" UNION SELECT DISTINCT any_id FROM ").append(svs.groupResource().name).append(" WHERE resource_id=?").append(JPAAnySearchDAO.setParameter(parameters, cond.getResource()));
        }
        clause.append(')');
        return new AnySearchNode.Leaf(this.defaultSV(svs), clause.toString());
    }

    protected AnySearchNode getQuery(MemberCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        Set<String> members = this.check(cond);
        StringBuilder clause = new StringBuilder();
        if (not) {
            clause.append(this.anyId(svs)).append(" NOT IN (");
        } else {
            clause.append(this.anyId(svs)).append(" IN (");
        }
        clause.append("SELECT DISTINCT group_id AS any_id FROM ").append(new SearchSupport((AnyTypeKind)AnyTypeKind.USER).membership().name).append(" WHERE ").append(members.stream().map(key -> "any_id=?" + JPAAnySearchDAO.setParameter(parameters, key)).collect(Collectors.joining(" OR "))).append(") ");
        if (not) {
            clause.append("AND ").append(this.anyId(svs)).append(" NOT IN (");
        } else {
            clause.append("OR ").append(this.anyId(svs)).append(" IN (");
        }
        clause.append("SELECT DISTINCT group_id AS any_id FROM ").append(new SearchSupport((AnyTypeKind)AnyTypeKind.ANY_OBJECT).membership().name).append(" WHERE ").append(members.stream().map(key -> "any_id=?" + JPAAnySearchDAO.setParameter(parameters, key)).collect(Collectors.joining(" OR "))).append(')');
        return new AnySearchNode.Leaf(this.defaultSV(svs), clause.toString());
    }

    protected AnySearchNode.Leaf fillAttrQuery(String column, SearchSupport.SearchView from, PlainAttrValue attrValue, PlainSchema schema, AttrCond cond, boolean not, List<Object> parameters) {
        boolean ignoreCase = AttrCond.Type.ILIKE == cond.getType() || AttrCond.Type.IEQ == cond.getType();
        Object left = column;
        if (ignoreCase && (schema.getType() == AttrSchemaType.String || schema.getType() == AttrSchemaType.Enum)) {
            left = "LOWER(" + (String)left + ")";
        }
        StringBuilder clause = new StringBuilder((String)left);
        switch (cond.getType()) {
            case ILIKE: 
            case LIKE: {
                if (schema.getType() == AttrSchemaType.String || schema.getType() == AttrSchemaType.Enum) {
                    if (not) {
                        clause.append(" NOT ");
                    }
                    clause.append(" LIKE ");
                    if (ignoreCase) {
                        clause.append("LOWER(?").append(JPAAnySearchDAO.setParameter(parameters, cond.getExpression())).append(')');
                    } else {
                        clause.append('?').append(JPAAnySearchDAO.setParameter(parameters, cond.getExpression()));
                    }
                    if (!this.isOracle()) break;
                    clause.append(" ESCAPE '\\' ");
                    break;
                }
                LOG.error("LIKE is only compatible with string or enum schemas");
                return new AnySearchNode.Leaf(from, ALWAYS_FALSE_CLAUSE);
            }
            default: {
                if (not) {
                    clause.append("<>");
                } else {
                    clause.append('=');
                }
                if (ignoreCase && (schema.getType() == AttrSchemaType.String || schema.getType() == AttrSchemaType.Enum)) {
                    clause.append("LOWER(?").append(JPAAnySearchDAO.setParameter(parameters, attrValue.getValue())).append(')');
                    break;
                }
                clause.append('?').append(JPAAnySearchDAO.setParameter(parameters, attrValue.getValue()));
                break;
            }
            case GE: {
                if (not) {
                    clause.append('<');
                } else {
                    clause.append(">=");
                }
                clause.append('?').append(JPAAnySearchDAO.setParameter(parameters, attrValue.getValue()));
                break;
            }
            case GT: {
                if (not) {
                    clause.append("<=");
                } else {
                    clause.append('>');
                }
                clause.append('?').append(JPAAnySearchDAO.setParameter(parameters, attrValue.getValue()));
                break;
            }
            case LE: {
                if (not) {
                    clause.append('>');
                } else {
                    clause.append("<=");
                }
                clause.append('?').append(JPAAnySearchDAO.setParameter(parameters, attrValue.getValue()));
                break;
            }
            case LT: {
                if (not) {
                    clause.append(">=");
                } else {
                    clause.append('<');
                }
                clause.append('?').append(JPAAnySearchDAO.setParameter(parameters, attrValue.getValue()));
            }
        }
        return new AnySearchNode.Leaf(from, (String)(cond instanceof AnyCond ? clause.toString() : from.alias + ".schema_id='" + schema.getKey() + "' AND " + String.valueOf(clause)));
    }

    protected AnySearchNode getQuery(AttrCond cond, boolean not, Pair<PlainSchema, PlainAttrValue> checked, List<Object> parameters, SearchSupport svs) {
        AnySearchNode.Leaf node;
        if (not) {
            if (cond.getType() == AttrCond.Type.ISNULL) {
                cond.setType(AttrCond.Type.ISNOTNULL);
            } else if (cond.getType() == AttrCond.Type.ISNOTNULL) {
                cond.setType(AttrCond.Type.ISNULL);
            }
        }
        SearchSupport.SearchView sv = ((PlainSchema)checked.getLeft()).isUniqueConstraint() ? svs.asSearchViewSupport().uniqueAttr() : svs.asSearchViewSupport().attr();
        switch (cond.getType()) {
            case ISNOTNULL: {
                return new AnySearchNode.Leaf(sv, sv.alias + ".schema_id='" + ((PlainSchema)checked.getLeft()).getKey() + "'");
            }
            case ISNULL: {
                String clause = this.anyId(svs) + " NOT IN " + '(' + "SELECT DISTINCT any_id FROM " + sv.name + " WHERE schema_id=" + "'" + ((PlainSchema)checked.getLeft()).getKey() + "'" + ')';
                return new AnySearchNode.Leaf(this.defaultSV(svs), clause);
            }
        }
        if (not && ((PlainSchema)checked.getLeft()).isMultivalue()) {
            AnySearchNode.Leaf notNode = this.fillAttrQuery(sv.alias + "." + JPAAnySearchDAO.key(((PlainSchema)checked.getLeft()).getType()), sv, (PlainAttrValue)checked.getRight(), (PlainSchema)checked.getLeft(), cond, false, parameters);
            node = new AnySearchNode.Leaf(sv, this.anyId(svs) + " NOT IN (SELECT any_id FROM " + sv.name + " WHERE " + notNode.getClause().replace(sv.alias + ".", "") + ")");
        } else {
            node = this.fillAttrQuery(sv.alias + "." + JPAAnySearchDAO.key(((PlainSchema)checked.getLeft()).getType()), sv, (PlainAttrValue)checked.getRight(), (PlainSchema)checked.getLeft(), cond, not, parameters);
        }
        return node;
    }

    protected AnySearchNode getQuery(AnyCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        if ("realm".equals(cond.getSchema()) && !SyncopeConstants.UUID_PATTERN.matcher(cond.getExpression()).matches()) {
            Realm realm = this.realmDAO.findByFullPath(cond.getExpression());
            if (realm == null) {
                throw new IllegalArgumentException("Invalid Realm full path: " + cond.getExpression());
            }
            cond.setExpression(realm.getKey());
        }
        Triple<PlainSchema, PlainAttrValue, AnyCond> checked = this.check(cond, svs.anyTypeKind);
        switch (((AnyCond)checked.getRight()).getType()) {
            case ISNULL: {
                return new AnySearchNode.Leaf(this.defaultSV(svs), ((AnyCond)checked.getRight()).getSchema() + (not ? " IS NOT NULL" : " IS NULL"));
            }
            case ISNOTNULL: {
                return new AnySearchNode.Leaf(this.defaultSV(svs), ((AnyCond)checked.getRight()).getSchema() + (not ? " IS NULL" : " IS NOT NULL"));
            }
        }
        return this.fillAttrQuery(((AnyCond)checked.getRight()).getSchema(), this.defaultSV(svs), (PlainAttrValue)checked.getMiddle(), (PlainSchema)checked.getLeft(), (AttrCond)checked.getRight(), not, parameters);
    }

    protected AnySearchNode.Leaf buildAdminRealmsFilter(Set<String> realmKeys, SearchSupport svs, List<Object> parameters) {
        if (realmKeys.isEmpty()) {
            return new AnySearchNode.Leaf(this.defaultSV(svs), StringUtils.substringAfter((String)this.anyId(svs), (int)46) + " IS NOT NULL");
        }
        String realmKeysArg = realmKeys.stream().map(realmKey -> "?" + JPAAnySearchDAO.setParameter(parameters, realmKey)).collect(Collectors.joining(","));
        return new AnySearchNode.Leaf(this.defaultSV(svs), "realm_id IN (" + realmKeysArg + ")");
    }

    protected Triple<AnySearchNode.Leaf, Set<String>, Set<String>> getAdminRealmsFilter(Realm base, boolean recursive, Set<String> adminRealms, List<Object> parameters, SearchSupport svs) {
        HashSet<String> realmKeys = new HashSet<String>();
        HashSet dynRealmKeys = new HashSet();
        HashSet groupOwners = new HashSet();
        if (recursive) {
            adminRealms.forEach(realmPath -> RealmUtils.parseGroupOwnerRealm((String)realmPath).ifPresentOrElse(goRealm -> groupOwners.add((String)goRealm.getRight()), () -> {
                if (realmPath.startsWith("/")) {
                    Realm realm = Optional.ofNullable(this.realmDAO.findByFullPath(realmPath)).orElseThrow(() -> {
                        SyncopeClientException noRealm = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRealm);
                        noRealm.getElements().add("Invalid realm specified: " + realmPath);
                        return noRealm;
                    });
                    realmKeys.addAll(this.realmDAO.findDescendants(realm.getFullPath(), base.getFullPath()));
                } else {
                    DynRealm dynRealm = this.dynRealmDAO.find(realmPath);
                    if (dynRealm == null) {
                        LOG.warn("Ignoring invalid dynamic realm {}", realmPath);
                    } else {
                        dynRealmKeys.add(dynRealm.getKey());
                    }
                }
            }));
            if (!dynRealmKeys.isEmpty()) {
                realmKeys.clear();
            }
        } else if (adminRealms.stream().anyMatch(r -> r.startsWith(base.getFullPath()))) {
            realmKeys.add(base.getKey());
        }
        return Triple.of((Object)this.buildAdminRealmsFilter(realmKeys, svs, parameters), dynRealmKeys, groupOwners);
    }

    protected void visitNode(AnySearchNode node, Map<SearchSupport.SearchView, Boolean> counters, Set<SearchSupport.SearchView> from, List<String> where, SearchSupport svs) {
        node.asLeaf().ifPresentOrElse(leaf -> {
            from.add(leaf.getFrom());
            if (counters.computeIfAbsent(leaf.getFrom(), view -> false).booleanValue() && !leaf.getClause().contains(" IN ")) {
                where.add(this.anyId(svs) + " IN (SELECT any_id FROM " + leaf.getFrom().name + " WHERE " + leaf.getClause().replace(leaf.getFrom().alias + ".", "") + ")");
            } else {
                counters.put(leaf.getFrom(), true);
                where.add(leaf.getClause());
            }
        }, () -> {
            ArrayList nodeWhere = new ArrayList();
            node.getChildren().forEach(child -> this.visitNode((AnySearchNode)child, counters, from, nodeWhere, svs));
            where.add(nodeWhere.stream().map(w -> "(" + w + ")").collect(Collectors.joining(" " + node.getType().name() + " ")));
        });
    }

    protected String buildFrom(Set<SearchSupport.SearchView> from, Set<String> plainSchemas, OrderBySupport obs) {
        Object fromString;
        if (from.size() == 1) {
            SearchSupport.SearchView sv = from.iterator().next();
            fromString = sv.name + " " + sv.alias;
        } else {
            ArrayList<SearchSupport.SearchView> joins = new ArrayList<SearchSupport.SearchView>(from);
            StringBuilder join = new StringBuilder(((SearchSupport.SearchView)joins.get((int)0)).name + " " + ((SearchSupport.SearchView)joins.get((int)0)).alias);
            for (int i = 1; i < joins.size(); ++i) {
                SearchSupport.SearchView sv = (SearchSupport.SearchView)joins.get(i);
                join.append(" LEFT JOIN ").append(sv.name).append(" ").append(sv.alias).append(" ON ").append(this.anyId((SearchSupport.SearchView)joins.get(0))).append("=").append(this.anyId(sv));
            }
            fromString = join.toString();
        }
        return fromString;
    }

    protected String buildWhere(List<String> where, AnySearchNode root) {
        return where.stream().map(w -> "(" + w + ")").collect(Collectors.joining(" " + root.getType().name() + " "));
    }

    protected String buildCountQuery(Pair<AnySearchNode, Set<String>> queryInfo, AnySearchNode.Leaf filterNode, List<Object> parameters, SearchSupport svs) {
        AnySearchNode root;
        if (((AnySearchNode)queryInfo.getLeft()).getType() == AnySearchNode.Type.AND) {
            root = (AnySearchNode)queryInfo.getLeft();
        } else {
            root = new AnySearchNode(AnySearchNode.Type.AND);
            root.add((AnySearchNode)queryInfo.getLeft());
        }
        root.add(filterNode);
        HashSet<SearchSupport.SearchView> from = new HashSet<SearchSupport.SearchView>();
        ArrayList<String> where = new ArrayList<String>();
        HashMap<SearchSupport.SearchView, Boolean> counters = new HashMap<SearchSupport.SearchView, Boolean>();
        this.visitNode(root, counters, from, where, svs);
        StringBuilder queryString = new StringBuilder("SELECT COUNT(DISTINCT ").append(this.anyId(svs)).append(") ");
        queryString.append("FROM ").append(this.buildFrom(from, (Set)queryInfo.getRight(), null));
        queryString.append(" WHERE ").append(this.buildWhere(where, root));
        LOG.debug("Query: {}, parameters: {}", (Object)queryString, parameters);
        return queryString.toString();
    }

    @Override
    protected int doCount(Realm base, boolean recursive, Set<String> adminRealms, SearchCond cond, AnyTypeKind kind) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        SearchViewSupport svs = new SearchViewSupport(kind);
        Triple<AnySearchNode.Leaf, Set<String>, Set<String>> filter = this.getAdminRealmsFilter(base, recursive, adminRealms, parameters, svs);
        Optional<Pair<AnySearchNode, Set<String>>> optionalQueryInfo = this.getQuery(JPAAnySearchDAO.buildEffectiveCond(cond, (Set)filter.getMiddle(), (Set)filter.getRight(), kind), parameters, svs);
        if (optionalQueryInfo.isEmpty()) {
            LOG.error("Invalid search condition: {}", (Object)cond);
            return 0;
        }
        Pair<AnySearchNode, Set<String>> queryInfo = optionalQueryInfo.get();
        String queryString = this.buildCountQuery(queryInfo, (AnySearchNode.Leaf)filter.getLeft(), parameters, svs);
        Query countQuery = this.entityManager().createNativeQuery(queryString);
        JPAAnySearchDAO.fillWithParameters(countQuery, parameters);
        return ((Number)countQuery.getSingleResult()).intValue();
    }

    protected void parseOrderByForPlainSchema(SearchSupport svs, OrderBySupport obs, OrderBySupport.Item item, OrderByClause clause, PlainSchema schema, String fieldName) {
        boolean bl = obs.nonMandatorySchemas = !"true".equals(schema.getMandatoryCondition());
        if (schema.isUniqueConstraint()) {
            obs.views.add(svs.asSearchViewSupport().uniqueAttr());
            item.select = svs.asSearchViewSupport().uniqueAttr().alias + '.' + JPAAnySearchDAO.key(schema.getType()) + " AS " + fieldName;
            item.where = svs.asSearchViewSupport().uniqueAttr().alias + ".schema_id='" + fieldName + "'";
            item.orderBy = fieldName + " " + clause.getDirection().name();
        } else {
            obs.views.add(svs.asSearchViewSupport().attr());
            item.select = svs.asSearchViewSupport().attr().alias + '.' + JPAAnySearchDAO.key(schema.getType()) + " AS " + fieldName;
            item.where = svs.asSearchViewSupport().attr().alias + ".schema_id='" + fieldName + "'";
            item.orderBy = fieldName + " " + clause.getDirection().name();
        }
    }

    protected void parseOrderByForField(SearchSupport svs, OrderBySupport.Item item, String fieldName, OrderByClause clause) {
        item.select = this.defaultSV((SearchSupport)svs).alias + "." + fieldName;
        item.where = "";
        item.orderBy = this.defaultSV((SearchSupport)svs).alias + "." + fieldName + " " + clause.getDirection().name();
    }

    protected void parseOrderByForCustom(SearchSupport svs, OrderByClause clause, OrderBySupport.Item item, OrderBySupport obs) {
    }

    protected OrderBySupport parseOrderBy(SearchSupport svs, List<OrderByClause> orderBy) {
        AnyUtils anyUtils = this.anyUtilsFactory.getInstance(svs.anyTypeKind);
        OrderBySupport obs = new OrderBySupport();
        HashSet orderByUniquePlainSchemas = new HashSet();
        HashSet orderByNonUniquePlainSchemas = new HashSet();
        orderBy.forEach(clause -> {
            OrderBySupport.Item item = new OrderBySupport.Item();
            this.parseOrderByForCustom(svs, (OrderByClause)clause, item, obs);
            if (item.isEmpty()) {
                if (anyUtils.getField(clause.getField()) == null) {
                    PlainSchema schema = (PlainSchema)this.plainSchemaDAO.find(clause.getField());
                    if (schema != null) {
                        if (schema.isUniqueConstraint()) {
                            orderByUniquePlainSchemas.add(schema.getKey());
                        } else {
                            orderByNonUniquePlainSchemas.add(schema.getKey());
                        }
                        if (orderByUniquePlainSchemas.size() > 1 || orderByNonUniquePlainSchemas.size() > 1) {
                            throw JPAAnySearchDAO.syncopeClientException("Order by more than one attribute is not allowed; remove one from " + String.valueOf(orderByUniquePlainSchemas.size() > 1 ? orderByUniquePlainSchemas : orderByNonUniquePlainSchemas)).get();
                        }
                        this.parseOrderByForPlainSchema(svs, obs, item, (OrderByClause)clause, schema, clause.getField());
                    }
                } else {
                    Object fieldName;
                    Object object = fieldName = "key".equals(clause.getField()) ? "id" : clause.getField();
                    if (ArrayUtils.contains((Object[])RELATIONSHIP_FIELDS, (Object)fieldName)) {
                        fieldName = (String)fieldName + "_id";
                    }
                    obs.views.add(this.defaultSV(svs));
                    this.parseOrderByForField(svs, item, (String)fieldName, (OrderByClause)clause);
                }
            }
            if (item.isEmpty()) {
                LOG.warn("Cannot build any valid clause from {}", clause);
            } else {
                obs.items.add(item);
            }
        });
        return obs;
    }

    protected String buildSearchQuery(Pair<AnySearchNode, Set<String>> queryInfo, AnySearchNode.Leaf filterNode, List<Object> parameters, SearchSupport svs, List<OrderByClause> orderBy) {
        AnySearchNode root;
        if (((AnySearchNode)queryInfo.getLeft()).getType() == AnySearchNode.Type.AND) {
            root = (AnySearchNode)queryInfo.getLeft();
        } else {
            root = new AnySearchNode(AnySearchNode.Type.AND);
            root.add((AnySearchNode)queryInfo.getLeft());
        }
        root.add(filterNode);
        HashSet<SearchSupport.SearchView> from = new HashSet<SearchSupport.SearchView>();
        ArrayList<String> where = new ArrayList<String>();
        HashMap<SearchSupport.SearchView, Boolean> counters = new HashMap<SearchSupport.SearchView, Boolean>();
        this.visitNode(root, counters, from, where, svs);
        OrderBySupport obs = this.parseOrderBy(svs, orderBy);
        StringBuilder queryString = new StringBuilder("SELECT DISTINCT ").append(this.anyId(svs));
        obs.items.forEach(item -> queryString.append(',').append(item.select));
        from.addAll(obs.views);
        queryString.append(" FROM ").append(this.buildFrom(from, (Set)queryInfo.getRight(), obs));
        queryString.append(" WHERE ").append(this.buildWhere(where, root));
        if (!obs.items.isEmpty()) {
            queryString.append(" ORDER BY ").append(obs.items.stream().map(item -> item.orderBy).collect(Collectors.joining(",")));
        }
        LOG.debug("Query: {}, parameters: {}", (Object)queryString, parameters);
        return queryString.toString();
    }

    @Override
    protected <T extends Any<?>> List<T> doSearch(Realm base, boolean recursive, Set<String> adminRealms, SearchCond cond, int page, int itemsPerPage, List<OrderByClause> orderBy, AnyTypeKind kind) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        SearchViewSupport svs = new SearchViewSupport(kind);
        Triple<AnySearchNode.Leaf, Set<String>, Set<String>> filter = this.getAdminRealmsFilter(base, recursive, adminRealms, parameters, svs);
        Optional<Pair<AnySearchNode, Set<String>>> optionalQueryInfo = this.getQuery(JPAAnySearchDAO.buildEffectiveCond(cond, (Set)filter.getMiddle(), (Set)filter.getRight(), kind), parameters, svs);
        if (optionalQueryInfo.isEmpty()) {
            LOG.error("Invalid search condition: {}", (Object)cond);
            return List.of();
        }
        Pair<AnySearchNode, Set<String>> queryInfo = optionalQueryInfo.get();
        String queryString = this.buildSearchQuery(queryInfo, (AnySearchNode.Leaf)filter.getLeft(), parameters, svs, orderBy);
        Query query = this.entityManager().createNativeQuery(queryString);
        query.setFirstResult(itemsPerPage * (page <= 0 ? 0 : page - 1));
        if (itemsPerPage >= 0) {
            query.setMaxResults(itemsPerPage);
        }
        JPAAnySearchDAO.fillWithParameters(query, parameters);
        return this.buildResult(query.getResultList(), kind);
    }
}

