/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.trusted.authentication.storage;

import lombok.Generated;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustStorage;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.inspektr.common.Cleanable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.annotation.Transactional;

@EnableTransactionManagement(proxyTargetClass=false)
@Transactional(transactionManager="transactionManagerMfaAuthnTrust")
public class MultifactorAuthenticationTrustStorageCleaner
implements Cleanable {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MultifactorAuthenticationTrustStorageCleaner.class);
    private final MultifactorAuthenticationTrustStorage storage;

    @Scheduled(initialDelayString="${cas.authn.mfa.trusted.cleaner.schedule.start-delay:PT10S}", fixedDelayString="${cas.authn.mfa.trusted.cleaner.schedule.repeat-interval:PT60S}")
    public void clean() {
        FunctionUtils.doUnchecked(o -> {
            LOGGER.trace("Proceeding to clean up expired trusted authentication records...");
            this.storage.remove();
        }, (Object[])new Object[0]);
    }

    @Generated
    public MultifactorAuthenticationTrustStorageCleaner(MultifactorAuthenticationTrustStorage storage) {
        this.storage = storage;
    }

    @Generated
    public MultifactorAuthenticationTrustStorage getStorage() {
        return this.storage;
    }
}

