/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.config.builders;

import java.net.InetSocketAddress;
import java.net.URI;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.function.UnaryOperator;
import org.ehcache.clustered.client.config.ClusteringServiceConfiguration;
import org.ehcache.clustered.client.config.Timeouts;
import org.ehcache.clustered.client.config.builders.ServerSideConfigurationBuilder;
import org.ehcache.clustered.client.config.builders.TimeoutsBuilder;
import org.ehcache.clustered.client.internal.ConnectionSource;
import org.ehcache.clustered.common.ServerSideConfiguration;
import org.ehcache.config.Builder;

public final class ClusteringServiceConfigurationBuilder
implements Builder<ClusteringServiceConfiguration> {
    private final ConnectionSource connectionSource;
    private final Timeouts timeouts;
    private final boolean autoCreate;
    private final ServerSideConfigurationBuilder serverSideConfiguration;
    private final Properties properties;

    public static ClusteringServiceConfigurationBuilder cluster(URI clusterUri) {
        return new ClusteringServiceConfigurationBuilder(new ConnectionSource.ClusterUri(clusterUri), TimeoutsBuilder.timeouts().build(), false, null, new Properties());
    }

    public static ClusteringServiceConfigurationBuilder cluster(Iterable<InetSocketAddress> servers, String clusterTierManager) {
        return new ClusteringServiceConfigurationBuilder(new ConnectionSource.ServerList(servers, clusterTierManager), TimeoutsBuilder.timeouts().build(), false, null, new Properties());
    }

    public static ClusteringServiceConfigurationBuilder seededFrom(ClusteringServiceConfiguration configuration) {
        ServerSideConfiguration serverSideConfiguration = configuration.getServerConfiguration();
        if (serverSideConfiguration == null) {
            return new ClusteringServiceConfigurationBuilder(configuration.getConnectionSource(), configuration.getTimeouts(), configuration.isAutoCreate(), null, configuration.getProperties());
        }
        return new ClusteringServiceConfigurationBuilder(configuration.getConnectionSource(), configuration.getTimeouts(), configuration.isAutoCreate(), new ServerSideConfigurationBuilder(serverSideConfiguration), configuration.getProperties());
    }

    private ClusteringServiceConfigurationBuilder(ConnectionSource connectionSource, Timeouts timeouts, boolean autoCreate, ServerSideConfigurationBuilder serverSideConfiguration, Properties properties) {
        this.connectionSource = connectionSource;
        this.timeouts = Objects.requireNonNull(timeouts, "Timeouts can't be null");
        this.autoCreate = autoCreate;
        this.serverSideConfiguration = serverSideConfiguration;
        this.properties = properties;
    }

    public ClusteringServiceConfigurationBuilder usingUri(URI clusterUri) {
        return new ClusteringServiceConfigurationBuilder(new ConnectionSource.ClusterUri(clusterUri), this.timeouts, this.autoCreate, this.serverSideConfiguration, this.properties);
    }

    public ClusteringServiceConfigurationBuilder usingServers(Iterable<InetSocketAddress> servers) {
        return new ClusteringServiceConfigurationBuilder(new ConnectionSource.ServerList(servers, this.connectionSource.getClusterTierManager()), this.timeouts, this.autoCreate, this.serverSideConfiguration, this.properties);
    }

    public ClusteringServiceConfigurationBuilder usingServers(Iterable<InetSocketAddress> servers, String clusterTierManager) {
        return new ClusteringServiceConfigurationBuilder(new ConnectionSource.ServerList(servers, clusterTierManager), this.timeouts, this.autoCreate, this.serverSideConfiguration, this.properties);
    }

    @Deprecated
    public ServerSideConfigurationBuilder autoCreate() {
        return new ServerSideConfigurationBuilder(new ClusteringServiceConfigurationBuilder(this.connectionSource, this.timeouts, true, this.serverSideConfiguration, this.properties));
    }

    @Deprecated
    public ServerSideConfigurationBuilder expecting() {
        return new ServerSideConfigurationBuilder(new ClusteringServiceConfigurationBuilder(this.connectionSource, this.timeouts, false, this.serverSideConfiguration, this.properties));
    }

    public ClusteringServiceConfigurationBuilder autoCreate(UnaryOperator<ServerSideConfigurationBuilder> serverSideConfig) {
        return new ClusteringServiceConfigurationBuilder(this.connectionSource, this.timeouts, true, (ServerSideConfigurationBuilder)serverSideConfig.apply(new ServerSideConfigurationBuilder()), this.properties);
    }

    public ClusteringServiceConfigurationBuilder expecting(UnaryOperator<ServerSideConfigurationBuilder> serverSideConfig) {
        return new ClusteringServiceConfigurationBuilder(this.connectionSource, this.timeouts, false, (ServerSideConfigurationBuilder)serverSideConfig.apply(new ServerSideConfigurationBuilder()), this.properties);
    }

    public ClusteringServiceConfigurationBuilder timeouts(Timeouts timeouts) {
        return new ClusteringServiceConfigurationBuilder(this.connectionSource, timeouts, this.autoCreate, this.serverSideConfiguration, this.properties);
    }

    public ClusteringServiceConfigurationBuilder timeouts(Builder<? extends Timeouts> timeoutsBuilder) {
        return new ClusteringServiceConfigurationBuilder(this.connectionSource, (Timeouts)timeoutsBuilder.build(), this.autoCreate, this.serverSideConfiguration, this.properties);
    }

    @Deprecated
    public ClusteringServiceConfigurationBuilder readOperationTimeout(long duration, TimeUnit unit) {
        Duration readTimeout = Duration.of(duration, ClusteringServiceConfigurationBuilder.toChronoUnit(unit));
        return this.timeouts(TimeoutsBuilder.timeouts().read(readTimeout).build());
    }

    public ClusteringServiceConfiguration build() {
        if (this.serverSideConfiguration == null) {
            return this.build(null);
        }
        return this.build(this.serverSideConfiguration.buildServerSideConfiguration());
    }

    ClusteringServiceConfiguration build(ServerSideConfiguration serverSideConfiguration) {
        return new ClusteringServiceConfiguration(this.connectionSource, this.timeouts, this.autoCreate, serverSideConfiguration, this.properties);
    }

    private static ChronoUnit toChronoUnit(TimeUnit unit) {
        if (unit == null) {
            return null;
        }
        switch (unit) {
            case NANOSECONDS: {
                return ChronoUnit.NANOS;
            }
            case MICROSECONDS: {
                return ChronoUnit.MICROS;
            }
            case MILLISECONDS: {
                return ChronoUnit.MILLIS;
            }
            case SECONDS: {
                return ChronoUnit.SECONDS;
            }
            case MINUTES: {
                return ChronoUnit.MINUTES;
            }
            case HOURS: {
                return ChronoUnit.HOURS;
            }
            case DAYS: {
                return ChronoUnit.DAYS;
            }
        }
        throw new AssertionError((Object)("Unknown unit: " + (Object)((Object)unit)));
    }
}

