/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.history.async;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.flowable.common.engine.impl.util.IoUtil;
import org.flowable.job.service.impl.history.async.AsyncHistoryJobHandler;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;

public class AsyncHistoryJobZippedHandler
extends AsyncHistoryJobHandler {
    public AsyncHistoryJobZippedHandler(String jobType) {
        super(jobType);
    }

    @Override
    protected byte[] getJobBytes(HistoryJobEntity job) {
        byte[] bytes = job.getAdvancedJobHandlerConfigurationByteArrayRef().getBytes(job.getScopeType());
        bytes = this.decompress(bytes);
        return bytes;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected byte[] decompress(byte[] compressed) {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(compressed);){
            byte[] byArray;
            try (GZIPInputStream gis = new GZIPInputStream(bais);){
                byArray = IoUtil.readInputStream((InputStream)gis, (String)"async-history-configuration");
            }
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("Error while decompressing json bytes", e);
        }
    }
}

