/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.EngineInfo;
import org.flowable.common.engine.impl.util.IoUtil;
import org.flowable.common.engine.impl.util.ReflectUtil;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.ProcessEngineConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProcessEngines {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessEngines.class);
    public static final String NAME_DEFAULT = "default";
    protected static boolean isInitialized;
    protected static Map<String, ProcessEngine> processEngines;
    protected static Map<String, EngineInfo> processEngineInfosByName;
    protected static Map<String, EngineInfo> processEngineInfosByResourceUrl;
    protected static List<EngineInfo> processEngineInfos;

    public static synchronized void init() {
        if (!ProcessEngines.isInitialized()) {
            if (processEngines == null) {
                processEngines = new HashMap<String, ProcessEngine>();
            }
            ClassLoader classLoader = ReflectUtil.getClassLoader();
            Enumeration<URL> resources = null;
            try {
                resources = classLoader.getResources("flowable.cfg.xml");
            }
            catch (IOException e) {
                throw new FlowableIllegalArgumentException("problem retrieving flowable.cfg.xml resources on the classpath: " + System.getProperty("java.class.path"), (Throwable)e);
            }
            HashSet<URL> configUrls = new HashSet<URL>();
            while (resources.hasMoreElements()) {
                configUrls.add(resources.nextElement());
            }
            for (URL resource : configUrls) {
                LOGGER.info("Initializing process engine using configuration '{}'", (Object)resource);
                ProcessEngines.initProcessEngineFromResource(resource);
            }
            try {
                resources = classLoader.getResources("flowable-context.xml");
            }
            catch (IOException e) {
                throw new FlowableIllegalArgumentException("problem retrieving flowable-context.xml resources on the classpath: " + System.getProperty("java.class.path"), (Throwable)e);
            }
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                LOGGER.info("Initializing process engine using Spring configuration '{}'", (Object)resource);
                ProcessEngines.initProcessEngineFromSpringResource(resource);
            }
            ProcessEngines.setInitialized(true);
        } else {
            LOGGER.info("Process engines already initialized");
        }
    }

    protected static void initProcessEngineFromSpringResource(URL resource) {
        try {
            Class springConfigurationHelperClass = ReflectUtil.loadClass((String)"org.flowable.spring.SpringConfigurationHelper");
            Method method = springConfigurationHelperClass.getDeclaredMethod("buildProcessEngine", URL.class);
            ProcessEngine processEngine = (ProcessEngine)method.invoke(null, resource);
            String processEngineName = processEngine.getName();
            EngineInfo processEngineInfo = new EngineInfo(processEngineName, resource.toString(), null);
            processEngineInfosByName.put(processEngineName, processEngineInfo);
            processEngineInfosByResourceUrl.put(resource.toString(), processEngineInfo);
        }
        catch (Exception e) {
            throw new FlowableException("couldn't initialize process engine from spring configuration resource " + resource + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public static void registerProcessEngine(ProcessEngine processEngine) {
        processEngines.put(processEngine.getName(), processEngine);
    }

    public static void unregister(ProcessEngine processEngine) {
        processEngines.remove(processEngine.getName());
    }

    private static EngineInfo initProcessEngineFromResource(URL resourceUrl) {
        EngineInfo processEngineInfo = processEngineInfosByResourceUrl.get(resourceUrl.toString());
        if (processEngineInfo != null) {
            processEngineInfos.remove(processEngineInfo);
            if (processEngineInfo.getException() == null) {
                String processEngineName = processEngineInfo.getName();
                processEngines.remove(processEngineName);
                processEngineInfosByName.remove(processEngineName);
            }
            processEngineInfosByResourceUrl.remove(processEngineInfo.getResourceUrl());
        }
        String resourceUrlString = resourceUrl.toString();
        try {
            LOGGER.info("initializing process engine for resource {}", (Object)resourceUrl);
            ProcessEngine processEngine = ProcessEngines.buildProcessEngine(resourceUrl);
            String processEngineName = processEngine.getName();
            LOGGER.info("initialised process engine {}", (Object)processEngineName);
            processEngineInfo = new EngineInfo(processEngineName, resourceUrlString, null);
            processEngines.put(processEngineName, processEngine);
            processEngineInfosByName.put(processEngineName, processEngineInfo);
        }
        catch (Throwable e) {
            LOGGER.error("Exception while initializing process engine: {}", (Object)e.getMessage(), (Object)e);
            processEngineInfo = new EngineInfo(null, resourceUrlString, ExceptionUtils.getStackTrace((Throwable)e));
        }
        processEngineInfosByResourceUrl.put(resourceUrlString, processEngineInfo);
        processEngineInfos.add(processEngineInfo);
        return processEngineInfo;
    }

    private static ProcessEngine buildProcessEngine(URL resource) {
        InputStream inputStream = null;
        try {
            inputStream = resource.openStream();
            ProcessEngineConfiguration processEngineConfiguration = ProcessEngineConfiguration.createProcessEngineConfigurationFromInputStream(inputStream);
            ProcessEngine processEngine = processEngineConfiguration.buildProcessEngine();
            return processEngine;
        }
        catch (IOException e) {
            throw new FlowableIllegalArgumentException("couldn't open resource stream: " + e.getMessage(), (Throwable)e);
        }
        finally {
            IoUtil.closeSilently((InputStream)inputStream);
        }
    }

    public static List<EngineInfo> getProcessEngineInfos() {
        return processEngineInfos;
    }

    public static EngineInfo getProcessEngineInfo(String processEngineName) {
        return processEngineInfosByName.get(processEngineName);
    }

    public static ProcessEngine getDefaultProcessEngine() {
        return ProcessEngines.getProcessEngine(NAME_DEFAULT);
    }

    public static ProcessEngine getProcessEngine(String processEngineName) {
        if (!ProcessEngines.isInitialized()) {
            ProcessEngines.init();
        }
        return processEngines.get(processEngineName);
    }

    public static EngineInfo retry(String resourceUrl) {
        LOGGER.debug("retying initializing of resource {}", (Object)resourceUrl);
        try {
            return ProcessEngines.initProcessEngineFromResource(new URL(resourceUrl));
        }
        catch (MalformedURLException e) {
            throw new FlowableIllegalArgumentException("invalid url: " + resourceUrl, (Throwable)e);
        }
    }

    public static Map<String, ProcessEngine> getProcessEngines() {
        return processEngines;
    }

    public static synchronized void destroy() {
        if (ProcessEngines.isInitialized()) {
            HashMap<String, ProcessEngine> engines = new HashMap<String, ProcessEngine>(processEngines);
            processEngines = new HashMap<String, ProcessEngine>();
            for (String processEngineName : engines.keySet()) {
                ProcessEngine processEngine = (ProcessEngine)engines.get(processEngineName);
                try {
                    processEngine.close();
                }
                catch (Exception e) {
                    LOGGER.error("exception while closing {}", (Object)(processEngineName == null ? "the default process engine" : "process engine " + processEngineName), (Object)e);
                }
            }
            processEngineInfosByName.clear();
            processEngineInfosByResourceUrl.clear();
            processEngineInfos.clear();
            ProcessEngines.setInitialized(false);
        }
    }

    public static boolean isInitialized() {
        return isInitialized;
    }

    public static void setInitialized(boolean isInitialized) {
        ProcessEngines.isInitialized = isInitialized;
    }

    static {
        processEngines = new HashMap<String, ProcessEngine>();
        processEngineInfosByName = new HashMap<String, EngineInfo>();
        processEngineInfosByResourceUrl = new HashMap<String, EngineInfo>();
        processEngineInfos = new ArrayList<EngineInfo>();
    }
}

