/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.event.logger;

import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.event.logger.AbstractEventFlusher;
import org.flowable.engine.impl.event.logger.handler.EventLoggerEventHandler;
import org.flowable.engine.impl.persistence.entity.EventLogEntryEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseEventFlusher
extends AbstractEventFlusher {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseEventFlusher.class);

    public void closing(CommandContext commandContext) {
        if (commandContext.getException() != null) {
            return;
        }
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        EventLogEntryEntityManager eventLogEntryEntityManager = processEngineConfiguration.getEventLogEntryEntityManager();
        for (EventLoggerEventHandler eventHandler : this.eventHandlers) {
            try {
                eventLogEntryEntityManager.insert(eventHandler.generateEventLogEntry(commandContext), false);
            }
            catch (Exception e) {
                LOGGER.warn("Could not create event log", (Throwable)e);
            }
        }
    }

    public void afterSessionsFlush(CommandContext commandContext) {
    }

    public void closeFailure(CommandContext commandContext) {
    }

    public Integer order() {
        return 100;
    }

    public boolean multipleAllowed() {
        return false;
    }
}

