/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.dynamic;

import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseDynamicForecastRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import liquibase.change.AbstractSQLChange;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.util.StringUtil;

public class SqlNotAllowedToGrantOfSpecificPrivileges
extends AbstractLiquibaseDynamicForecastRule {
    private static final Pattern GRANT_PATTERN = Pattern.compile(".*grant[\\s]+(.*?)[\\s]+(on .* )?to[\\s]+", 32);

    public SqlNotAllowedToGrantOfSpecificPrivileges() {
        this.setSeverity(SeverityEnum.INFO);
    }

    @Override
    public String getName() {
        return "Warn on Grant of Specific Privileges";
    }

    @Override
    public List<ScopeEnum> getScope() {
        return Collections.singletonList(ScopeEnum.CHANGELOG);
    }

    @Override
    public List<String> getTags() {
        return Collections.emptyList();
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }

    @Override
    public String getShortName() {
        return "SqlGrantSpecificPrivsWarn";
    }

    @Override
    public boolean internalEvaluate(ChangeSet changeSet, DynamicRule dynamicRule) {
        String[] stringArray = dynamicRule.getParameter(DynamicRuleParameterEnum.PRIVILEGE_LIST);
        Objects.requireNonNull(stringArray);
        stringArray = ((String)stringArray.getValue()).split(",");
        for (Change change : changeSet.getChanges()) {
            if (!(change instanceof AbstractSQLChange)) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            String[] stringArray2 = stringArray;
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = stringArray2[i2];
                if (!this.doCheck((AbstractSQLChange)change, string)) continue;
                arrayList.add("'" + string + "'");
            }
            if (arrayList.size() <= 0) continue;
            SqlNotAllowedToGrantOfSpecificPrivileges sqlNotAllowedToGrantOfSpecificPrivileges = this;
            sqlNotAllowedToGrantOfSpecificPrivileges.addFailureRuleIteration(sqlNotAllowedToGrantOfSpecificPrivileges.getFailureMessage(" contains ", arrayList, changeSet), dynamicRule);
        }
        return this.returnAtEndOfRule(dynamicRule);
    }

    private boolean doCheck(AbstractSQLChange object, String string) {
        object = ((AbstractSQLChange)object).getSql().toLowerCase();
        if (((Matcher)(object = GRANT_PATTERN.matcher((CharSequence)object))).find() && (object = ((Matcher)object).group(1)) != null) {
            return Arrays.stream(((String)object).split(",")).filter(string2 -> string2.trim().toLowerCase().equals(string.toLowerCase().trim().replaceAll("\"", ""))).collect(Collectors.toList()).size() > 0;
        }
        return false;
    }

    private String getFailureMessage(String string, List<String> object, ChangeSet changeSet) {
        object = StringUtil.join(object, ",");
        return "Change set " + changeSet.getId() + string + (String)object;
    }

    @Override
    public String getDescription() {
        return "This check warns a user when changeset includes or generates sql that grants specific privileges to a user or role";
    }

    @Override
    public int getPriority() {
        return 90;
    }

    @Override
    public List<RuleParameter<?>> getParameters() {
        return Collections.singletonList(new RuleParameter(DynamicRuleParameterEnum.PRIVILEGE_LIST));
    }
}

