/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptsecurity.sandbox.groovy;

import groovy.transform.ASTTest;
import groovy.transform.AnnotationCollector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;

public class RejectASTTransformsCustomizer
extends CompilationCustomizer {
    private static final List<String> BLOCKED_TRANSFORMS = Arrays.asList(ASTTest.class.getCanonicalName(), AnnotationCollector.class.getCanonicalName());

    public RejectASTTransformsCustomizer() {
        super(CompilePhase.CONVERSION);
    }

    public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
        new RejectASTTransformsVisitor(source).visitClass(classNode);
    }

    private static List<String> getBlockedTransforms() {
        ArrayList<String> blocked = new ArrayList<String>(BLOCKED_TRANSFORMS);
        String additionalBlocked = System.getProperty(RejectASTTransformsCustomizer.class.getName() + ".ADDITIONAL_BLOCKED_TRANSFORMS");
        if (additionalBlocked != null) {
            for (String b : additionalBlocked.split(",")) {
                blocked.add(b.trim());
            }
        }
        return blocked;
    }

    private static final class RejectASTTransformsVisitor
    extends ClassCodeVisitorSupport {
        private final SourceUnit source;

        private RejectASTTransformsVisitor(SourceUnit source) {
            this.source = source;
        }

        protected SourceUnit getSourceUnit() {
            return this.source;
        }

        public void visitImports(ModuleNode node) {
            if (node != null) {
                for (ImportNode importNode : node.getImports()) {
                    this.checkImportForBlockedAnnotation(importNode);
                }
                for (ImportNode importStaticNode : node.getStaticImports().values()) {
                    this.checkImportForBlockedAnnotation(importStaticNode);
                }
            }
            super.visitImports(node);
        }

        private void checkImportForBlockedAnnotation(ImportNode node) {
            if (node != null && node.getType() != null) {
                for (String blockedAnnotation : RejectASTTransformsCustomizer.getBlockedTransforms()) {
                    if (!blockedAnnotation.equals(node.getType().getName()) && !blockedAnnotation.endsWith("." + node.getType().getName())) continue;
                    throw new SecurityException("Insecure annotation '" + node.getType().getName() + "' you can tweak the security sandbox to allow it. Read more about this in the documentation.");
                }
            }
        }

        public void visitAnnotations(AnnotatedNode node) {
            for (AnnotationNode an : node.getAnnotations()) {
                for (String blockedAnnotation : RejectASTTransformsCustomizer.getBlockedTransforms()) {
                    if (!blockedAnnotation.equals(an.getClassNode().getName()) && !blockedAnnotation.endsWith("." + an.getClassNode().getName())) continue;
                    throw new SecurityException("Insecure annotation '" + an.getClassNode().getName() + "' you can tweak the security sandbox to allow it. Read more about this in the documentation.");
                }
            }
            super.visitAnnotations(node);
        }
    }
}

