/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.form.dropdown.lazy;

import com.googlecode.wicket.jquery.core.IJQueryWidget;
import com.googlecode.wicket.jquery.core.JQueryBehavior;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.behavior.ChoiceModelBehavior;
import com.googlecode.wicket.jquery.core.event.ISelectionChangedListener;
import com.googlecode.wicket.jquery.core.event.SelectionChangedAdapter;
import com.googlecode.wicket.jquery.core.renderer.IChoiceRenderer;
import com.googlecode.wicket.jquery.core.renderer.ITextRenderer;
import com.googlecode.wicket.jquery.core.template.IJQueryTemplate;
import com.googlecode.wicket.kendo.ui.form.dropdown.lazy.DropDownListBehavior;
import com.googlecode.wicket.kendo.ui.renderer.ChoiceRenderer;
import com.googlecode.wicket.kendo.ui.template.KendoTemplateBehavior;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class DropDownList<T>
extends TextField<T>
implements IJQueryWidget {
    private static final long serialVersionUID = 1L;
    private DropDownListBehavior widgetBehavior = null;
    private final IModel<List<T>> choices;
    private ChoiceModelBehavior<T> choiceModelBehavior;
    private final IChoiceRenderer<? super T> renderer;
    private final IJQueryTemplate template;
    private KendoTemplateBehavior templateBehavior = null;
    private int width = 0;

    public DropDownList(String id, List<T> choices) {
        this(id, Model.ofList(choices), new ChoiceRenderer());
    }

    public DropDownList(String id, List<T> choices, IChoiceRenderer<? super T> renderer) {
        this(id, Model.ofList(choices), renderer);
    }

    public DropDownList(String id, IModel<List<T>> choices) {
        this(id, choices, new ChoiceRenderer());
    }

    public DropDownList(String id, IModel<List<T>> choices, IChoiceRenderer<? super T> renderer) {
        super(id);
        this.choices = choices;
        this.renderer = renderer;
        this.template = this.newTemplate();
    }

    public DropDownList(String id, IModel<T> model, List<T> choices) {
        this(id, model, Model.ofList(choices), new ChoiceRenderer());
    }

    public DropDownList(String id, IModel<T> model, List<T> choices, IChoiceRenderer<? super T> renderer) {
        this(id, model, Model.ofList(choices), renderer);
    }

    public DropDownList(String id, IModel<T> model, IModel<List<T>> choices) {
        this(id, model, choices, new ChoiceRenderer());
    }

    public DropDownList(String id, IModel<T> model, IModel<List<T>> choices, IChoiceRenderer<? super T> renderer) {
        super(id, model);
        this.choices = choices;
        this.renderer = renderer;
        this.template = this.newTemplate();
    }

    protected final String getModelValue() {
        return this.renderer.getValue(this.getModelObject());
    }

    protected CharSequence getCallbackUrl() {
        return this.choiceModelBehavior.getCallbackUrl();
    }

    public String getTemplateToken() {
        if (this.templateBehavior != null) {
            return this.templateBehavior.getToken();
        }
        return null;
    }

    public int getListWidth() {
        return this.width;
    }

    public DropDownList<?> setListWidth(int width) {
        this.width = width;
        return this;
    }

    public void convertInput() {
        String input = this.getInput();
        for (Object choice : (List)this.choices.getObject()) {
            if (!this.renderer.getValue(choice).equals(input)) continue;
            this.setConvertedInput(choice);
            break;
        }
    }

    protected void onInitialize() {
        super.onInitialize();
        this.choiceModelBehavior = this.newChoiceModelBehavior();
        this.add(new Behavior[]{this.choiceModelBehavior});
        this.widgetBehavior = (DropDownListBehavior)IJQueryWidget.JQueryWidget.newWidgetBehavior((Component)this);
        this.add(new Behavior[]{this.widgetBehavior});
        this.add(new Behavior[]{IJQueryWidget.JQueryWidget.newWidgetBehavior((Component)this)});
        if (this.template != null) {
            this.templateBehavior = new KendoTemplateBehavior(this.template);
            this.add(new Behavior[]{this.templateBehavior});
        }
    }

    public void onConfigure(JQueryBehavior behavior) {
        behavior.setOption("dataTextField", (Object)Options.asString((String)this.renderer.getTextField()));
        behavior.setOption("dataValueField", (Object)Options.asString((String)this.renderer.getValueField()));
        if (this.templateBehavior != null) {
            behavior.setOption("template", (Object)String.format("jQuery('#%s').html()", this.getTemplateToken()));
        }
        if (this.getListWidth() > 0) {
            behavior.setOption("open", (Object)String.format("function(e) { e.sender.list.width(%d); }", this.getListWidth()));
        }
    }

    public void onBeforeRender(JQueryBehavior behavior) {
    }

    public JQueryBehavior newWidgetBehavior(String selector) {
        return new DropDownListBehavior(selector, (ISelectionChangedListener)new SelectionChangedAdapter()){
            private static final long serialVersionUID = 1L;

            @Override
            protected CharSequence getDataSourceUrl() {
                return DropDownList.this.getCallbackUrl();
            }
        };
    }

    protected IJQueryTemplate newTemplate() {
        return null;
    }

    protected ChoiceModelBehavior<T> newChoiceModelBehavior() {
        return new ChoiceModelBehavior<T>((ITextRenderer)this.renderer, this.template){
            private static final long serialVersionUID = 1L;

            public List<T> getChoices() {
                return (List)DropDownList.this.choices.getObject();
            }
        };
    }
}

