/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.form.button;

import com.googlecode.wicket.jquery.core.IJQuerySecurityProvider;
import com.googlecode.wicket.jquery.ui.form.button.Button;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.model.IModel;
import org.apache.wicket.protocol.http.WebSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SecuredButton
extends Button {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(SecuredButton.class);
    private final IJQuerySecurityProvider provider;
    private String[] roles;

    public SecuredButton(String id, String ... roles) {
        this(id, (IJQuerySecurityProvider)WebSession.get(), roles);
    }

    public SecuredButton(String id, IJQuerySecurityProvider provider, String ... roles) {
        super(id);
        this.roles = roles;
        this.provider = provider;
    }

    public SecuredButton(String id, IModel<String> model, String ... roles) {
        this(id, model, (IJQuerySecurityProvider)WebSession.get(), roles);
    }

    public SecuredButton(String id, IModel<String> model, IJQuerySecurityProvider provider, String ... roles) {
        super(id, model);
        this.roles = roles;
        this.provider = provider;
    }

    public void setRoles(String[] roles) {
        this.roles = (String[])roles.clone();
    }

    public final boolean isLocked() {
        return !this.provider.hasRole(this.roles);
    }

    @Override
    protected String getIcon() {
        return this.isLocked() ? "ui-icon-locked" : "ui-icon-unlocked";
    }

    protected void onConfigure() {
        super.onConfigure();
        this.setEnabled(!this.isLocked());
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        if (!"button".equalsIgnoreCase(tag.getName())) {
            LOG.warn("SecuredButton should be applied on a 'button' tag");
        }
    }
}

