/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.config.xml;

import org.ehcache.clustered.client.config.ClusteredStoreConfiguration;
import org.ehcache.clustered.client.config.builders.ClusteredStoreConfigurationBuilder;
import org.ehcache.clustered.client.internal.config.xml.ClusteringParser;
import org.ehcache.clustered.client.internal.store.ClusteredStore;
import org.ehcache.clustered.common.Consistency;
import org.ehcache.xml.CacheServiceConfigurationParser;
import org.ehcache.xml.exceptions.XmlConfigurationException;
import org.osgi.service.component.annotations.Component;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Component
public class ClusteringCacheServiceConfigurationParser
extends ClusteringParser<ClusteredStoreConfiguration>
implements CacheServiceConfigurationParser<ClusteredStore.Provider, ClusteredStoreConfiguration> {
    public static final String CLUSTERED_STORE_ELEMENT = "clustered-store";
    public static final String CONSISTENCY_ATTRIBUTE = "consistency";

    public ClusteredStoreConfiguration parse(Element fragment, ClassLoader classLoader) {
        if (CLUSTERED_STORE_ELEMENT.equals(fragment.getLocalName())) {
            Attr consistency = fragment.getAttributeNode(CONSISTENCY_ATTRIBUTE);
            if (consistency == null) {
                return ClusteredStoreConfigurationBuilder.withConsistency(Consistency.EVENTUAL).build();
            }
            return ClusteredStoreConfigurationBuilder.withConsistency(Consistency.valueOf(consistency.getValue().toUpperCase())).build();
        }
        throw new XmlConfigurationException(String.format("XML configuration element <%s> in <%s> is not supported", fragment.getTagName(), fragment.getParentNode() == null ? "null" : fragment.getParentNode().getLocalName()));
    }

    public Class<ClusteredStore.Provider> getServiceType() {
        return ClusteredStore.Provider.class;
    }

    public Element safeUnparse(Document doc, ClusteredStoreConfiguration clusteredStoreConfiguration) {
        Consistency consistency = clusteredStoreConfiguration.getConsistency();
        Element rootElement = doc.createElementNS("http://www.ehcache.org/v3/clustered", "tc:clustered-store");
        rootElement.setAttribute(CONSISTENCY_ATTRIBUTE, consistency.name().toLowerCase());
        return rootElement;
    }
}

