/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.markup.html.link;

import com.googlecode.wicket.jquery.core.IJQuerySecurityProvider;
import com.googlecode.wicket.jquery.core.IJQueryWidget;
import com.googlecode.wicket.jquery.core.JQueryBehavior;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.kendo.ui.KendoIcon;
import com.googlecode.wicket.kendo.ui.form.button.ButtonBehavior;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.model.IModel;
import org.apache.wicket.protocol.http.WebSession;

public abstract class AjaxLink<T>
extends org.apache.wicket.ajax.markup.html.AjaxLink<T>
implements IJQueryWidget {
    private static final long serialVersionUID = 1L;
    private final String icon;

    public AjaxLink(String id) {
        this(id, "");
    }

    public AjaxLink(String id, String icon) {
        super(id);
        this.icon = icon;
    }

    public AjaxLink(String id, IModel<T> model) {
        this(id, model, "");
    }

    public AjaxLink(String id, IModel<T> model, String icon) {
        super(id, model);
        this.icon = icon;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Behavior[]{IJQueryWidget.JQueryWidget.newWidgetBehavior((Component)this)});
    }

    public void onConfigure(JQueryBehavior behavior) {
        behavior.setOption("enable", (Object)this.isEnabledInHierarchy());
        String icon = this.getIcon();
        if (!KendoIcon.isNone(icon)) {
            behavior.setOption("icon", (Object)Options.asString((String)icon));
        }
    }

    public void onBeforeRender(JQueryBehavior behavior) {
    }

    protected String getIcon() {
        return this.icon;
    }

    public JQueryBehavior newWidgetBehavior(String selector) {
        return new ButtonBehavior(selector);
    }

    public static abstract class SecuredAjaxLink<T>
    extends AjaxLink<T> {
        private static final long serialVersionUID = 1L;
        private final String[] roles;
        private final IJQuerySecurityProvider provider;

        public SecuredAjaxLink(String id, String[] roles) {
            this(id, (IJQuerySecurityProvider)WebSession.get(), roles);
        }

        public SecuredAjaxLink(String id, IJQuerySecurityProvider provider, String[] roles) {
            super(id);
            this.roles = roles;
            this.provider = provider;
        }

        public SecuredAjaxLink(String id, String icon, String[] roles) {
            this(id, icon, (IJQuerySecurityProvider)WebSession.get(), roles);
        }

        public SecuredAjaxLink(String id, String icon, IJQuerySecurityProvider provider, String[] roles) {
            super(id, icon);
            this.roles = roles;
            this.provider = provider;
        }

        public SecuredAjaxLink(String id, IModel<T> model, String[] roles) {
            this(id, model, (IJQuerySecurityProvider)WebSession.get(), roles);
        }

        public SecuredAjaxLink(String id, IModel<T> model, IJQuerySecurityProvider provider, String[] roles) {
            super(id, model);
            this.roles = roles;
            this.provider = provider;
        }

        public SecuredAjaxLink(String id, IModel<T> model, String icon, String[] roles) {
            this(id, model, icon, (IJQuerySecurityProvider)WebSession.get(), roles);
        }

        public SecuredAjaxLink(String id, IModel<T> model, String icon, IJQuerySecurityProvider provider, String[] roles) {
            super(id, model, icon);
            this.roles = roles;
            this.provider = provider;
        }

        public final boolean isLocked() {
            return !this.provider.hasRole(this.roles);
        }

        @Override
        protected String getIcon() {
            return this.isLocked() ? "lock" : super.getIcon();
        }

        protected void onConfigure() {
            super.onConfigure();
            this.setEnabled(!this.isLocked());
        }
    }
}

