/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.provider.gigaspaces;

import java.util.Arrays;
import org.springframework.util.StringUtils;
import org.springmodules.cache.provider.AbstractFlushingModel;
import org.springmodules.util.Objects;

public final class GigaSpacesFlushingModel
extends AbstractFlushingModel {
    private static final long serialVersionUID = 7299844898815952890L;
    private String[] cacheNames;

    public GigaSpacesFlushingModel() {
    }

    public GigaSpacesFlushingModel(String csvCacheNames) {
        this();
        this.setCacheNames(csvCacheNames);
    }

    public GigaSpacesFlushingModel(String[] newCacheNames) {
        this();
        this.setCacheNames(newCacheNames);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GigaSpacesFlushingModel)) {
            return false;
        }
        GigaSpacesFlushingModel flushingModel = (GigaSpacesFlushingModel)obj;
        return Arrays.equals(this.cacheNames, flushingModel.cacheNames);
    }

    public String[] getCacheNames() {
        return this.cacheNames;
    }

    public int hashCode() {
        int multiplier = 31;
        int hash = 7;
        hash = multiplier * hash + Objects.nullSafeHashCode(this.cacheNames);
        return hash;
    }

    public void setCacheNames(String csvCacheNames) {
        String[] newCacheNames = null;
        if (csvCacheNames != null) {
            newCacheNames = StringUtils.commaDelimitedListToStringArray((String)csvCacheNames);
        }
        this.setCacheNames(newCacheNames);
    }

    public void setCacheNames(String[] newCacheNames) {
        this.cacheNames = newCacheNames;
    }

    public String toString() {
        StringBuffer buffer = Objects.identityToString(this);
        buffer.append("[cacheNames=" + Objects.nullSafeToString(this.cacheNames) + ", ");
        buffer.append("flushBeforeMethodExecution=" + this.flushBeforeMethodExecution() + "]");
        return buffer.toString();
    }
}

