/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationPostProcessor;
import org.apereo.cas.authentication.LdapPasswordSynchronizationAuthenticationPostProcessor;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.authentication.passwordsync.LdapPasswordSynchronizationProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapSearchProperties;
import org.apereo.cas.util.spring.DisposableListFactoryBean;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.jooq.lambda.Unchecked;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.LDAP, module="password-sync")
@AutoConfiguration
public class LdapPasswordSynchronizationConfiguration {
    private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.authn.password-sync.enabled").isTrue().evenIfMissing();

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public FactoryBean<List<Object>> ldapPasswordSynchronizationAuthenticationPostProcessorListFactoryBean() {
        return new DisposableListFactoryBean();
    }

    @ConditionalOnMissingBean(name={"ldapPasswordSynchronizationAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public AuthenticationEventExecutionPlanConfigurer ldapPasswordSynchronizationAuthenticationEventExecutionPlanConfigurer(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="ldapPasswordSynchronizationAuthenticationPostProcessorListFactoryBean") FactoryBean<List<Object>> ldapPasswordSynchronizationAuthenticationPostProcessorListFactoryBean) throws Exception {
        return (AuthenticationEventExecutionPlanConfigurer)BeanSupplier.of(AuthenticationEventExecutionPlanConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(Unchecked.supplier(() -> {
            List postProcessorList = (List)ldapPasswordSynchronizationAuthenticationPostProcessorListFactoryBean.getObject();
            return plan -> {
                List ldap = casProperties.getAuthn().getPasswordSync().getLdap();
                ldap.stream().filter(LdapPasswordSynchronizationProperties::isEnabled).forEach(instance -> {
                    LdapPasswordSynchronizationAuthenticationPostProcessor postProcessor = new LdapPasswordSynchronizationAuthenticationPostProcessor((AbstractLdapSearchProperties)instance);
                    postProcessorList.add(postProcessor);
                    plan.registerAuthenticationPostProcessor((AuthenticationPostProcessor)postProcessor);
                });
            };
        })).otherwiseProxy().get();
    }
}

