/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.security.jws;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.KeyLengthException;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.jca.JCAContext;
import com.nimbusds.jose.util.Base64URL;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class AccessTokenJWSSigner
implements JWSSigner {
    private final JWSAlgorithm jwsAlgorithm;
    private final JWSSigner delegate;

    public AccessTokenJWSSigner(JWSAlgorithm jwsAlgorithm, String jwsKey) throws KeyLengthException, NoSuchAlgorithmException, InvalidKeySpecException {
        this.jwsAlgorithm = jwsAlgorithm;
        if (JWSAlgorithm.Family.RSA.contains((Object)jwsAlgorithm)) {
            if (jwsKey.indexOf(58) == -1) {
                throw new IllegalArgumentException("A key pair is required, in the 'private:public' format");
            }
            KeyFactory kf = KeyFactory.getInstance("RSA");
            PKCS8EncodedKeySpec keySpecPKCS8 = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(StringUtils.substringBefore((String)jwsKey, (String)":").getBytes()));
            this.delegate = new RSASSASigner(kf.generatePrivate(keySpecPKCS8));
        } else if (JWSAlgorithm.Family.HMAC_SHA.contains((Object)jwsAlgorithm)) {
            this.delegate = new MACSigner(jwsKey);
        } else {
            throw new IllegalArgumentException("Unsupported JWS algorithm: " + jwsAlgorithm.getName());
        }
    }

    public JWSAlgorithm getJwsAlgorithm() {
        return this.jwsAlgorithm;
    }

    public Set<JWSAlgorithm> supportedJWSAlgorithms() {
        return this.delegate.supportedJWSAlgorithms();
    }

    public JCAContext getJCAContext() {
        return this.delegate.getJCAContext();
    }

    public Base64URL sign(JWSHeader header, byte[] signingInput) throws JOSEException {
        return this.delegate.sign(header, signingInput);
    }
}

