/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization.method;

import java.lang.reflect.Method;
import java.util.function.Predicate;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.Pointcuts;
import org.springframework.aop.support.StaticMethodMatcherPointcut;
import org.springframework.security.authorization.AuthorizationProxyFactory;
import org.springframework.security.authorization.method.AuthorizationAdvisor;
import org.springframework.security.authorization.method.AuthorizationInterceptorsOrder;
import org.springframework.security.authorization.method.AuthorizationMethodPointcuts;
import org.springframework.security.authorization.method.AuthorizeReturnObject;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public final class AuthorizeReturnObjectMethodInterceptor
implements AuthorizationAdvisor {
    private final AuthorizationProxyFactory authorizationProxyFactory;
    private Pointcut pointcut = Pointcuts.intersection((Pointcut)new MethodReturnTypePointcut(Predicate.not(ClassUtils::isVoidType)), (Pointcut)AuthorizationMethodPointcuts.forAnnotations(AuthorizeReturnObject.class));
    private int order = AuthorizationInterceptorsOrder.SECURE_RESULT.getOrder();

    public AuthorizeReturnObjectMethodInterceptor(AuthorizationProxyFactory authorizationProxyFactory) {
        Assert.notNull((Object)authorizationProxyFactory, (String)"authorizationProxyFactory cannot be null");
        this.authorizationProxyFactory = authorizationProxyFactory;
    }

    public Object invoke(MethodInvocation mi) throws Throwable {
        Object result = mi.proceed();
        if (result == null) {
            return null;
        }
        return this.authorizationProxyFactory.proxy(result);
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    public void setPointcut(Pointcut pointcut) {
        this.pointcut = pointcut;
    }

    public Advice getAdvice() {
        return this;
    }

    public boolean isPerInstance() {
        return true;
    }

    static final class MethodReturnTypePointcut
    extends StaticMethodMatcherPointcut {
        private final Predicate<Class<?>> returnTypeMatches;

        MethodReturnTypePointcut(Predicate<Class<?>> returnTypeMatches) {
            this.returnTypeMatches = returnTypeMatches;
        }

        public boolean matches(Method method, Class<?> targetClass) {
            return this.returnTypeMatches.test(method.getReturnType());
        }
    }
}

