/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java;

import java.lang.invoke.LambdaMetafactory;
import java.lang.runtime.SwitchBootstraps;
import java.text.ParseException;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.GroupableRelatableTO;
import org.apache.syncope.common.lib.to.Item;
import org.apache.syncope.common.lib.to.Mapping;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.OrgUnit;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.core.persistence.api.EncryptorManager;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.dao.RealmSearchDAO;
import org.apache.syncope.core.persistence.api.dao.RelationshipTypeDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.Attributable;
import org.apache.syncope.core.persistence.api.entity.DerSchema;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.Groupable;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.Membership;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.Relatable;
import org.apache.syncope.core.persistence.api.entity.Relationship;
import org.apache.syncope.core.persistence.api.entity.RelationshipType;
import org.apache.syncope.core.persistence.api.entity.Schema;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.user.Account;
import org.apache.syncope.core.persistence.api.entity.user.LinkedAccount;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.api.utils.FormatUtils;
import org.apache.syncope.core.provisioning.api.AccountGetter;
import org.apache.syncope.core.provisioning.api.DerAttrHandler;
import org.apache.syncope.core.provisioning.api.IntAttrName;
import org.apache.syncope.core.provisioning.api.IntAttrNameParser;
import org.apache.syncope.core.provisioning.api.MappingManager;
import org.apache.syncope.core.provisioning.api.PlainAttrGetter;
import org.apache.syncope.core.provisioning.api.data.ItemTransformer;
import org.apache.syncope.core.provisioning.api.jexl.JexlUtils;
import org.apache.syncope.core.provisioning.java.utils.ConnObjectUtils;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.identityconnectors.framework.common.FrameworkUtil;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.Uid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

public class DefaultMappingManager
implements MappingManager {
    protected static final Logger LOG = LoggerFactory.getLogger(MappingManager.class);
    protected final AnyTypeDAO anyTypeDAO;
    protected final UserDAO userDAO;
    protected final AnyObjectDAO anyObjectDAO;
    protected final GroupDAO groupDAO;
    protected final RelationshipTypeDAO relationshipTypeDAO;
    protected final RealmSearchDAO realmSearchDAO;
    protected final ImplementationDAO implementationDAO;
    protected final DerAttrHandler derAttrHandler;
    protected final IntAttrNameParser intAttrNameParser;
    protected final EncryptorManager encryptorManager;

    protected static Optional<String> processPreparedAttr(Pair<String, Attribute> preparedAttr, Set<Attribute> attributes) {
        if (preparedAttr == null) {
            return Optional.empty();
        }
        String connObjectKey = null;
        if (preparedAttr.getLeft() != null) {
            connObjectKey = (String)preparedAttr.getLeft();
        }
        if (preparedAttr.getRight() != null) {
            Optional.ofNullable(AttributeUtil.find((String)((Attribute)preparedAttr.getRight()).getName(), attributes)).ifPresentOrElse(alreadyAdded -> {
                attributes.remove(alreadyAdded);
                HashSet values = new HashSet();
                if (!CollectionUtils.isEmpty((Collection)alreadyAdded.getValue())) {
                    values.addAll(alreadyAdded.getValue());
                }
                if (((Attribute)preparedAttr.getRight()).getValue() != null) {
                    values.addAll(((Attribute)preparedAttr.getRight()).getValue());
                }
                attributes.add(AttributeBuilder.build((String)((Attribute)preparedAttr.getRight()).getName(), values));
            }, () -> attributes.add((Attribute)preparedAttr.getRight()));
        }
        return Optional.ofNullable(connObjectKey);
    }

    protected static Name getName(String evalConnObjectLink, String connObjectKey) {
        Name name;
        if (StringUtils.isBlank((CharSequence)evalConnObjectLink)) {
            LOG.debug("Add connObjectKey [{}] as {}", (Object)connObjectKey, (Object)Name.NAME);
            name = new Name(connObjectKey);
        } else {
            LOG.debug("Add connObjectLink [{}] as {}", (Object)evalConnObjectLink, (Object)Name.NAME);
            name = new Name(evalConnObjectLink);
            LOG.debug("connObjectKey [{}] will be used as {}", (Object)connObjectKey, (Object)Uid.NAME);
        }
        return name;
    }

    protected static PlainAttrValue clonePlainAttrValue(PlainAttrValue src) {
        PlainAttrValue dst = new PlainAttrValue();
        dst.setBinaryValue(src.getBinaryValue());
        dst.setBooleanValue(src.getBooleanValue());
        dst.setDateValue(src.getDateValue());
        dst.setDoubleValue(src.getDoubleValue());
        dst.setLongValue(src.getLongValue());
        dst.setStringValue(src.getStringValue());
        return dst;
    }

    public DefaultMappingManager(AnyTypeDAO anyTypeDAO, UserDAO userDAO, AnyObjectDAO anyObjectDAO, GroupDAO groupDAO, RelationshipTypeDAO relationshipTypeDAO, RealmSearchDAO realmSearchDAO, ImplementationDAO implementationDAO, DerAttrHandler derAttrHandler, IntAttrNameParser intAttrNameParser, EncryptorManager encryptorManager) {
        this.anyTypeDAO = anyTypeDAO;
        this.userDAO = userDAO;
        this.anyObjectDAO = anyObjectDAO;
        this.groupDAO = groupDAO;
        this.relationshipTypeDAO = relationshipTypeDAO;
        this.realmSearchDAO = realmSearchDAO;
        this.implementationDAO = implementationDAO;
        this.derAttrHandler = derAttrHandler;
        this.intAttrNameParser = intAttrNameParser;
        this.encryptorManager = encryptorManager;
    }

    protected List<Implementation> getTransformers(Item item) {
        return item.getTransformers().stream().map(arg_0 -> ((ImplementationDAO)this.implementationDAO).findById(arg_0)).flatMap(Optional::stream).collect(Collectors.toList());
    }

    protected Name evaluateNAME(Any any, Provision provision, String connObjectKey) {
        if (StringUtils.isBlank((CharSequence)connObjectKey)) {
            LOG.debug("Missing connObjectKey for {}", (Object)any.getType().getKey());
        }
        String connObjectLink = Optional.ofNullable(provision.getMapping()).map(Mapping::getConnObjectLink).orElse(null);
        String evalConnObjectLink = null;
        if (StringUtils.isNotBlank((CharSequence)connObjectLink)) {
            MapContext jexlContext = new MapContext();
            JexlUtils.addFieldsToContext((Object)any, (JexlContext)jexlContext);
            JexlUtils.addPlainAttrsToContext((Collection)any.getPlainAttrs(), (JexlContext)jexlContext);
            JexlUtils.addDerAttrsToContext((Attributable)any, (DerAttrHandler)this.derAttrHandler, (JexlContext)jexlContext);
            evalConnObjectLink = JexlUtils.evaluateExpr((String)connObjectLink, (JexlContext)jexlContext).toString();
        }
        return DefaultMappingManager.getName(evalConnObjectLink, connObjectKey);
    }

    protected Name evaluateNAME(Realm realm, OrgUnit orgUnit, String connObjectKey) {
        if (StringUtils.isBlank((CharSequence)connObjectKey)) {
            LOG.debug("Missing connObjectKey for Realms");
        }
        String connObjectLink = orgUnit.getConnObjectLink();
        String evalConnObjectLink = null;
        if (StringUtils.isNotBlank((CharSequence)connObjectLink)) {
            MapContext jexlContext = new MapContext();
            JexlUtils.addFieldsToContext((Object)realm, (JexlContext)jexlContext);
            evalConnObjectLink = JexlUtils.evaluateExpr((String)connObjectLink, (JexlContext)jexlContext).toString();
        }
        return DefaultMappingManager.getName(evalConnObjectLink, connObjectKey);
    }

    @Transactional(readOnly=true)
    public Pair<String, Set<Attribute>> prepareAttrsFromAny(Any any, String password, boolean changePwd, Boolean enable, ExternalResource resource, Provision provision) {
        LOG.debug("Preparing resource attributes for {} with provision {} for attributes {}", new Object[]{any, provision, any.getPlainAttrs()});
        HashSet attributes = new HashSet();
        MutableObject connObjectKeyValue = new MutableObject();
        MappingUtils.getPropagationItems(provision.getMapping().getItems().stream()).forEach(arg_0 -> this.lambda$prepareAttrsFromAny$2(resource, provision, any, password, attributes, (Mutable)connObjectKeyValue, arg_0));
        MappingUtils.getConnObjectKeyItem(provision).ifPresent(arg_0 -> this.lambda$prepareAttrsFromAny$5(attributes, (Mutable)connObjectKeyValue, any, provision, arg_0));
        Optional.ofNullable(enable).ifPresent(e -> attributes.add(AttributeBuilder.buildEnabled((boolean)e)));
        if (!changePwd) {
            Optional.ofNullable(AttributeUtil.find((String)OperationalAttributes.PASSWORD_NAME, attributes)).ifPresent(attributes::remove);
        }
        return Pair.of((Object)((String)connObjectKeyValue.get()), attributes);
    }

    @Transactional(readOnly=true)
    public Set<Attribute> prepareAttrsFromLinkedAccount(User user, LinkedAccount account, String password, boolean changePwd, Provision provision) {
        Attribute pwdAttr;
        LOG.debug("Preparing resource attributes for linked account {} of user {} with provision {} for user attributes {} with override {}", new Object[]{account, user, provision, user.getPlainAttrs(), account.getPlainAttrs()});
        HashSet<Attribute> attributes = new HashSet<Attribute>();
        MappingUtils.getPropagationItems(provision.getMapping().getItems().stream()).forEach(item -> {
            LOG.debug("Processing expression '{}'", (Object)item.getIntAttrName());
            try {
                DefaultMappingManager.processPreparedAttr(this.prepareAttr(account.getResource(), provision, (Item)item, (Any)user, password, acct -> account.getUsername() == null ? (Account)AccountGetter.DEFAULT.apply(acct) : account, acct -> account.getPassword() == null ? (Account)AccountGetter.DEFAULT.apply(acct) : account, (attributable, schema) -> {
                    PlainAttr result = null;
                    if (attributable instanceof User) {
                        result = account.getPlainAttr(schema).orElse(null);
                    }
                    if (result == null) {
                        result = (PlainAttr)PlainAttrGetter.DEFAULT.apply(attributable, schema);
                    }
                    return result;
                }), attributes);
            }
            catch (Exception e) {
                LOG.error("Expression '{}' processing failed", (Object)item.getIntAttrName(), (Object)e);
            }
        });
        String connObjectKey = account.getConnObjectKeyValue();
        MappingUtils.getConnObjectKeyItem(provision).ifPresent(connObjectKeyItem -> {
            Attribute connObjectKeyExtAttr = AttributeUtil.find((String)connObjectKeyItem.getExtAttrName(), (Set)attributes);
            if (connObjectKeyExtAttr != null) {
                attributes.remove(connObjectKeyExtAttr);
                attributes.add(AttributeBuilder.build((String)connObjectKeyItem.getExtAttrName(), (Object[])new Object[]{connObjectKey}));
            }
            Name name = this.evaluateNAME((Any)user, provision, connObjectKey);
            attributes.add((Attribute)name);
            if (!connObjectKey.equals(name.getNameValue()) && connObjectKeyExtAttr == null) {
                attributes.add(AttributeBuilder.build((String)connObjectKeyItem.getExtAttrName(), (Object[])new Object[]{connObjectKey}));
            }
        });
        if (account.isSuspended() != null) {
            attributes.add(AttributeBuilder.buildEnabled((boolean)BooleanUtils.negate((Boolean)account.isSuspended())));
        }
        if (!changePwd && (pwdAttr = AttributeUtil.find((String)OperationalAttributes.PASSWORD_NAME, attributes)) != null) {
            attributes.remove(pwdAttr);
        }
        return attributes;
    }

    public Pair<String, Set<Attribute>> prepareAttrsFromRealm(Realm realm, ExternalResource resource) {
        if (resource.getOrgUnit() == null) {
            LOG.error("No mapping configured for Realms");
            return Pair.of(null, Set.of());
        }
        LOG.debug("Preparing resource attributes for {} with orgUnit {}", (Object)realm, (Object)resource.getOrgUnit());
        HashSet attributes = new HashSet();
        MutableObject connObjectKeyValue = new MutableObject();
        MappingUtils.getPropagationItems(resource.getOrgUnit().getItems().stream()).forEach(arg_0 -> this.lambda$prepareAttrsFromRealm$12(resource, realm, attributes, (Mutable)connObjectKeyValue, arg_0));
        resource.getOrgUnit().getConnObjectKeyItem().ifPresent(arg_0 -> this.lambda$prepareAttrsFromRealm$15(attributes, (Mutable)connObjectKeyValue, realm, resource, arg_0));
        return Pair.of((Object)((String)connObjectKeyValue.get()), attributes);
    }

    protected Optional<String> decodePassword(Account account) {
        try {
            return Optional.of(this.encryptorManager.getInstance().decode(account.getPassword(), account.getCipherAlgorithm()));
        }
        catch (Exception e) {
            LOG.error("Could not decode password for {}", (Object)account, (Object)e);
            return Optional.empty();
        }
    }

    protected Optional<String> getPasswordAttrValue(Account account, String defaultValue) {
        Optional<String> passwordAttrValue = account instanceof LinkedAccount ? (account.getPassword() == null ? Optional.of(defaultValue) : this.decodePassword(account)) : (StringUtils.isNotBlank((CharSequence)defaultValue) ? Optional.of(defaultValue) : (account.canDecodeSecrets() ? this.decodePassword(account) : Optional.empty()));
        return passwordAttrValue;
    }

    public Pair<String, Attribute> prepareAttr(ExternalResource resource, Provision provision, Item item, Any any, String password, AccountGetter usernameAccountGetter, AccountGetter passwordAccountGetter, PlainAttrGetter plainAttrGetter) {
        Pair result;
        IntAttrName intAttrName;
        try {
            intAttrName = this.intAttrNameParser.parse(item.getIntAttrName(), any.getType().getKind());
        }
        catch (ParseException e) {
            LOG.error("Invalid intAttrName '{}' specified, ignoring", (Object)item.getIntAttrName(), (Object)e);
            return null;
        }
        AttrSchemaType schemaType = intAttrName.getSchema() instanceof PlainSchema ? intAttrName.getSchema().getType() : AttrSchemaType.String;
        Pair<AttrSchemaType, List<PlainAttrValue>> intValues = this.getIntValues(resource, provision, item, intAttrName, schemaType, any, usernameAccountGetter, plainAttrGetter);
        schemaType = (AttrSchemaType)intValues.getLeft();
        List values = (List)intValues.getRight();
        LOG.debug("Define mapping for:\n* Item {}\n* Schema {}\n* ClassType {}\n* AttrSchemaType {}\n* Values {}", new Object[]{item, intAttrName.getSchema(), schemaType.getType().getName(), schemaType, values});
        ArrayList<Object> objValues = new ArrayList<Object>();
        for (PlainAttrValue value : values) {
            PlainSchema schema;
            PlainSchema plainSchema;
            Schema schema2 = intAttrName.getSchema();
            if (schema2 instanceof PlainSchema) {
                PlainSchema schema3 = (PlainSchema)schema2;
                if (schemaType == AttrSchemaType.Encrypted) {
                    String decoded = null;
                    try {
                        decoded = this.encryptorManager.getInstance(schema3.getSecretKey()).decode(value.getStringValue(), schema3.getCipherAlgorithm());
                    }
                    catch (Exception e) {
                        LOG.warn("Could not decode value for {} with algorithm {}", new Object[]{intAttrName.getSchema(), schema3.getCipherAlgorithm(), e});
                    }
                    objValues.add(Optional.ofNullable(decoded).orElse(value.getStringValue()));
                    continue;
                }
            }
            if (FrameworkUtil.isSupportedAttributeType((Class)schemaType.getType())) {
                objValues.add(value.getValue());
                continue;
            }
            Schema schema4 = intAttrName.getSchema();
            PlainSchema plainSchema2 = plainSchema = schema4 instanceof PlainSchema ? (schema = (PlainSchema)schema4) : null;
            if (plainSchema == null || plainSchema.getType() != schemaType) {
                objValues.add(value.getValueAsString(schemaType));
                continue;
            }
            objValues.add(value.getValueAsString(plainSchema));
        }
        if (item.isConnObjectKey()) {
            result = Pair.of((Object)(objValues.isEmpty() ? null : objValues.getFirst().toString()), null);
        } else if (item.isPassword() && any instanceof User) {
            User user = (User)any;
            result = this.getPasswordAttrValue((Account)passwordAccountGetter.apply((Object)user), password).map(passwordAttrValue -> Pair.of((Object)null, (Object)AttributeBuilder.buildPassword((char[])passwordAttrValue.toCharArray()))).orElse(null);
        } else {
            result = objValues.isEmpty() ? Pair.of(null, (Object)AttributeBuilder.build((String)item.getExtAttrName())) : (OperationalAttributes.PASSWORD_NAME.equals(item.getExtAttrName()) ? Pair.of(null, (Object)AttributeBuilder.buildPassword((char[])objValues.getFirst().toString().toCharArray())) : Pair.of(null, (Object)AttributeBuilder.build((String)item.getExtAttrName(), objValues)));
        }
        return result;
    }

    public Pair<String, Attribute> prepareAttr(ExternalResource resource, Item item, Realm realm) {
        IntAttrName intAttrName;
        try {
            intAttrName = this.intAttrNameParser.parse(item.getIntAttrName());
        }
        catch (ParseException e) {
            LOG.error("Invalid intAttrName '{}' specified, ignoring", (Object)item.getIntAttrName(), (Object)e);
            return null;
        }
        AttrSchemaType schemaType = intAttrName.getSchema() instanceof PlainSchema ? intAttrName.getSchema().getType() : AttrSchemaType.String;
        Pair<AttrSchemaType, List<PlainAttrValue>> intValues = this.getIntValues(resource, item, intAttrName, schemaType, realm);
        schemaType = (AttrSchemaType)intValues.getLeft();
        List values = (List)intValues.getRight();
        LOG.debug("Define mapping for:\n* Item {}\n* Schema {}\n* ClassType {}\n* AttrSchemaType {}\n* Values {}", new Object[]{item, intAttrName.getSchema(), schemaType.getType().getName(), schemaType, values});
        ArrayList<Object> objValues = new ArrayList<Object>();
        for (PlainAttrValue value : values) {
            PlainSchema schema;
            PlainSchema plainSchema;
            Schema schema2 = intAttrName.getSchema();
            if (schema2 instanceof PlainSchema) {
                PlainSchema schema3 = (PlainSchema)schema2;
                if (schemaType == AttrSchemaType.Encrypted) {
                    String decoded = null;
                    try {
                        decoded = this.encryptorManager.getInstance(schema3.getSecretKey()).decode(value.getStringValue(), schema3.getCipherAlgorithm());
                    }
                    catch (Exception e) {
                        LOG.warn("Could not decode value for {} with algorithm {}", new Object[]{intAttrName.getSchema(), schema3.getCipherAlgorithm(), e});
                    }
                    objValues.add(Optional.ofNullable(decoded).orElse(value.getStringValue()));
                    continue;
                }
            }
            if (FrameworkUtil.isSupportedAttributeType((Class)schemaType.getType())) {
                objValues.add(value.getValue());
                continue;
            }
            Schema schema4 = intAttrName.getSchema();
            PlainSchema plainSchema2 = plainSchema = schema4 instanceof PlainSchema ? (schema = (PlainSchema)schema4) : null;
            if (plainSchema == null || plainSchema.getType() != schemaType) {
                objValues.add(value.getValueAsString(schemaType));
                continue;
            }
            objValues.add(value.getValueAsString(plainSchema));
        }
        Pair result = item.isConnObjectKey() ? Pair.of((Object)(objValues.isEmpty() ? null : objValues.getFirst().toString()), null) : (objValues.isEmpty() ? Pair.of(null, (Object)AttributeBuilder.build((String)item.getExtAttrName())) : (OperationalAttributes.PASSWORD_NAME.equals(item.getExtAttrName()) ? Pair.of(null, (Object)AttributeBuilder.buildPassword((char[])objValues.iterator().next().toString().toCharArray())) : Pair.of(null, (Object)AttributeBuilder.build((String)item.getExtAttrName(), objValues))));
        return result;
    }

    @Transactional(readOnly=true)
    public Pair<AttrSchemaType, List<PlainAttrValue>> getIntValues(ExternalResource resource, Provision provision, Item item, IntAttrName intAttrName, AttrSchemaType schemaType, Any any, AccountGetter usernameAccountGetter, PlainAttrGetter plainAttrGetter) {
        LOG.debug("Get internal values for {} as '{}' on {}", new Object[]{any, item.getIntAttrName(), resource});
        ArrayList<Object> references = new ArrayList<Object>();
        if (intAttrName.getEnclosingGroup() == null && intAttrName.getRelatedAnyObject() == null && intAttrName.getRelationshipAnyType() == null && intAttrName.getRelationshipType() == null && intAttrName.getRelatedUser() == null) {
            references.add(any);
        }
        Membership membership = null;
        if (intAttrName.getEnclosingGroup() != null) {
            AnyObject anyObject;
            Group group2 = this.groupDAO.findByName(intAttrName.getEnclosingGroup()).orElse(null);
            if (group2 == null || any instanceof User ? !this.userDAO.findAllGroupKeys((User)any).contains(group2.getKey()) : any instanceof AnyObject && !this.anyObjectDAO.findAllGroupKeys(anyObject = (AnyObject)any).contains(group2.getKey())) {
                LOG.warn("No (dyn) membership for {} in {}, ignoring", (Object)intAttrName.getEnclosingGroup(), (Object)any);
            } else {
                references.add(group2);
            }
        } else if (intAttrName.getRelatedUser() != null) {
            User user = this.userDAO.findByUsername(intAttrName.getRelatedUser()).orElse(null);
            if (user == null || user.getRelationships(any.getKey()).isEmpty()) {
                LOG.warn("No relationship for {} in {}, ignoring", (Object)intAttrName.getRelatedUser(), (Object)any);
            } else if (any.getType().getKind() == AnyTypeKind.USER) {
                LOG.warn("Users cannot have relationship with other users, ignoring");
            } else {
                references.add(user);
            }
        } else if (intAttrName.getRelatedAnyObject() != null && any instanceof Relatable) {
            Relatable relatable = (Relatable)any;
            AnyObject anyObject = this.anyObjectDAO.findById(intAttrName.getRelatedAnyObject()).orElse(null);
            if (anyObject == null || relatable.getRelationships(anyObject.getKey()).isEmpty()) {
                LOG.warn("No relationship for {} in {}, ignoring", (Object)intAttrName.getRelatedAnyObject(), (Object)relatable);
            } else {
                references.add(anyObject);
            }
        } else if (intAttrName.getRelationshipAnyType() != null && intAttrName.getRelationshipType() != null && any instanceof Relatable) {
            Relatable relatable = (Relatable)any;
            RelationshipType relationshipType = this.relationshipTypeDAO.findById(intAttrName.getRelationshipType()).orElse(null);
            AnyType anyType = this.anyTypeDAO.findById(intAttrName.getRelationshipAnyType()).orElse(null);
            if (relationshipType == null || relatable.getRelationships(relationshipType).isEmpty()) {
                LOG.warn("No relationship for type {} in {}, ignoring", (Object)intAttrName.getRelationshipType(), (Object)relatable);
            } else if (anyType == null) {
                LOG.warn("No anyType {}, ignoring", (Object)intAttrName.getRelationshipAnyType());
            } else {
                references.addAll(relatable.getRelationships(relationshipType).stream().filter(relationship -> anyType.equals((Object)relationship.getRightEnd().getType())).map(Relationship::getRightEnd).toList());
            }
        } else if (intAttrName.getMembershipOfGroup() != null && any instanceof Groupable) {
            Groupable groupable = (Groupable)any;
            membership = this.groupDAO.findByName(intAttrName.getMembershipOfGroup()).flatMap(group -> groupable.getMembership(group.getKey())).orElse(null);
        }
        if (references.isEmpty()) {
            LOG.warn("Could not determine the reference instance for {}", (Object)item.getIntAttrName());
            return Pair.of((Object)schemaType, List.of());
        }
        ArrayList<PlainAttrValue> values = new ArrayList<PlainAttrValue>();
        boolean transform = true;
        block25: for (Any any2 : references) {
            if (intAttrName.getField() != null) {
                PlainAttrValue attrValue = new PlainAttrValue();
                switch (intAttrName.getField()) {
                    case "key": {
                        attrValue.setStringValue(any2.getKey());
                        values.add(attrValue);
                        break;
                    }
                    case "username": {
                        if (!(any2 instanceof Account)) continue block25;
                        Account account = (Account)any2;
                        attrValue.setStringValue(((Account)usernameAccountGetter.apply((Object)account)).getUsername());
                        values.add(attrValue);
                        break;
                    }
                    case "realm": {
                        attrValue.setStringValue(any2.getRealm().getFullPath());
                        values.add(attrValue);
                        break;
                    }
                    case "password": {
                        break;
                    }
                    case "userOwner": 
                    case "groupOwner": {
                        Mapping gMappingTO;
                        Mapping uMappingTO = provision.getAnyType().equals(AnyTypeKind.USER.name()) ? provision.getMapping() : null;
                        Mapping mapping = gMappingTO = provision.getAnyType().equals(AnyTypeKind.GROUP.name()) ? provision.getMapping() : null;
                        if (!(any2 instanceof Group)) continue block25;
                        Group group3 = (Group)any2;
                        String groupOwnerValue = null;
                        if (group3.getUserOwner() != null && uMappingTO != null) {
                            groupOwnerValue = this.getGroupOwnerValue(resource, provision, (Any)group3.getUserOwner());
                        }
                        if (group3.getGroupOwner() != null && gMappingTO != null) {
                            groupOwnerValue = this.getGroupOwnerValue(resource, provision, (Any)group3.getGroupOwner());
                        }
                        if (!StringUtils.isNotBlank(groupOwnerValue)) continue block25;
                        attrValue.setStringValue(groupOwnerValue);
                        values.add(attrValue);
                        break;
                    }
                    case "suspended": {
                        if (!(any2 instanceof User)) continue block25;
                        User user = (User)any2;
                        attrValue.setBooleanValue(user.isSuspended());
                        values.add(attrValue);
                        break;
                    }
                    case "mustChangePassword": {
                        if (!(any2 instanceof User)) continue block25;
                        User user = (User)any2;
                        attrValue.setBooleanValue(Boolean.valueOf(user.isMustChangePassword()));
                        values.add(attrValue);
                        break;
                    }
                    default: {
                        try {
                            Object fieldValue = FieldUtils.readField((Object)any2, (String)intAttrName.getField(), (boolean)true);
                            if (fieldValue instanceof TemporalAccessor) {
                                TemporalAccessor temporalAccessor = (TemporalAccessor)fieldValue;
                                attrValue.setStringValue(FormatUtils.format((TemporalAccessor)temporalAccessor));
                            } else if (Boolean.TYPE.isInstance(fieldValue)) {
                                attrValue.setBooleanValue((Boolean)fieldValue);
                            } else if (Double.TYPE.isInstance(fieldValue) || Float.TYPE.isInstance(fieldValue)) {
                                attrValue.setDoubleValue((Double)fieldValue);
                            } else if (Long.TYPE.isInstance(fieldValue) || Integer.TYPE.isInstance(fieldValue)) {
                                attrValue.setLongValue((Long)fieldValue);
                            } else {
                                attrValue.setStringValue(fieldValue.toString());
                            }
                            values.add(attrValue);
                            break;
                        }
                        catch (Exception e) {
                            LOG.error("Could not read value of '{}' from {}", new Object[]{intAttrName.getField(), any2, e});
                        }
                    }
                }
                continue;
            }
            if (intAttrName.getSchemaType() == null) continue;
            switch (intAttrName.getSchemaType()) {
                case PLAIN: {
                    PlainAttr attr = membership == null ? (PlainAttr)plainAttrGetter.apply((Object)any2, (Object)intAttrName.getSchema().getKey()) : (PlainAttr)((Groupable)any2).getPlainAttr(intAttrName.getSchema().getKey(), membership).orElse(null);
                    if (attr == null) continue block25;
                    if (attr.getUniqueValue() != null) {
                        values.add(DefaultMappingManager.clonePlainAttrValue(attr.getUniqueValue()));
                        break;
                    }
                    if (attr.getValues() == null) continue block25;
                    attr.getValues().forEach(value -> values.add(DefaultMappingManager.clonePlainAttrValue(value)));
                    break;
                }
                case DERIVED: {
                    DerSchema derSchema = (DerSchema)intAttrName.getSchema();
                    String derValue = membership == null ? this.derAttrHandler.getValue(any2, derSchema) : this.derAttrHandler.getValue(any2, membership, derSchema);
                    if (derValue == null) continue block25;
                    PlainAttrValue attrValue = new PlainAttrValue();
                    attrValue.setStringValue(derValue);
                    values.add(attrValue);
                    break;
                }
            }
        }
        LOG.debug("Internal values: {}", values);
        Pair transformed = Pair.of((Object)schemaType, values);
        if (transform) {
            for (ItemTransformer transformer : MappingUtils.getItemTransformers(item, this.getTransformers(item))) {
                transformed = transformer.beforePropagation(item, any, (AttrSchemaType)transformed.getLeft(), (List)transformed.getRight());
            }
            LOG.debug("Transformed values: {}", values);
        } else {
            LOG.debug("No transformation occurred");
        }
        return transformed;
    }

    @Transactional(readOnly=true)
    public Pair<AttrSchemaType, List<PlainAttrValue>> getIntValues(ExternalResource resource, Item item, IntAttrName intAttrName, AttrSchemaType schemaType, Realm realm) {
        LOG.debug("Get internal values for {} as '{}' on {}", new Object[]{realm, item.getIntAttrName(), resource});
        ArrayList<PlainAttrValue> values = new ArrayList<PlainAttrValue>();
        boolean transform = true;
        if (intAttrName.getField() != null) {
            PlainAttrValue attrValue = new PlainAttrValue();
            switch (intAttrName.getField()) {
                case "key": {
                    attrValue.setStringValue(realm.getKey());
                    values.add(attrValue);
                    break;
                }
                case "name": {
                    attrValue.setStringValue(realm.getName());
                    values.add(attrValue);
                    break;
                }
                case "fullPath": {
                    attrValue.setStringValue(realm.getFullPath());
                    values.add(attrValue);
                    break;
                }
            }
        } else if (intAttrName.getSchemaType() != null) {
            switch (intAttrName.getSchemaType()) {
                case PLAIN: {
                    realm.getPlainAttr(intAttrName.getSchema().getKey()).ifPresent(attr -> {
                        if (attr.getUniqueValue() != null) {
                            values.add(DefaultMappingManager.clonePlainAttrValue(attr.getUniqueValue()));
                        } else if (attr.getValues() != null) {
                            attr.getValues().forEach(value -> values.add(DefaultMappingManager.clonePlainAttrValue(value)));
                        }
                    });
                    break;
                }
                case DERIVED: {
                    Optional.ofNullable(this.derAttrHandler.getValue(realm, (DerSchema)intAttrName.getSchema())).ifPresent(derValue -> {
                        PlainAttrValue attrValue = new PlainAttrValue();
                        attrValue.setStringValue(derValue);
                        values.add(attrValue);
                    });
                    break;
                }
            }
        }
        LOG.debug("Internal values: {}", values);
        Pair transformed = Pair.of((Object)schemaType, values);
        if (transform) {
            for (ItemTransformer transformer : MappingUtils.getItemTransformers(item, this.getTransformers(item))) {
                transformed = transformer.beforePropagation(item, realm, (AttrSchemaType)transformed.getLeft(), (List)transformed.getRight());
            }
            LOG.debug("Transformed values: {}", values);
        } else {
            LOG.debug("No transformation occurred");
        }
        return transformed;
    }

    protected String getGroupOwnerValue(ExternalResource resource, Provision provision, Any any) {
        Optional<Item> connObjectKeyItem = MappingUtils.getConnObjectKeyItem(provision);
        Pair<String, Attribute> preparedAttr = null;
        if (connObjectKeyItem.isPresent()) {
            preparedAttr = this.prepareAttr(resource, provision, connObjectKeyItem.get(), any, null, AccountGetter.DEFAULT, AccountGetter.DEFAULT, PlainAttrGetter.DEFAULT);
        }
        return Optional.ofNullable(preparedAttr).map(attr -> this.evaluateNAME(any, provision, (String)attr.getKey()).getNameValue()).orElse(null);
    }

    @Transactional(readOnly=true)
    public Optional<String> getConnObjectKeyValue(Any any, ExternalResource resource, Provision provision) {
        Pair<AttrSchemaType, List<PlainAttrValue>> intValues;
        Optional connObjectKeyItem = provision.getMapping().getConnObjectKeyItem();
        if (connObjectKeyItem.isEmpty()) {
            LOG.error("Unable to locate conn object key item for {}", (Object)any.getType().getKey());
            return Optional.empty();
        }
        Item item = (Item)connObjectKeyItem.get();
        try {
            intValues = this.getIntValues(resource, provision, item, this.intAttrNameParser.parse(item.getIntAttrName(), any.getType().getKind()), AttrSchemaType.String, any, AccountGetter.DEFAULT, PlainAttrGetter.DEFAULT);
        }
        catch (ParseException e) {
            LOG.error("Invalid intAttrName '{}' specified, ignoring", (Object)item.getIntAttrName(), (Object)e);
            intValues = Pair.of((Object)AttrSchemaType.String, List.of());
        }
        return ((List)intValues.getRight()).isEmpty() ? Optional.empty() : Optional.of(((PlainAttrValue)((List)intValues.getRight()).getFirst()).getValueAsString());
    }

    @Transactional(readOnly=true)
    public Optional<String> getConnObjectKeyValue(Realm realm, ExternalResource resource) {
        Pair intValues;
        if (resource.getOrgUnit() == null) {
            LOG.error("No mapping configured for Realms");
            return Optional.empty();
        }
        Optional connObjectKeyItem = resource.getOrgUnit().getConnObjectKeyItem();
        if (connObjectKeyItem.isEmpty()) {
            LOG.error("Unable to locate conn object key item for Realms");
            return Optional.empty();
        }
        Item item = (Item)connObjectKeyItem.get();
        try {
            intValues = this.getIntValues(resource, item, this.intAttrNameParser.parse(item.getIntAttrName()), AttrSchemaType.String, realm);
        }
        catch (ParseException e) {
            LOG.error("Invalid intAttrName '{}' specified, ignoring", (Object)item.getIntAttrName(), (Object)e);
            intValues = Pair.of((Object)AttrSchemaType.String, List.of());
        }
        return ((List)intValues.getRight()).isEmpty() ? Optional.empty() : Optional.of(((PlainAttrValue)((List)intValues.getRight()).getFirst()).getValueAsString());
    }

    /*
     * Unable to fully structure code
     */
    @Transactional(readOnly=true)
    public void setIntValues(Item item, Attribute attr, AnyTO anyTO) {
        block39: {
            block38: {
                values = null;
                if (attr != null) {
                    values = attr.getValue();
                    for (ItemTransformer transformer : MappingUtils.getItemTransformers(item, this.getTransformers(item))) {
                        values = transformer.beforePull(item, (EntityTO)anyTO, values);
                    }
                }
                values = Optional.ofNullable(values).orElseGet((Supplier<List>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, of(), ()Ljava/util/List;)());
                try {
                    intAttrName = this.intAttrNameParser.parse(item.getIntAttrName(), AnyTypeKind.fromTOClass(anyTO.getClass()));
                }
                catch (ParseException e) {
                    DefaultMappingManager.LOG.error("Invalid intAttrName '{}' specified, ignoring", (Object)item.getIntAttrName(), (Object)e);
                    return;
                }
                if (intAttrName.getField() == null) break block38;
                e = intAttrName.getField();
                var7_8 = -1;
                switch (e.hashCode()) {
                    case 1216985755: {
                        if (!e.equals("password")) break;
                        var7_8 = 0;
                        break;
                    }
                    case -265713450: {
                        if (!e.equals("username")) break;
                        var7_8 = 1;
                        break;
                    }
                    case 3373707: {
                        if (!e.equals("name")) break;
                        var7_8 = 2;
                        break;
                    }
                    case -1753359148: {
                        if (!e.equals("mustChangePassword")) break;
                        var7_8 = 3;
                        break;
                    }
                    case 324844968: {
                        if (!e.equals("userOwner")) break;
                        var7_8 = 4;
                        break;
                    }
                    case 1267811188: {
                        if (!e.equals("groupOwner")) break;
                        var7_8 = 5;
                    }
                }
                block9 : switch (var7_8) {
                    case 0: {
                        if (!(anyTO instanceof UserTO) || values.isEmpty()) break;
                        ((UserTO)anyTO).setPassword(ConnObjectUtils.getPassword(values.getFirst()));
                        break;
                    }
                    case 1: {
                        if (anyTO instanceof UserTO) {
                            userTO = (UserTO)anyTO;
                            userTO.setUsername(values.isEmpty() != false || values.getFirst() == null ? null : values.getFirst().toString());
                            break;
                        }
                        break block39;
                    }
                    case 2: {
                        v0 = anyTO;
                        Objects.requireNonNull(v0);
                        userTO = v0;
                        var9_14 = 0;
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GroupTO.class, AnyObjectTO.class}, (Object)userTO, var9_14)) {
                            case 0: {
                                groupTO = (GroupTO)userTO;
                                groupTO.setName(values.isEmpty() != false || values.getFirst() == null ? null : values.getFirst().toString());
                                break block9;
                            }
                            case 1: {
                                anyObjectTO = (AnyObjectTO)userTO;
                                anyObjectTO.setName(values.isEmpty() != false || values.getFirst() == null ? null : values.getFirst().toString());
                                break block9;
                            }
                        }
                        break;
                    }
                    case 3: {
                        if (!(anyTO instanceof UserTO) || values.isEmpty() || values.getFirst() == null) break;
                        ((UserTO)anyTO).setMustChangePassword(BooleanUtils.toBoolean((String)values.getFirst().toString()));
                        break;
                    }
                    case 4: 
                    case 5: {
                        if (anyTO instanceof GroupTO) {
                            groupTO = (GroupTO)anyTO;
                            if (attr != null) {
                                attrTO = new Attr();
                                attrTO.setSchema("");
                                if (values.isEmpty() || values.getFirst() == null) {
                                    attrTO.getValues().add("");
                                } else {
                                    attrTO.getValues().add(values.getFirst().toString());
                                }
                                groupTO.getPlainAttrs().add(attrTO);
                                break;
                            }
                        }
                        break block39;
                    }
                }
                break block39;
            }
            if (intAttrName.getSchemaType() == null || attr == null) break block39;
            if (!(anyTO instanceof GroupableRelatableTO)) ** GOTO lbl-1000
            groupableRelatableTO = (GroupableRelatableTO)anyTO;
            if (intAttrName.getMembershipOfGroup() != null) {
                groupableTO = groupableRelatableTO;
                group = this.groupDAO.findByName(intAttrName.getMembershipOfGroup()).orElse(null);
            } else lbl-1000:
            // 2 sources

            {
                groupableTO = null;
                group = null;
            }
            switch (1.$SwitchMap$org$apache$syncope$common$lib$types$SchemaType[intAttrName.getSchemaType().ordinal()]) {
                case 1: {
                    attrTO = new Attr();
                    attrTO.setSchema(intAttrName.getSchema().getKey());
                    schema = (PlainSchema)intAttrName.getSchema();
                    for (E value : values) {
                        v1 = schemaType = schema == null ? AttrSchemaType.String : schema.getType();
                        if (value == null) continue;
                        if (schemaType == AttrSchemaType.Binary) {
                            attrTO.getValues().add(Base64.getEncoder().encodeToString((byte[])value));
                            continue;
                        }
                        attrTO.getValues().add(value.toString());
                    }
                    if (groupableTO == null || group == null) {
                        anyTO.getPlainAttrs().add(attrTO);
                        break;
                    }
                    membership = groupableTO.getMembership(group.getKey()).orElseGet((Supplier<MembershipTO>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$setIntValues$24(org.apache.syncope.core.persistence.api.entity.group.Group org.apache.syncope.common.lib.to.GroupableRelatableTO ), ()Lorg/apache/syncope/common/lib/to/MembershipTO;)((Group)group, (GroupableRelatableTO)groupableTO));
                    membership.getPlainAttrs().add(attrTO);
                    break;
                }
                case 2: {
                    attrTO = new Attr();
                    attrTO.setSchema(intAttrName.getSchema().getKey());
                    if (groupableTO == null || group == null) {
                        anyTO.getDerAttrs().add(attrTO);
                        break;
                    }
                    membership = groupableTO.getMembership(group.getKey()).orElseGet((Supplier<MembershipTO>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$setIntValues$25(org.apache.syncope.core.persistence.api.entity.group.Group org.apache.syncope.common.lib.to.GroupableRelatableTO ), ()Lorg/apache/syncope/common/lib/to/MembershipTO;)((Group)group, (GroupableRelatableTO)groupableTO));
                    membership.getDerAttrs().add(attrTO);
                    break;
                }
            }
        }
    }

    public void setIntValues(Item item, Attribute attr, RealmTO realmTO) {
        IntAttrName intAttrName;
        List values = null;
        if (attr != null) {
            values = attr.getValue();
            for (ItemTransformer transformer : MappingUtils.getItemTransformers(item, this.getTransformers(item))) {
                values = transformer.beforePull(item, (EntityTO)realmTO, values);
            }
        }
        values = Optional.ofNullable(values).orElseGet(List::of);
        try {
            intAttrName = this.intAttrNameParser.parse(item.getIntAttrName());
        }
        catch (ParseException e) {
            LOG.error("Invalid intAttrName '{}' specified, ignoring", (Object)item.getIntAttrName(), (Object)e);
            return;
        }
        if (intAttrName.getField() != null) {
            switch (intAttrName.getField()) {
                case "name": {
                    realmTO.setName(values.isEmpty() || values.getFirst() == null ? null : values.getFirst().toString());
                    break;
                }
                case "fullpath": {
                    String parentFullPath = StringUtils.substringBeforeLast((String)values.getFirst().toString(), (String)"/");
                    this.realmSearchDAO.findByFullPath(parentFullPath).ifPresentOrElse(parent -> realmTO.setParent(parent.getFullPath()), () -> LOG.warn("Could not find Realm with path {}, ignoring", (Object)parentFullPath));
                    break;
                }
            }
        } else if (intAttrName.getSchemaType() != null && attr != null) {
            switch (intAttrName.getSchemaType()) {
                case PLAIN: {
                    Attr attrTO = new Attr();
                    attrTO.setSchema(intAttrName.getSchema().getKey());
                    PlainSchema schema = (PlainSchema)intAttrName.getSchema();
                    for (Object value : values) {
                        AttrSchemaType schemaType;
                        AttrSchemaType attrSchemaType = schemaType = schema == null ? AttrSchemaType.String : schema.getType();
                        if (value == null) continue;
                        if (schemaType == AttrSchemaType.Binary) {
                            attrTO.getValues().add(Base64.getEncoder().encodeToString((byte[])value));
                            continue;
                        }
                        attrTO.getValues().add(value.toString());
                    }
                    realmTO.getPlainAttrs().add(attrTO);
                    break;
                }
                case DERIVED: {
                    Attr attrTO = new Attr();
                    attrTO.setSchema(intAttrName.getSchema().getKey());
                    realmTO.getDerAttrs().add(attrTO);
                    break;
                }
            }
        }
    }

    public boolean hasMustChangePassword(Provision provision) {
        return Optional.ofNullable(provision.getMapping()).map(mapping -> mapping.getItems().stream().anyMatch(item -> "mustChangePassword".equals(item.getIntAttrName()))).orElse(false);
    }

    private static /* synthetic */ MembershipTO lambda$setIntValues$25(Group group, GroupableRelatableTO groupableTO) {
        MembershipTO newMemb = new MembershipTO.Builder(group.getKey()).build();
        groupableTO.getMemberships().add(newMemb);
        return newMemb;
    }

    private static /* synthetic */ MembershipTO lambda$setIntValues$24(Group group, GroupableRelatableTO groupableTO) {
        MembershipTO newMemb = new MembershipTO.Builder(group.getKey()).build();
        groupableTO.getMemberships().add(newMemb);
        return newMemb;
    }

    private /* synthetic */ void lambda$prepareAttrsFromRealm$15(Set attributes, Mutable connObjectKeyValue, Realm realm, ExternalResource resource, Item item) {
        Attribute connObjectKeyAttr = AttributeUtil.find((String)item.getExtAttrName(), (Set)attributes);
        if (connObjectKeyAttr != null) {
            attributes.remove(connObjectKeyAttr);
            attributes.add(AttributeBuilder.build((String)item.getExtAttrName(), (Object[])new Object[]{connObjectKeyValue.get()}));
        }
        Name name = this.evaluateNAME(realm, resource.getOrgUnit(), (String)connObjectKeyValue.get());
        attributes.add(name);
        Optional.ofNullable((String)connObjectKeyValue.get()).filter(cokv -> connObjectKeyAttr == null && !cokv.equals(name.getNameValue())).ifPresent(cokv -> attributes.add(AttributeBuilder.build((String)item.getExtAttrName(), (Object[])new Object[]{cokv})));
    }

    private /* synthetic */ void lambda$prepareAttrsFromRealm$12(ExternalResource resource, Realm realm, Set attributes, Mutable connObjectKeyValue, Item item) {
        LOG.debug("Processing expression '{}'", (Object)item.getIntAttrName());
        try {
            DefaultMappingManager.processPreparedAttr(this.prepareAttr(resource, item, realm), attributes).ifPresent(arg_0 -> ((Mutable)connObjectKeyValue).setValue(arg_0));
        }
        catch (Exception e) {
            LOG.error("Expression '{}' processing failed", (Object)item.getIntAttrName(), (Object)e);
        }
    }

    private /* synthetic */ void lambda$prepareAttrsFromAny$5(Set attributes, Mutable connObjectKeyValue, Any any, Provision provision, Item item) {
        Attribute connObjectKeyAttr = AttributeUtil.find((String)item.getExtAttrName(), (Set)attributes);
        if (connObjectKeyAttr != null) {
            attributes.remove(connObjectKeyAttr);
            attributes.add(AttributeBuilder.build((String)item.getExtAttrName(), (Object[])new Object[]{connObjectKeyValue.get()}));
        }
        Name name = this.evaluateNAME(any, provision, (String)connObjectKeyValue.get());
        attributes.add(name);
        Optional.ofNullable((String)connObjectKeyValue.get()).filter(cokv -> connObjectKeyAttr == null && !cokv.equals(name.getNameValue())).ifPresent(cokv -> attributes.add(AttributeBuilder.build((String)item.getExtAttrName(), (Object[])new Object[]{cokv})));
    }

    private /* synthetic */ void lambda$prepareAttrsFromAny$2(ExternalResource resource, Provision provision, Any any, String password, Set attributes, Mutable connObjectKeyValue, Item item) {
        LOG.debug("Processing expression '{}'", (Object)item.getIntAttrName());
        try {
            DefaultMappingManager.processPreparedAttr(this.prepareAttr(resource, provision, item, any, password, AccountGetter.DEFAULT, AccountGetter.DEFAULT, PlainAttrGetter.DEFAULT), attributes).ifPresent(arg_0 -> ((Mutable)connObjectKeyValue).setValue(arg_0));
        }
        catch (Exception e) {
            LOG.error("Expression '{}' processing failed", (Object)item.getIntAttrName(), (Object)e);
        }
    }
}

