/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.FIQLQueryTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.FIQLQuery;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.api.search.SearchCondConverter;
import org.apache.syncope.core.persistence.api.search.SearchCondVisitor;
import org.apache.syncope.core.provisioning.api.data.FIQLQueryDataBinder;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FIQLQueryDataBinderImpl
implements FIQLQueryDataBinder {
    protected static final Logger LOG = LoggerFactory.getLogger(FIQLQueryDataBinder.class);
    protected final SearchCondVisitor searchCondVisitor;
    protected final UserDAO userDAO;
    protected final EntityFactory entityFactory;

    public FIQLQueryDataBinderImpl(SearchCondVisitor searchCondVisitor, UserDAO userDAO, EntityFactory entityFactory) {
        this.searchCondVisitor = searchCondVisitor;
        this.userDAO = userDAO;
        this.entityFactory = entityFactory;
    }

    public FIQLQuery create(FIQLQueryTO fiqlQueryTO) {
        FIQLQuery fiqlQuery = (FIQLQuery)this.entityFactory.newEntity(FIQLQuery.class);
        fiqlQuery.setOwner((User)this.userDAO.findByUsername(AuthContextUtils.getUsername()).orElseThrow(() -> new NotFoundException("User " + AuthContextUtils.getUsername())));
        return this.update(fiqlQuery, fiqlQueryTO);
    }

    public FIQLQuery update(FIQLQuery fiqlQuery, FIQLQueryTO fiqlQueryTO) {
        fiqlQuery.setName(fiqlQueryTO.getName());
        fiqlQuery.setTarget(fiqlQueryTO.getTarget());
        SearchCond cond = SearchCondConverter.convert((SearchCondVisitor)this.searchCondVisitor, (String)fiqlQueryTO.getFiql(), (String[])new String[0]);
        if (!cond.isValid()) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidSearchParameters);
            sce.getElements().add(fiqlQueryTO.getFiql());
            throw sce;
        }
        fiqlQuery.setFIQL(fiqlQueryTO.getFiql());
        return fiqlQuery;
    }

    public FIQLQueryTO getFIQLQueryTO(FIQLQuery fiqlQuery) {
        FIQLQueryTO fiqlQueryTO = new FIQLQueryTO();
        fiqlQueryTO.setKey(fiqlQuery.getKey());
        fiqlQueryTO.setName(fiqlQuery.getName());
        fiqlQueryTO.setTarget(fiqlQuery.getTarget());
        fiqlQueryTO.setFiql(fiqlQuery.getFIQL());
        return fiqlQueryTO;
    }
}

