/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job;

import jakarta.annotation.Resource;
import jakarta.validation.ValidationException;
import jakarta.validation.Validator;
import java.io.Serializable;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.command.CommandArgs;
import org.apache.syncope.common.lib.form.FormProperty;
import org.apache.syncope.common.lib.form.SyncopeForm;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.task.FormPropertyDef;
import org.apache.syncope.core.persistence.api.entity.task.MacroTask;
import org.apache.syncope.core.persistence.api.entity.task.MacroTaskCommand;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.persistence.api.utils.FormatUtils;
import org.apache.syncope.core.provisioning.api.jexl.JexlUtils;
import org.apache.syncope.core.provisioning.api.job.JobExecutionContext;
import org.apache.syncope.core.provisioning.api.job.JobExecutionException;
import org.apache.syncope.core.provisioning.api.macro.Command;
import org.apache.syncope.core.provisioning.api.macro.MacroActions;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;
import org.apache.syncope.core.provisioning.java.job.AbstractSchedTaskJobDelegate;
import org.apache.syncope.core.spring.implementation.ImplementationManager;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.security.concurrent.DelegatingSecurityContextCallable;
import org.springframework.util.ReflectionUtils;

public class MacroJobDelegate
extends AbstractSchedTaskJobDelegate<MacroTask> {
    public static final String MACRO_TASK_FORM_JOBDETAIL_KEY = "macroTaskForm";
    @Autowired
    protected ImplementationDAO implementationDAO;
    @Autowired
    protected Validator validator;
    @Resource(name="batchExecutor")
    protected AsyncTaskExecutor taskExecutor;
    protected final Map<String, MacroActions> perContextActions = new ConcurrentHashMap<String, MacroActions>();
    protected final Map<String, Command<?>> perContextCommands = new ConcurrentHashMap();

    protected Optional<JexlContext> check(SyncopeForm macroTaskForm, Optional<MacroActions> actions, StringBuilder output) throws JobExecutionException {
        if (macroTaskForm == null) {
            return Optional.empty();
        }
        Set missingFormProperties = ((MacroTask)this.task).getFormPropertyDefs().stream().filter(FormPropertyDef::isRequired).map(fpd -> Pair.of((Object)fpd.getName(), macroTaskForm.getProperty(fpd.getName()).map(p -> p.getValue() != null))).filter(pair -> ((Optional)pair.getRight()).isEmpty()).map(Pair::getLeft).collect(Collectors.toSet());
        if (!missingFormProperties.isEmpty()) {
            throw new JobExecutionException("Required form properties missing: " + String.valueOf(missingFormProperties));
        }
        HashMap<String, Object> vars = new HashMap<String, Object>();
        for (FormPropertyDef fpd2 : ((MacroTask)this.task).getFormPropertyDefs()) {
            String value = macroTaskForm.getProperty(fpd2.getName()).map(FormProperty::getValue).orElse(null);
            if (value == null) continue;
            switch (fpd2.getType()) {
                case String: {
                    if (Optional.ofNullable(fpd2.getStringRegEx()).map(pattern -> !pattern.matcher(value).matches()).orElse(false).booleanValue()) {
                        throw new JobExecutionException("RegEx not matching for " + fpd2.getName() + ": " + value);
                    }
                    vars.put(fpd2.getName(), value);
                    break;
                }
                case Password: {
                    vars.put(fpd2.getName(), value);
                    break;
                }
                case Boolean: {
                    vars.put(fpd2.getName(), BooleanUtils.toBoolean((String)value));
                    break;
                }
                case Date: {
                    try {
                        vars.put(fpd2.getName(), StringUtils.isBlank((CharSequence)fpd2.getDatePattern()) ? FormatUtils.parseDate((String)value) : FormatUtils.parseDate((String)value, (String)fpd2.getDatePattern()));
                        break;
                    }
                    catch (DateTimeParseException e) {
                        throw new JobExecutionException("Unparseable date " + fpd2.getName() + ": " + value, (Throwable)e);
                    }
                }
                case Long: {
                    vars.put(fpd2.getName(), NumberUtils.toLong((String)value));
                    break;
                }
                case Enum: {
                    if (!fpd2.getEnumValues().containsKey(value)) {
                        throw new JobExecutionException("Not allowed for " + fpd2.getName() + ": " + value);
                    }
                    vars.put(fpd2.getName(), value);
                    break;
                }
                case Dropdown: {
                    if (!fpd2.isDropdownFreeForm()) {
                        List<String> values;
                        List<String> list = values = fpd2.isDropdownSingleSelection() ? List.of(value) : List.of(value.split(";"));
                        if (!actions.map(a -> a.getDropdownValues(fpd2.getName()).keySet()).orElseGet(Set::of).containsAll(values)) {
                            throw new JobExecutionException("Not allowed for " + fpd2.getName() + ": " + String.valueOf(values));
                        }
                    }
                    vars.put(fpd2.getName(), value);
                    break;
                }
                case Binary: {
                    vars.put(fpd2.getName(), Base64.getDecoder().decode(value));
                    break;
                }
            }
        }
        try {
            actions.ifPresent(a -> a.validate(macroTaskForm, vars));
        }
        catch (ValidationException e) {
            throw new JobExecutionException("Invalid form submitted for task " + ((MacroTask)this.task).getKey(), (Throwable)e);
        }
        output.append("Form parameter values: ").append(vars).append("\n\n");
        return vars.isEmpty() ? Optional.empty() : Optional.of(new MapContext(vars));
    }

    protected void run(List<Pair<Command<CommandArgs>, CommandArgs>> commands, Optional<MacroActions> actions, Map<String, Serializable> ctx, StringBuilder output, boolean dryRun) throws JobExecutionException {
        Future future = this.taskExecutor.submit((Callable)new DelegatingSecurityContextCallable(() -> {
            MutableObject error = new MutableObject();
            for (int i = 0; i < commands.size() && error.get() == null; ++i) {
                Pair command = (Pair)commands.get(i);
                try {
                    String args = POJOHelper.serialize((Object)command.getRight());
                    output.append("Command[").append(((Command)command.getLeft()).getClass().getName()).append("]: ").append(args).append("\n");
                    if (!dryRun) {
                        ((CommandArgs)command.getRight()).setCtx(ctx);
                        actions.ifPresent(a -> a.beforeCommand((Command)command.getLeft(), (CommandArgs)command.getRight()));
                        Command.Result cmdResult = ((Command)command.getLeft()).run((CommandArgs)command.getRight());
                        ctx.putAll(cmdResult.values());
                        actions.ifPresent(a -> a.afterCommand((Command)command.getLeft(), (CommandArgs)command.getRight(), cmdResult));
                        output.append(cmdResult.message());
                    }
                }
                catch (Throwable t) {
                    if (((MacroTask)this.task).isContinueOnError()) {
                        output.append("Continuing on error: <").append(t.getMessage()).append('>');
                        LOG.error("While running {} with args {}, continuing on error", new Object[]{((Command)command.getLeft()).getClass().getName(), command.getRight(), t});
                    }
                    error.setValue((Object)Pair.of((Object)AopUtils.getTargetClass((Object)command.getLeft()).getName(), (Object)t));
                }
                output.append("\n\n");
            }
            return error;
        }));
        try {
            Mutable error = (Mutable)future.get();
            if (error.get() != null) {
                throw new JobExecutionException("While running " + (String)((Pair)error.get()).getLeft(), (Throwable)((Pair)error.get()).getRight());
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JobExecutionException("While waiting for macro commands completion", (Throwable)e);
        }
        output.append("COMPLETED");
    }

    @Override
    protected String doExecute(JobExecutionContext context) throws JobExecutionException {
        Optional<MacroActions> actions;
        if (((MacroTask)this.task).getMacroActions() == null) {
            actions = Optional.empty();
        } else {
            try {
                actions = Optional.of((MacroActions)ImplementationManager.build((Implementation)((MacroTask)this.task).getMacroActions(), () -> this.perContextActions.get(((MacroTask)this.task).getMacroActions().getKey()), instance -> this.perContextActions.put(((MacroTask)this.task).getMacroActions().getKey(), (MacroActions)instance)));
            }
            catch (Exception e) {
                throw new JobExecutionException("Could not build " + ((MacroTask)this.task).getMacroActions().getKey(), (Throwable)e);
            }
        }
        StringBuilder output = new StringBuilder();
        SyncopeForm macroTaskForm = (SyncopeForm)context.getData().get(MACRO_TASK_FORM_JOBDETAIL_KEY);
        Optional<JexlContext> jexlContext = this.check(macroTaskForm, actions, output);
        HashMap<String, Serializable> ctx = new HashMap<String, Serializable>();
        actions.filter(a -> !context.isDryRun()).ifPresent(a -> a.beforeAll(ctx));
        ArrayList<Pair<Command<CommandArgs>, CommandArgs>> commands = new ArrayList<Pair<Command<CommandArgs>, CommandArgs>>();
        for (MacroTaskCommand command : ((MacroTask)this.task).getCommands()) {
            CommandArgs args;
            Command runnable;
            try {
                runnable = (Command)ImplementationManager.build((Implementation)command.getCommand(), () -> this.perContextCommands.get(command.getCommand().getKey()), instance -> this.perContextCommands.put(command.getCommand().getKey(), (Command<?>)instance));
            }
            catch (Exception e) {
                throw new JobExecutionException("Could not build " + command.getCommand().getKey(), (Throwable)e);
            }
            if (command.getArgs() == null) {
                try {
                    args = ImplementationManager.emptyArgs((Implementation)command.getCommand());
                }
                catch (Exception e) {
                    throw new JobExecutionException("While getting empty args from " + command.getKey(), (Throwable)e);
                }
            } else {
                args = command.getArgs();
                jexlContext.ifPresent(jc -> ReflectionUtils.doWithFields(args.getClass(), field -> {
                    if (String.class.equals(field.getType())) {
                        field.setAccessible(true);
                        Object value = field.get(args);
                        if (value instanceof String) {
                            String s = (String)value;
                            field.set(args, JexlUtils.evaluateTemplate((String)s, (JexlContext)jc));
                        }
                    }
                }, field -> !field.isSynthetic()));
                Set violations = this.validator.validate((Object)args, new Class[0]);
                if (!violations.isEmpty()) {
                    LOG.error("While validating {}: {}", (Object)args, (Object)violations);
                    throw new JobExecutionException("While running " + command.getKey(), (Throwable)new IllegalArgumentException(violations.stream().map(v -> String.valueOf(v.getPropertyPath()) + ": " + v.getMessage()).collect(Collectors.joining(","))));
                }
            }
            commands.add((Pair<Command<CommandArgs>, CommandArgs>)Pair.of((Object)runnable, (Object)args));
        }
        this.run(commands, actions, ctx, output, context.isDryRun());
        return actions.filter(a -> !context.isDryRun()).map(a -> a.afterAll(ctx, output)).orElse(output).toString();
    }

    @Override
    protected boolean hasToBeRegistered(TaskExec<?> execution) {
        return ((MacroTask)this.task).isSaveExecs();
    }
}

