/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.apache.syncope.common.lib.request.AnyUR;
import org.apache.syncope.common.lib.request.MembershipUR;
import org.apache.syncope.common.lib.request.UserUR;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.to.ProvisioningReport;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.UserProvisioningManager;
import org.apache.syncope.core.provisioning.api.job.JobExecutionException;
import org.apache.syncope.core.provisioning.api.pushpull.InboundActions;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningProfile;
import org.apache.syncope.core.provisioning.java.pushpull.InboundMatcher;
import org.apache.syncope.core.spring.implementation.InstanceScope;
import org.apache.syncope.core.spring.implementation.SyncopeImplementation;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.LiveSyncDelta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@SyncopeImplementation(scope=InstanceScope.PER_CONTEXT)
public class LDAPMembershipPullActions
implements InboundActions {
    protected static final Logger LOG = LoggerFactory.getLogger(LDAPMembershipPullActions.class);
    @Autowired
    protected AnyTypeDAO anyTypeDAO;
    @Autowired
    protected GroupDAO groupDAO;
    @Autowired
    protected InboundMatcher inboundMatcher;
    @Autowired
    protected UserProvisioningManager userProvisioningManager;
    protected final Map<String, Set<String>> membershipsBefore = new ConcurrentHashMap<String, Set<String>>();
    protected final Map<String, Set<String>> membershipsAfter = new ConcurrentHashMap<String, Set<String>>();

    protected String getGroupMembershipAttrName(Connector connector) {
        return connector.getConnInstance().getConf().stream().filter(property -> "groupMemberAttribute".equals(property.getSchema().getName()) && !property.getValues().isEmpty()).findFirst().map(groupMembership -> (String)groupMembership.getValues().getFirst()).orElse("uniqueMember");
    }

    public Set<String> moreAttrsToGet(ProvisioningProfile<?, ?> profile, Provision provision) {
        if (!AnyTypeKind.GROUP.name().equals(provision.getAnyType())) {
            return super.moreAttrsToGet(profile, provision);
        }
        return Set.of(this.getGroupMembershipAttrName(profile.getConnector()));
    }

    @Transactional(readOnly=true)
    public void beforeUpdate(ProvisioningProfile<?, ?> profile, LiveSyncDelta delta, EntityTO entity, AnyUR anyUR) throws JobExecutionException {
        if (!(entity instanceof GroupTO)) {
            super.beforeUpdate(profile, delta, entity, anyUR);
            return;
        }
        this.groupDAO.findUMemberships((Group)this.groupDAO.findById(entity.getKey()).orElseThrow(() -> new NotFoundException("Group " + entity.getKey())), Pageable.unpaged()).forEach(uMembership -> {
            Set memb = this.membershipsBefore.computeIfAbsent(((User)uMembership.getLeftEnd()).getKey(), k -> Collections.synchronizedSet(new HashSet()));
            memb.add(entity.getKey());
        });
    }

    protected List<Object> getMembAttrValues(LiveSyncDelta delta, Connector connector) {
        return Optional.ofNullable(delta.getObject().getAttributeByName(this.getGroupMembershipAttrName(connector))).map(Attribute::getValue).filter(Objects::nonNull).orElseGet(() -> List.of());
    }

    public void after(ProvisioningProfile<?, ?> profile, LiveSyncDelta delta, EntityTO entity, ProvisioningReport result) throws JobExecutionException {
        if (!(entity instanceof GroupTO)) {
            super.after(profile, delta, entity, result);
            return;
        }
        Optional<Provision> provision = profile.getTask().getResource().getProvisionByAnyType(AnyTypeKind.USER.name()).filter(p -> p.getMapping() != null);
        if (provision.isEmpty()) {
            super.after(profile, delta, entity, result);
            return;
        }
        this.getMembAttrValues(delta, profile.getConnector()).forEach(membValue -> this.inboundMatcher.match(this.anyTypeDAO.getUser(), membValue.toString(), profile.getTask().getResource(), profile.getConnector()).ifPresentOrElse(match -> {
            Set memb = this.membershipsAfter.computeIfAbsent(match.getAny().getKey(), k -> Collections.synchronizedSet(new HashSet()));
            memb.add(entity.getKey());
        }, () -> LOG.warn("Could not find matching user for {}", membValue)));
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void afterAll(ProvisioningProfile<?, ?> profile) {
        ArrayList updateReqs = new ArrayList();
        this.membershipsAfter.forEach((user, groups) -> {
            UserUR userUR = new UserUR();
            userUR.setKey(user);
            updateReqs.add(userUR);
            Set before = this.membershipsBefore.getOrDefault(user, Set.of());
            groups.stream().filter(group -> !before.contains(group)).forEach(group -> userUR.getMemberships().add((MembershipUR)((MembershipUR.Builder)new MembershipUR.Builder(group).operation(PatchOperation.ADD_REPLACE)).build()));
        });
        this.membershipsBefore.forEach((user, groups) -> {
            UserUR userUR = updateReqs.stream().filter(req -> user.equals(req.getKey())).findFirst().orElseGet(() -> {
                UserUR req = (UserUR)new UserUR.Builder(user).build();
                updateReqs.add(req);
                return req;
            });
            Set after = this.membershipsAfter.getOrDefault(user, Set.of());
            groups.stream().filter(group -> !after.contains(group)).forEach(group -> userUR.getMemberships().add((MembershipUR)((MembershipUR.Builder)new MembershipUR.Builder(group).operation(PatchOperation.DELETE)).build()));
        });
        this.membershipsAfter.clear();
        this.membershipsBefore.clear();
        String context = "PullTask " + profile.getTask().getKey() + " '" + profile.getTask().getName() + "'";
        updateReqs.stream().filter(Predicate.not(UserUR::isEmpty)).forEach(req -> {
            LOG.debug("About to update memberships for User {}", (Object)req.getKey());
            this.userProvisioningManager.update(req, true, profile.getExecutor(), context);
        });
    }
}

