/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.starter.pac4j.saml;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.syncope.common.rest.api.service.wa.WASAML2SPService;
import org.apache.syncope.wa.bootstrap.WARestClient;
import org.apache.syncope.wa.starter.pac4j.saml.WASAML2MetadataResolver;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.AbstractMetadataResolver;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.xmlsec.signature.SignableXMLObject;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.metadata.BaseSAML2MetadataGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WASAML2ClientMetadataGenerator
extends BaseSAML2MetadataGenerator {
    protected static final Logger LOG = LoggerFactory.getLogger(WASAML2ClientMetadataGenerator.class);
    protected final WARestClient waRestClient;
    protected final SAML2Client saml2Client;

    public WASAML2ClientMetadataGenerator(WARestClient waRestClient, SAML2Client saml2Client) {
        this.waRestClient = waRestClient;
        this.saml2Client = saml2Client;
    }

    public boolean storeMetadata(String metadata, boolean force) {
        return true;
    }

    protected Optional<String> metadataAvailable() {
        try {
            String encodedMetadata = (String)((WASAML2SPService)this.waRestClient.getService(WASAML2SPService.class)).getSAML2SPMetadata(this.saml2Client.getName()).readEntity(String.class);
            LOG.debug("Retrieved metadata {}", (Object)encodedMetadata);
            return Optional.of(new String(Base64.getDecoder().decode(encodedMetadata), StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            LOG.error("While attempting to read metadata for SP Entity {}", (Object)this.saml2Client.getName(), (Object)e);
            return Optional.empty();
        }
    }

    public EntityDescriptor buildEntityDescriptor() {
        return this.metadataAvailable().map(m -> null).orElseGet(() -> {
            EntityDescriptor entityDescriptor = super.buildEntityDescriptor();
            entityDescriptor.setValidUntil(null);
            if (this.signMetadata) {
                this.signMetadata((SignableXMLObject)entityDescriptor);
            }
            return entityDescriptor;
        });
    }

    public String getMetadata(EntityDescriptor entityDescriptor) throws Exception {
        String metadata = this.metadataAvailable().orElse(null);
        if (metadata == null) {
            return super.getMetadata(entityDescriptor);
        }
        return metadata;
    }

    protected AbstractMetadataResolver createMetadataResolver() {
        return new WASAML2MetadataResolver(this.waRestClient, this.saml2Client);
    }

    public MetadataResolver buildMetadataResolver() throws Exception {
        EntityDescriptor entityDescriptor = this.buildEntityDescriptor();
        if (entityDescriptor != null) {
            String encodedMetadata = Base64.getEncoder().encodeToString(this.getMetadata(entityDescriptor).getBytes(StandardCharsets.UTF_8));
            LOG.debug("Encoded SP metadata {}", (Object)encodedMetadata);
            try {
                ((WASAML2SPService)this.waRestClient.getService(WASAML2SPService.class)).setSAML2SPMetadata(this.saml2Client.getName(), IOUtils.toInputStream((String)encodedMetadata, (Charset)StandardCharsets.UTF_8));
            }
            catch (Exception e) {
                LOG.error("While storing SP {} metadata", (Object)this.saml2Client.getName(), (Object)e);
            }
        }
        return super.buildMetadataResolver();
    }
}

