/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.flowable.bpmn.model.MapExceptionEntry;
import org.flowable.common.engine.api.FlowableIllegalStateException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.util.ExceptionUtil;
import org.flowable.engine.delegate.BpmnError;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.FutureJavaDelegate;
import org.flowable.engine.impl.bpmn.behavior.TaskActivityBehavior;
import org.flowable.engine.impl.bpmn.helper.ErrorPropagation;
import org.flowable.engine.impl.bpmn.helper.SkipExpressionUtil;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.delegate.ActivityBehavior;
import org.flowable.engine.impl.delegate.TriggerableActivityBehavior;
import org.flowable.engine.impl.delegate.TriggerableJavaDelegate;
import org.flowable.engine.impl.delegate.TriggerableJavaDelegateContextImpl;
import org.flowable.engine.impl.delegate.invocation.FutureJavaDelegateInvocation;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.BpmnLoggingSessionUtil;
import org.flowable.engine.impl.util.CommandContextUtil;

public class ServiceTaskFutureJavaDelegateActivityBehavior
extends TaskActivityBehavior
implements ActivityBehavior,
TriggerableJavaDelegate {
    private static final long serialVersionUID = 1L;
    protected FutureJavaDelegate<?> futureJavaDelegate;
    protected Expression skipExpression;
    protected boolean triggerable;
    protected List<MapExceptionEntry> mapExceptions;

    protected ServiceTaskFutureJavaDelegateActivityBehavior() {
    }

    public ServiceTaskFutureJavaDelegateActivityBehavior(FutureJavaDelegate<?> futureJavaDelegate, boolean triggerable, Expression skipExpression, List<MapExceptionEntry> mapExceptions) {
        this.futureJavaDelegate = futureJavaDelegate;
        this.triggerable = triggerable;
        this.skipExpression = skipExpression;
        this.mapExceptions = mapExceptions;
    }

    @Override
    public void trigger(DelegateExecution execution, String signalName, Object signalData) {
        FutureJavaDelegate<?> futureJavaDelegate;
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        if (this.triggerable && this.futureJavaDelegate instanceof TriggerableActivityBehavior) {
            if (processEngineConfiguration.isLoggingSessionEnabled()) {
                BpmnLoggingSessionUtil.addLoggingData("serviceTaskBeforeTrigger", "Triggering service task with java class " + this.futureJavaDelegate.getClass().getName(), execution);
            }
            ((TriggerableActivityBehavior)((Object)this.futureJavaDelegate)).trigger(execution, signalName, signalData);
            if (processEngineConfiguration.isLoggingSessionEnabled()) {
                BpmnLoggingSessionUtil.addLoggingData("serviceTaskAfterTrigger", "Triggered service task with java class " + this.futureJavaDelegate.getClass().getName(), execution);
            }
        } else if (this.triggerable && (futureJavaDelegate = this.futureJavaDelegate) instanceof TriggerableJavaDelegate) {
            TriggerableJavaDelegate triggerableJavaDelegate = (TriggerableJavaDelegate)((Object)futureJavaDelegate);
            if (processEngineConfiguration.isLoggingSessionEnabled()) {
                BpmnLoggingSessionUtil.addLoggingData("serviceTaskBeforeTrigger", "Triggering service task with java class " + this.futureJavaDelegate.getClass().getName(), execution);
            }
            TriggerableJavaDelegateContextImpl context = new TriggerableJavaDelegateContextImpl(execution, null, null);
            triggerableJavaDelegate.trigger(context);
            if (processEngineConfiguration.isLoggingSessionEnabled()) {
                BpmnLoggingSessionUtil.addLoggingData("serviceTaskAfterTrigger", "Triggered service task with java class " + this.futureJavaDelegate.getClass().getName(), execution);
            }
        } else if (processEngineConfiguration.isLoggingSessionEnabled()) {
            if (!this.triggerable) {
                BpmnLoggingSessionUtil.addLoggingData("serviceTaskWrongTrigger", "Service task with java class triggered but not triggerable " + this.futureJavaDelegate.getClass().getName(), execution);
            } else {
                BpmnLoggingSessionUtil.addLoggingData("serviceTaskWrongTrigger", "Service task with java class triggered but not implementing TriggerableActivityBehavior " + this.futureJavaDelegate.getClass().getName(), execution);
            }
        }
    }

    @Override
    public void execute(DelegateExecution execution) {
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        String skipExpressionText = null;
        if (this.skipExpression != null) {
            skipExpressionText = this.skipExpression.getExpressionText();
        }
        boolean isSkipExpressionEnabled = SkipExpressionUtil.isSkipExpressionEnabled(skipExpressionText, execution.getCurrentActivityId(), execution, commandContext);
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        boolean loggingSessionEnabled = processEngineConfiguration.isLoggingSessionEnabled();
        if (!isSkipExpressionEnabled || !SkipExpressionUtil.shouldSkipFlowElement(skipExpressionText, execution.getCurrentActivityId(), execution, commandContext)) {
            try {
                if (loggingSessionEnabled) {
                    BpmnLoggingSessionUtil.addLoggingData("serviceTaskEnter", "Executing service task with java class " + this.futureJavaDelegate.getClass().getName(), execution);
                }
                FutureJavaDelegate<Object> futureJavaDelegate = this.futureJavaDelegate;
                FutureJavaDelegateInvocation invocation = new FutureJavaDelegateInvocation(futureJavaDelegate, execution, processEngineConfiguration.getAsyncTaskInvoker());
                processEngineConfiguration.getDelegateInterceptor().handleInvocation(invocation);
                Object invocationResult = invocation.getInvocationResult();
                if (!(invocationResult instanceof CompletableFuture)) {
                    throw new FlowableIllegalStateException("Invocation result " + invocationResult + " from invocation " + invocation + " was not a CompletableFuture");
                }
                CompletableFuture future = (CompletableFuture)invocationResult;
                CommandContextUtil.getAgenda(commandContext).planFutureOperation(future, new FutureJavaDelegateCompleteAction(futureJavaDelegate, execution, loggingSessionEnabled));
            }
            catch (RuntimeException e) {
                if (loggingSessionEnabled) {
                    BpmnLoggingSessionUtil.addErrorLoggingData("serviceTaskException", "Service task with java class " + this.futureJavaDelegate.getClass().getName() + " threw exception " + e.getMessage(), e, execution);
                }
                throw e;
            }
        } else {
            if (loggingSessionEnabled) {
                BpmnLoggingSessionUtil.addLoggingData("skipTask", "Skipped service task " + execution.getCurrentActivityId() + " with skip expression " + skipExpressionText, execution);
            }
            if (!this.triggerable) {
                this.leave(execution);
            }
        }
    }

    @Override
    public void trigger(TriggerableJavaDelegate.Context context) {
        FutureJavaDelegate<?> futureJavaDelegate;
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        if (this.triggerable && (futureJavaDelegate = this.futureJavaDelegate) instanceof TriggerableJavaDelegate) {
            TriggerableJavaDelegate triggerableJavaDelegate = (TriggerableJavaDelegate)((Object)futureJavaDelegate);
            if (processEngineConfiguration.isLoggingSessionEnabled()) {
                BpmnLoggingSessionUtil.addLoggingData("serviceTaskBeforeTrigger", "Triggering service task with java class " + this.futureJavaDelegate.getClass().getName(), context.getExecution());
            }
            triggerableJavaDelegate.trigger(context);
            if (processEngineConfiguration.isLoggingSessionEnabled()) {
                BpmnLoggingSessionUtil.addLoggingData("serviceTaskAfterTrigger", "Triggered service task with java class " + this.futureJavaDelegate.getClass().getName(), context.getExecution());
            }
        } else if (this.triggerable && this.futureJavaDelegate instanceof TriggerableActivityBehavior) {
            if (processEngineConfiguration.isLoggingSessionEnabled()) {
                BpmnLoggingSessionUtil.addLoggingData("serviceTaskBeforeTrigger", "Triggering service task with java class " + this.futureJavaDelegate.getClass().getName(), context.getExecution());
            }
            ((TriggerableActivityBehavior)((Object)this.futureJavaDelegate)).trigger(context.getExecution(), context.getSignalName(), context.getSignalData());
            if (processEngineConfiguration.isLoggingSessionEnabled()) {
                BpmnLoggingSessionUtil.addLoggingData("serviceTaskAfterTrigger", "Triggered service task with java class " + this.futureJavaDelegate.getClass().getName(), context.getExecution());
            }
        } else if (processEngineConfiguration.isLoggingSessionEnabled()) {
            if (!this.triggerable) {
                BpmnLoggingSessionUtil.addLoggingData("serviceTaskWrongTrigger", "Service task with java class triggered but not triggerable " + this.futureJavaDelegate.getClass().getName(), context.getExecution());
            } else {
                BpmnLoggingSessionUtil.addLoggingData("serviceTaskWrongTrigger", "Service task with java class triggered but not implementing TriggerableActivityBehavior " + this.futureJavaDelegate.getClass().getName(), context.getExecution());
            }
        }
    }

    protected void handleException(Throwable throwable, DelegateExecution execution, boolean loggingSessionEnabled) {
        if (loggingSessionEnabled) {
            BpmnLoggingSessionUtil.addErrorLoggingData("serviceTaskException", "Service task with java class " + this.futureJavaDelegate.getClass().getName() + " threw exception " + throwable.getMessage(), throwable, execution);
        }
        if (throwable instanceof BpmnError) {
            ErrorPropagation.propagateError((BpmnError)((Object)throwable), execution);
        } else if (throwable instanceof Exception) {
            if (!ErrorPropagation.mapException((Exception)throwable, (ExecutionEntity)execution, this.mapExceptions)) {
                ExceptionUtil.sneakyThrow((Throwable)throwable);
            }
        } else {
            ExceptionUtil.sneakyThrow((Throwable)throwable);
        }
    }

    protected class FutureJavaDelegateCompleteAction
    implements BiConsumer<Object, Throwable> {
        protected final FutureJavaDelegate<Object> delegateInstance;
        protected final DelegateExecution execution;
        protected final boolean loggingSessionEnabled;

        public FutureJavaDelegateCompleteAction(FutureJavaDelegate<Object> delegateInstance, DelegateExecution execution, boolean loggingSessionEnabled) {
            this.delegateInstance = delegateInstance;
            this.execution = execution;
            this.loggingSessionEnabled = loggingSessionEnabled;
        }

        @Override
        public void accept(Object value, Throwable throwable) {
            if (throwable == null) {
                try {
                    this.delegateInstance.afterExecution(this.execution, value);
                    if (this.loggingSessionEnabled) {
                        BpmnLoggingSessionUtil.addLoggingData("serviceTaskExit", "Executed service task with java class " + ServiceTaskFutureJavaDelegateActivityBehavior.this.futureJavaDelegate.getClass().getName(), this.execution);
                    }
                    if (!ServiceTaskFutureJavaDelegateActivityBehavior.this.triggerable) {
                        ServiceTaskFutureJavaDelegateActivityBehavior.this.leave(this.execution);
                    }
                }
                catch (Exception ex) {
                    ServiceTaskFutureJavaDelegateActivityBehavior.this.handleException(ex, this.execution, this.loggingSessionEnabled);
                }
            } else {
                ServiceTaskFutureJavaDelegateActivityBehavior.this.handleException(throwable, this.execution, this.loggingSessionEnabled);
            }
        }
    }
}

