/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.test;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.EndEvent;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.UserTask;
import org.flowable.common.engine.impl.history.HistoryLevel;
import org.flowable.common.engine.impl.test.EnsureCleanDb;
import org.flowable.engine.DynamicBpmnService;
import org.flowable.engine.FormService;
import org.flowable.engine.HistoryService;
import org.flowable.engine.IdentityService;
import org.flowable.engine.ManagementService;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.ProcessEngineConfiguration;
import org.flowable.engine.ProcessMigrationService;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.history.HistoricActivityInstance;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.impl.ProcessEngineImpl;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.history.DefaultHistoryManager;
import org.flowable.engine.impl.history.HistoryManager;
import org.flowable.engine.impl.test.AbstractTestCase;
import org.flowable.engine.impl.test.HistoryTestHelper;
import org.flowable.engine.impl.test.JobTestHelper;
import org.flowable.engine.repository.Deployment;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.ActivityInstance;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.job.api.Job;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.api.history.HistoricTaskInstanceQuery;
import org.junit.Assert;
import org.junit.jupiter.api.BeforeEach;

@EnsureCleanDb(excludeTables={"ACT_GE_PROPERTY", "ACT_ID_PROPERTY", "FLW_EV_DATABASECHANGELOGLOCK", "FLW_EV_DATABASECHANGELOG"})
public abstract class AbstractFlowableTestCase
extends AbstractTestCase {
    protected ProcessEngine processEngine;
    protected static List<String> deploymentIdsForAutoCleanup = new ArrayList<String>();
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected RepositoryService repositoryService;
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected FormService formService;
    protected HistoryService historyService;
    protected IdentityService identityService;
    protected ManagementService managementService;
    protected DynamicBpmnService dynamicBpmnService;
    protected ProcessMigrationService processMigrationService;

    @BeforeEach
    public final void initializeServices(ProcessEngine processEngine) {
        this.processEngineConfiguration = ((ProcessEngineImpl)processEngine).getProcessEngineConfiguration();
        this.processEngine = processEngine;
        this.repositoryService = processEngine.getRepositoryService();
        this.runtimeService = processEngine.getRuntimeService();
        this.taskService = processEngine.getTaskService();
        this.formService = processEngine.getFormService();
        this.historyService = processEngine.getHistoryService();
        this.identityService = processEngine.getIdentityService();
        this.managementService = processEngine.getManagementService();
        this.dynamicBpmnService = processEngine.getDynamicBpmnService();
        this.processMigrationService = processEngine.getProcessMigrationService();
    }

    protected static void cleanDeployments(ProcessEngine processEngine) {
        ProcessEngineConfiguration processEngineConfiguration = processEngine.getProcessEngineConfiguration();
        for (String autoDeletedDeploymentId : deploymentIdsForAutoCleanup) {
            processEngineConfiguration.getRepositoryService().deleteDeployment(autoDeletedDeploymentId, true);
        }
        deploymentIdsForAutoCleanup.clear();
    }

    protected static void validateHistoryData(ProcessEngine processEngine) {
        ProcessEngineConfiguration processEngineConfiguration = processEngine.getProcessEngineConfiguration();
        HistoryService historyService = processEngine.getHistoryService();
        if (processEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.AUDIT)) {
            List historicProcessInstances = historyService.createHistoricProcessInstanceQuery().finished().list();
            for (HistoricProcessInstance historicProcessInstance : historicProcessInstances) {
                List historicActivityInstances;
                Assert.assertNotNull((String)"Historic process instance has no process definition id", (Object)historicProcessInstance.getProcessDefinitionId());
                Assert.assertNotNull((String)"Historic process instance has no process definition key", (Object)historicProcessInstance.getProcessDefinitionKey());
                Assert.assertNotNull((String)"Historic process instance has no process definition version", (Object)historicProcessInstance.getProcessDefinitionVersion());
                Assert.assertNotNull((String)"Historic process instance has no deployment id", (Object)historicProcessInstance.getDeploymentId());
                Assert.assertNotNull((String)"Historic process instance has no start activity id", (Object)historicProcessInstance.getStartActivityId());
                Assert.assertNotNull((String)"Historic process instance has no start time", (Object)historicProcessInstance.getStartTime());
                Assert.assertNotNull((String)"Historic process instance has no end time", (Object)historicProcessInstance.getEndTime());
                String processInstanceId = historicProcessInstance.getId();
                List historicTaskInstances = ((HistoricTaskInstanceQuery)historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).list();
                if (historicTaskInstances != null && historicTaskInstances.size() > 0) {
                    for (HistoricTaskInstance historicTaskInstance : historicTaskInstances) {
                        Assert.assertEquals((Object)processInstanceId, (Object)historicTaskInstance.getProcessInstanceId());
                        if (historicTaskInstance.getClaimTime() != null) {
                            Assert.assertNotNull((String)("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no work time"), (Object)historicTaskInstance.getWorkTimeInMillis());
                        }
                        Assert.assertNotNull((String)("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no id"), (Object)historicTaskInstance.getId());
                        Assert.assertNotNull((String)("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no process instance id"), (Object)historicTaskInstance.getProcessInstanceId());
                        Assert.assertNotNull((String)("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no execution id"), (Object)historicTaskInstance.getExecutionId());
                        Assert.assertNotNull((String)("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no process definition id"), (Object)historicTaskInstance.getProcessDefinitionId());
                        Assert.assertNotNull((String)("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no task definition key"), (Object)historicTaskInstance.getTaskDefinitionKey());
                        Assert.assertNotNull((String)("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no create time"), (Object)historicTaskInstance.getCreateTime());
                        Assert.assertNotNull((String)("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no start time"), (Object)historicTaskInstance.getStartTime());
                        Assert.assertNotNull((String)("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no end time"), (Object)historicTaskInstance.getEndTime());
                    }
                }
                if ((historicActivityInstances = historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).list()) == null || historicActivityInstances.size() <= 0) continue;
                for (HistoricActivityInstance historicActivityInstance : historicActivityInstances) {
                    Assert.assertEquals((Object)processInstanceId, (Object)historicActivityInstance.getProcessInstanceId());
                    Assert.assertNotNull((String)("Historic activity instance " + historicActivityInstance.getId() + " / " + historicActivityInstance.getActivityId() + " has no activity id"), (Object)historicActivityInstance.getActivityId());
                    Assert.assertNotNull((String)("Historic activity instance " + historicActivityInstance.getId() + " / " + historicActivityInstance.getActivityId() + " has no activity type"), (Object)historicActivityInstance.getActivityType());
                    Assert.assertNotNull((String)("Historic activity instance " + historicActivityInstance.getId() + " / " + historicActivityInstance.getActivityId() + " has no process definition id"), (Object)historicActivityInstance.getProcessDefinitionId());
                    Assert.assertNotNull((String)("Historic activity instance " + historicActivityInstance.getId() + " / " + historicActivityInstance.getActivityId() + " has no process instance id"), (Object)historicActivityInstance.getProcessInstanceId());
                    Assert.assertNotNull((String)("Historic activity instance " + historicActivityInstance.getId() + " / " + historicActivityInstance.getActivityId() + " has no execution id"), (Object)historicActivityInstance.getExecutionId());
                    Assert.assertNotNull((String)("Historic activity instance " + historicActivityInstance.getId() + " / " + historicActivityInstance.getActivityId() + " has no start time"), (Object)historicActivityInstance.getStartTime());
                    Assert.assertNotNull((String)("Historic activity instance " + historicActivityInstance.getId() + " / " + historicActivityInstance.getActivityId() + " has no end time"), (Object)historicActivityInstance.getEndTime());
                    if (historicProcessInstance.getEndTime() != null) continue;
                    AbstractFlowableTestCase.assertActivityInstancesAreSame(historicActivityInstance, (ActivityInstance)processEngine.getRuntimeService().createActivityInstanceQuery().activityInstanceId(historicActivityInstance.getId()).singleResult());
                }
            }
        }
    }

    public void assertProcessEnded(String processInstanceId) {
        this.assertProcessEnded(processInstanceId, 10000L);
    }

    public void assertProcessEnded(String processInstanceId, long timeout) {
        ProcessInstance processInstance = (ProcessInstance)this.processEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (processInstance != null) {
            throw new AssertionError((Object)("Expected finished process instance '" + processInstanceId + "' but it was still in the db"));
        }
        if (HistoryTestHelper.isHistoryLevelAtLeast(HistoryLevel.AUDIT, this.processEngineConfiguration, timeout)) {
            List historicActivityInstances;
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
            Assert.assertEquals((Object)processInstanceId, (Object)historicProcessInstance.getId());
            Assert.assertNotNull((String)"Historic process instance has no start time", (Object)historicProcessInstance.getStartTime());
            Assert.assertNotNull((String)"Historic process instance has no end time", (Object)historicProcessInstance.getEndTime());
            List historicTaskInstances = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).list();
            if (historicTaskInstances != null && historicTaskInstances.size() > 0) {
                for (HistoricTaskInstance historicTaskInstance : historicTaskInstances) {
                    Assert.assertEquals((Object)processInstanceId, (Object)historicTaskInstance.getProcessInstanceId());
                    Assert.assertNotNull((String)("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no start time"), (Object)historicTaskInstance.getStartTime());
                    Assert.assertNotNull((String)("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no end time"), (Object)historicTaskInstance.getEndTime());
                }
            }
            if ((historicActivityInstances = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).list()) != null && historicActivityInstances.size() > 0) {
                for (HistoricActivityInstance historicActivityInstance : historicActivityInstances) {
                    Assert.assertEquals((Object)processInstanceId, (Object)historicActivityInstance.getProcessInstanceId());
                    Assert.assertNotNull((String)(historicActivityInstance.getId() + " Historic activity instance '" + historicActivityInstance.getActivityId() + "' has no start time"), (Object)historicActivityInstance.getStartTime());
                    Assert.assertNotNull((String)(historicActivityInstance.getId() + " Historic activity instance '" + historicActivityInstance.getActivityId() + "' has no end time"), (Object)historicActivityInstance.getEndTime());
                }
            }
        }
        Assert.assertEquals((long)0L, (long)this.runtimeService.createActivityInstanceQuery().processInstanceId(processInstanceId).count());
    }

    public static void assertActivityInstancesAreSame(HistoricActivityInstance historicActInst, ActivityInstance activityInstance) {
        Assert.assertTrue((boolean)Objects.equals(historicActInst.getId(), activityInstance.getId()));
        Assert.assertTrue((boolean)Objects.equals(historicActInst.getActivityId(), activityInstance.getActivityId()));
        Assert.assertTrue((boolean)Objects.equals(historicActInst.getEndTime(), activityInstance.getEndTime()));
        Assert.assertTrue((boolean)Objects.equals(historicActInst.getProcessDefinitionId(), activityInstance.getProcessDefinitionId()));
        Assert.assertTrue((boolean)Objects.equals(historicActInst.getStartTime(), activityInstance.getStartTime()));
        Assert.assertTrue((boolean)Objects.equals(historicActInst.getExecutionId(), activityInstance.getExecutionId()));
        Assert.assertTrue((boolean)Objects.equals(historicActInst.getActivityType(), activityInstance.getActivityType()));
        Assert.assertTrue((boolean)Objects.equals(historicActInst.getProcessInstanceId(), activityInstance.getProcessInstanceId()));
        Assert.assertTrue((boolean)Objects.equals(historicActInst.getAssignee(), activityInstance.getAssignee()));
        Assert.assertTrue((boolean)Objects.equals(historicActInst.getTransactionOrder(), activityInstance.getTransactionOrder()));
        Assert.assertTrue((boolean)Objects.equals(historicActInst.getDurationInMillis(), activityInstance.getDurationInMillis()));
        Assert.assertTrue((boolean)Objects.equals(historicActInst.getTenantId(), activityInstance.getTenantId()));
        Assert.assertTrue((boolean)Objects.equals(historicActInst.getDeleteReason(), activityInstance.getDeleteReason()));
        Assert.assertTrue((boolean)Objects.equals(historicActInst.getActivityName(), activityInstance.getActivityName()));
        Assert.assertTrue((boolean)Objects.equals(historicActInst.getCalledProcessInstanceId(), activityInstance.getCalledProcessInstanceId()));
        Assert.assertTrue((boolean)Objects.equals(historicActInst.getTaskId(), activityInstance.getTaskId()));
        Assert.assertTrue((boolean)Objects.equals(historicActInst.getTime(), activityInstance.getTime()));
    }

    public void waitForJobExecutorToProcessAllJobs(long maxMillisToWait, long intervalMillis) {
        JobTestHelper.waitForJobExecutorToProcessAllJobs(this.processEngineConfiguration, this.managementService, maxMillisToWait, intervalMillis);
    }

    public void waitForJobExecutorOnCondition(long maxMillisToWait, long intervalMillis, Callable<Boolean> condition) {
        JobTestHelper.waitForJobExecutorOnCondition(this.processEngineConfiguration, maxMillisToWait, intervalMillis, condition);
    }

    public void executeJobExecutorForTime(long maxMillisToWait, long intervalMillis) {
        JobTestHelper.executeJobExecutorForTime(this.processEngineConfiguration, maxMillisToWait, intervalMillis);
    }

    public void waitForJobExecutorToProcessAllJobsAndExecutableTimerJobs(long maxMillisToWait, long intervalMillis) {
        JobTestHelper.waitForJobExecutorToProcessAllJobsAndExecutableTimerJobs(this.processEngineConfiguration, this.managementService, maxMillisToWait, intervalMillis);
    }

    public void waitForJobExecutorToProcessAllJobsAndAllTimerJobs(long maxMillisToWait, long intervalMillis) {
        JobTestHelper.waitForJobExecutorToProcessAllJobsAndExecutableTimerJobs(this.processEngineConfiguration, this.managementService, maxMillisToWait, intervalMillis);
    }

    public void waitForJobExecutorToProcessAllHistoryJobs(long maxMillisToWait, long intervalMillis) {
        HistoryTestHelper.waitForJobExecutorToProcessAllHistoryJobs(this.processEngineConfiguration, this.managementService, maxMillisToWait, intervalMillis);
    }

    public void waitForHistoryJobExecutorToProcessAllJobs(long maxMillisToWait, long intervalMillis) {
        HistoryTestHelper.waitForJobExecutorToProcessAllHistoryJobs(this.processEngineConfiguration, this.managementService, maxMillisToWait, intervalMillis);
    }

    public BpmnModel createOneTaskTestProcess() {
        BpmnModel model = new BpmnModel();
        Process process = this.createOneTaskProcess();
        model.addProcess(process);
        return model;
    }

    public BpmnModel createOneTaskTestProcessWithCandidateStarterGroup() {
        BpmnModel model = new BpmnModel();
        Process process = this.createOneTaskProcess();
        process.getCandidateStarterGroups().add("testGroup");
        model.addProcess(process);
        return model;
    }

    protected Process createOneTaskProcess() {
        Process process = new Process();
        process.setId("oneTaskProcess");
        process.setName("The one task process");
        StartEvent startEvent = new StartEvent();
        startEvent.setId("start");
        startEvent.setName("The start");
        process.addFlowElement((FlowElement)startEvent);
        UserTask userTask = new UserTask();
        userTask.setName("The Task");
        userTask.setId("theTask");
        userTask.setAssignee("kermit");
        process.addFlowElement((FlowElement)userTask);
        EndEvent endEvent = new EndEvent();
        endEvent.setId("theEnd");
        endEvent.setName("The end");
        process.addFlowElement((FlowElement)endEvent);
        process.addFlowElement((FlowElement)new SequenceFlow("start", "theTask"));
        process.addFlowElement((FlowElement)new SequenceFlow("theTask", "theEnd"));
        return process;
    }

    public BpmnModel createTwoTasksTestProcess() {
        BpmnModel model = new BpmnModel();
        Process process = new Process();
        model.addProcess(process);
        process.setId("twoTasksProcess");
        process.setName("The two tasks process");
        StartEvent startEvent = new StartEvent();
        startEvent.setId("start");
        process.addFlowElement((FlowElement)startEvent);
        UserTask userTask = new UserTask();
        userTask.setName("The First Task");
        userTask.setId("task1");
        userTask.setAssignee("kermit");
        process.addFlowElement((FlowElement)userTask);
        UserTask userTask2 = new UserTask();
        userTask2.setName("The Second Task");
        userTask2.setId("task2");
        userTask2.setAssignee("kermit");
        process.addFlowElement((FlowElement)userTask2);
        EndEvent endEvent = new EndEvent();
        endEvent.setId("theEnd");
        process.addFlowElement((FlowElement)endEvent);
        process.addFlowElement((FlowElement)new SequenceFlow("start", "task1"));
        process.addFlowElement((FlowElement)new SequenceFlow("start", "task2"));
        process.addFlowElement((FlowElement)new SequenceFlow("task1", "theEnd"));
        process.addFlowElement((FlowElement)new SequenceFlow("task2", "theEnd"));
        return model;
    }

    public String deployOneTaskTestProcess() {
        BpmnModel bpmnModel = this.createOneTaskTestProcess();
        Deployment deployment = this.repositoryService.createDeployment().addBpmnModel("oneTasktest.bpmn20.xml", bpmnModel).deploy();
        deploymentIdsForAutoCleanup.add(deployment.getId());
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
        return processDefinition.getId();
    }

    public String deployOneTaskTestProcessWithCandidateStarterGroup() {
        BpmnModel bpmnModel = this.createOneTaskTestProcessWithCandidateStarterGroup();
        Deployment deployment = this.repositoryService.createDeployment().addBpmnModel("oneTasktest.bpmn20.xml", bpmnModel).deploy();
        deploymentIdsForAutoCleanup.add(deployment.getId());
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
        return processDefinition.getId();
    }

    public String deployTwoTasksTestProcess() {
        BpmnModel bpmnModel = this.createTwoTasksTestProcess();
        Deployment deployment = this.repositoryService.createDeployment().addBpmnModel("twoTasksTestProcess.bpmn20.xml", bpmnModel).deploy();
        deploymentIdsForAutoCleanup.add(deployment.getId());
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
        return processDefinition.getId();
    }

    protected void deleteDeployments() {
        boolean isAsyncHistoryEnabled = this.processEngineConfiguration.isAsyncHistoryEnabled();
        HistoryManager asyncHistoryManager = null;
        if (isAsyncHistoryEnabled) {
            this.processEngineConfiguration.setAsyncHistoryEnabled(false);
            asyncHistoryManager = this.processEngineConfiguration.getHistoryManager();
            this.processEngineConfiguration.setHistoryManager(new DefaultHistoryManager(this.processEngineConfiguration));
        }
        for (Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
        if (isAsyncHistoryEnabled) {
            this.processEngineConfiguration.setAsyncHistoryEnabled(true);
            this.processEngineConfiguration.setHistoryManager(asyncHistoryManager);
        }
    }

    protected void deleteDeployment(String deploymentId) {
        boolean isAsyncHistoryEnabled = this.processEngineConfiguration.isAsyncHistoryEnabled();
        HistoryManager asyncHistoryManager = null;
        if (isAsyncHistoryEnabled) {
            this.processEngineConfiguration.setAsyncHistoryEnabled(false);
            asyncHistoryManager = this.processEngineConfiguration.getHistoryManager();
            this.processEngineConfiguration.setHistoryManager(new DefaultHistoryManager(this.processEngineConfiguration));
        }
        this.repositoryService.deleteDeployment(deploymentId, true);
        if (isAsyncHistoryEnabled) {
            this.processEngineConfiguration.setAsyncHistoryEnabled(true);
            this.processEngineConfiguration.setHistoryManager(asyncHistoryManager);
        }
    }

    protected void assertHistoricTasksDeleteReason(ProcessInstance processInstance, String expectedDeleteReason, String ... taskNames) {
        if (this.processEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.AUDIT)) {
            for (String taskName : taskNames) {
                List historicTaskInstances = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstance.getId())).taskName(taskName)).list();
                Assert.assertTrue((historicTaskInstances.size() > 0 ? 1 : 0) != 0);
                for (HistoricTaskInstance historicTaskInstance : historicTaskInstances) {
                    Assert.assertNotNull((Object)historicTaskInstance.getEndTime());
                    if (expectedDeleteReason == null) {
                        Assert.assertNull((Object)historicTaskInstance.getDeleteReason());
                        continue;
                    }
                    Assert.assertTrue((boolean)historicTaskInstance.getDeleteReason().startsWith(expectedDeleteReason));
                }
            }
        }
    }

    protected void assertHistoricActivitiesDeleteReason(ProcessInstance processInstance, String expectedDeleteReason, String ... activityIds) {
        if (this.processEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.AUDIT)) {
            for (String activityId : activityIds) {
                List historicActivityInstances = this.historyService.createHistoricActivityInstanceQuery().activityId(activityId).processInstanceId(processInstance.getId()).list();
                Assert.assertTrue((String)"Could not find historic activities", (historicActivityInstances.size() > 0 ? 1 : 0) != 0);
                for (HistoricActivityInstance historicActivityInstance : historicActivityInstances) {
                    Assert.assertNotNull((Object)historicActivityInstance.getEndTime());
                    if (expectedDeleteReason == null) {
                        Assert.assertNull((Object)historicActivityInstance.getDeleteReason());
                        continue;
                    }
                    Assert.assertTrue((boolean)historicActivityInstance.getDeleteReason().startsWith(expectedDeleteReason));
                }
            }
        }
    }

    protected void completeTask(Task task) {
        this.taskService.complete(task.getId());
    }

    protected static <T> List<T> mergeLists(List<T> list1, List<T> list2) {
        Objects.requireNonNull(list1);
        Objects.requireNonNull(list2);
        return Stream.concat(list1.stream(), list2.stream()).collect(Collectors.toList());
    }

    protected static <T> Map<String, List<T>> groupListContentBy(List<T> source, Function<T, String> classifier) {
        return source.stream().collect(Collectors.groupingBy(classifier));
    }

    protected String getJobActivityId(Job job) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            Map jobConfigurationMap = (Map)objectMapper.readValue(job.getJobHandlerConfiguration(), (TypeReference)new TypeReference<Map<String, Object>>(){});
            return (String)jobConfigurationMap.get("activityId");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected ProcessDefinition deployProcessDefinition(String name, String path) {
        Deployment deployment = this.repositoryService.createDeployment().name(name).addClasspathResource(path).deploy();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
        return processDefinition;
    }

    protected void completeProcessInstanceTasks(String processInstanceId) {
        List tasks;
        do {
            tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).list();
            tasks.forEach(this::completeTask);
        } while (!tasks.isEmpty());
    }
}

