/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.interaction.droppable;

import com.googlecode.wicket.jquery.core.JQueryEvent;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.ajax.IJQueryAjaxAware;
import com.googlecode.wicket.jquery.core.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.jquery.ui.JQueryUIBehavior;
import com.googlecode.wicket.jquery.ui.interaction.droppable.IDroppableListener;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.util.lang.Args;

public class DroppableBehavior
extends JQueryUIBehavior
implements IJQueryAjaxAware {
    private static final long serialVersionUID = 1L;
    public static final String METHOD = "droppable";
    private final IDroppableListener listener;
    private JQueryAjaxBehavior onDropAjaxBehavior;
    private JQueryAjaxBehavior onOverAjaxBehavior = null;
    private JQueryAjaxBehavior onExitAjaxBehavior = null;
    private transient Component draggable = null;

    public DroppableBehavior(String selector, IDroppableListener listener) {
        this(selector, new Options(), listener);
    }

    public DroppableBehavior(String selector, Options options, IDroppableListener listener) {
        super(selector, METHOD, options);
        this.listener = (IDroppableListener)Args.notNull((Object)listener, (String)"listener");
    }

    public void setDraggable(Component draggable) {
        this.draggable = draggable;
    }

    public void bind(Component component) {
        super.bind(component);
        this.onDropAjaxBehavior = this.newOnDropAjaxBehavior(this);
        component.add(new Behavior[]{this.onDropAjaxBehavior});
        if (this.listener.isOverEventEnabled()) {
            this.onOverAjaxBehavior = this.newOnOverAjaxBehavior(this);
            component.add(new Behavior[]{this.onOverAjaxBehavior});
        }
        if (this.listener.isExitEventEnabled()) {
            this.onExitAjaxBehavior = this.newOnExitAjaxBehavior(this);
            component.add(new Behavior[]{this.onExitAjaxBehavior});
        }
    }

    @Override
    public void onConfigure(Component component) {
        this.setOption("drop", this.onDropAjaxBehavior.getCallbackFunction());
        if (this.onOverAjaxBehavior != null) {
            this.setOption("over", this.onOverAjaxBehavior.getCallbackFunction());
        }
        if (this.onExitAjaxBehavior != null) {
            this.setOption("out", this.onExitAjaxBehavior.getCallbackFunction());
        }
        super.onConfigure(component);
    }

    public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
        if (event instanceof DropEvent) {
            this.listener.onDrop(target, this.draggable);
        } else if (event instanceof OverEvent) {
            this.listener.onOver(target, this.draggable);
        } else if (event instanceof ExitEvent) {
            this.listener.onExit(target, this.draggable);
        }
    }

    protected JQueryAjaxBehavior newOnDropAjaxBehavior(IJQueryAjaxAware source) {
        return new OnDropAjaxBehavior(source);
    }

    protected JQueryAjaxBehavior newOnOverAjaxBehavior(IJQueryAjaxAware source) {
        return new OnOverAjaxBehavior(source);
    }

    protected JQueryAjaxBehavior newOnExitAjaxBehavior(IJQueryAjaxAware source) {
        return new OnExitAjaxBehavior(source);
    }

    protected static class DropEvent
    extends JQueryEvent {
        protected DropEvent() {
        }
    }

    protected static class OverEvent
    extends JQueryEvent {
        protected OverEvent() {
        }
    }

    protected static class ExitEvent
    extends JQueryEvent {
        protected ExitEvent() {
        }
    }

    protected static class OnDropAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnDropAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"event"), CallbackParameter.context((String)"ui")};
        }

        protected JQueryEvent newEvent() {
            return new DropEvent();
        }
    }

    protected static class OnOverAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnOverAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"event"), CallbackParameter.context((String)"ui")};
        }

        protected JQueryEvent newEvent() {
            return new OverEvent();
        }
    }

    protected static class OnExitAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnExitAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"event"), CallbackParameter.context((String)"ui")};
        }

        protected JQueryEvent newEvent() {
            return new ExitEvent();
        }
    }
}

