/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.Map;
import net.tirasa.connid.bundles.rest.FIQLFilterTranslator;
import net.tirasa.connid.bundles.rest.RESTConfiguration;
import net.tirasa.connid.commons.scripted.AbstractScriptedConnector;
import org.apache.cxf.jaxrs.client.WebClient;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.common.security.SecurityUtil;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.filter.FilterTranslator;
import org.identityconnectors.framework.spi.Configuration;
import org.identityconnectors.framework.spi.ConnectorClass;

@ConnectorClass(configurationClass=RESTConfiguration.class, displayNameKey="rest.connector.display")
public class RESTConnector
extends AbstractScriptedConnector<RESTConfiguration> {
    protected WebClient client;

    public void init(Configuration cfg) {
        this.config = (RESTConfiguration)cfg;
        this.client = WebClient.create((String)((RESTConfiguration)this.config).getBaseAddress(), null, (String)((RESTConfiguration)this.config).getUsername(), ((RESTConfiguration)this.config).getPassword() == null ? null : SecurityUtil.decrypt((GuardedString)((RESTConfiguration)this.config).getPassword()), null).accept(new String[]{((RESTConfiguration)this.config).getAccept()}).type(((RESTConfiguration)this.config).getContentType());
        if (StringUtil.isNotBlank((String)((RESTConfiguration)this.config).getClientId()) && StringUtil.isNotBlank((String)((RESTConfiguration)this.config).getClientSecret()) && StringUtil.isNotBlank((String)((RESTConfiguration)this.config).getAccessTokenBaseAddress()) && StringUtil.isNotBlank((String)((RESTConfiguration)this.config).getAccessTokenNodeId())) {
            this.client = WebClient.create((String)((RESTConfiguration)this.config).getBaseAddress()).accept(new String[]{((RESTConfiguration)this.config).getAccept()}).type(((RESTConfiguration)this.config).getContentType());
            this.client.header("Authorization", new Object[]{"Bearer " + this.generateToken()});
        } else {
            this.client = WebClient.create((String)((RESTConfiguration)this.config).getBaseAddress(), null, (String)((RESTConfiguration)this.config).getUsername(), ((RESTConfiguration)this.config).getPassword() == null ? null : SecurityUtil.decrypt((GuardedString)((RESTConfiguration)this.config).getPassword()), null).accept(new String[]{((RESTConfiguration)this.config).getAccept()}).type(((RESTConfiguration)this.config).getContentType());
        }
        super.init(cfg);
    }

    protected String generateToken() {
        WebClient webClient = WebClient.create((String)((RESTConfiguration)this.config).getAccessTokenBaseAddress()).type(((RESTConfiguration)this.config).getAccessTokenContentType()).accept(new String[]{((RESTConfiguration)this.config).getAccept()});
        String contentUri = "&client_id=" + ((RESTConfiguration)this.config).getClientId() + "&client_secret=" + ((RESTConfiguration)this.config).getClientSecret() + "&username=" + ((RESTConfiguration)this.config).getUsername() + "&password=" + SecurityUtil.decrypt((GuardedString)((RESTConfiguration)this.config).getPassword());
        String token = null;
        try {
            Response response = webClient.post((Object)contentUri);
            String responseAsString = (String)response.readEntity(String.class);
            JsonNode result = new ObjectMapper().readTree(responseAsString);
            if (result == null || !result.hasNonNull(((RESTConfiguration)this.config).getAccessTokenNodeId())) {
                throw new ConnectorException("No access token found - " + responseAsString);
            }
            token = result.get(((RESTConfiguration)this.config).getAccessTokenNodeId()).textValue();
        }
        catch (Exception ex) {
            throw new ConnectorException("While obtaining authentication token", (Throwable)ex);
        }
        return token;
    }

    protected Map<String, Object> buildArguments() {
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put("configuration", this.config);
        arguments.put("client", this.client);
        return arguments;
    }

    public FilterTranslator<Map<String, Object>> createFilterTranslator(ObjectClass objectClass, OperationOptions options) {
        if (objectClass == null) {
            throw new IllegalArgumentException(((RESTConfiguration)this.config).getMessage("objectClass.required", new Object[0]));
        }
        LOG.ok("ObjectClass: {0}", new Object[]{objectClass.getObjectClassValue()});
        return new FIQLFilterTranslator();
    }
}

