/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao.repo;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.util.stream.Collectors;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.jpa.dao.OracleJPAAnySearchDAO;
import org.apache.syncope.core.persistence.jpa.dao.SearchSupport;
import org.apache.syncope.core.persistence.jpa.dao.repo.AbstractPlainSchemaRepoExt;

public class OraclePlainSchemaRepoExtImpl
extends AbstractPlainSchemaRepoExt {
    protected static final String HAS_ATTRS_QUERY = "SELECT id FROM %TABLE%, %JSON_TABLE% ";
    protected final PlainSchemaDAO plainSchemaDAO;

    public OraclePlainSchemaRepoExtImpl(AnyUtilsFactory anyUtilsFactory, ExternalResourceDAO resourceDAO, PlainSchemaDAO plainSchemaDAO, EntityManager entityManager) {
        super(anyUtilsFactory, resourceDAO, entityManager);
        this.plainSchemaDAO = plainSchemaDAO;
    }

    @Override
    public boolean hasAttrs(PlainSchema schema) {
        Query query = this.entityManager.createNativeQuery("SELECT COUNT(id) FROM ( " + TABLES.stream().map(t -> HAS_ATTRS_QUERY.replace("%TABLE%", (CharSequence)t).replace("%JSON_TABLE%", OracleJPAAnySearchDAO.from(schema))).collect(Collectors.joining(" UNION ")) + ")");
        return ((Number)query.getSingleResult()).intValue() > 0;
    }

    @Override
    public boolean existsPlainAttrUniqueValue(String realmKey, PlainSchema schema, PlainAttrValue attrValue) {
        Query query = this.entityManager.createNativeQuery("SELECT COUNT(id) FROM Realm," + OracleJPAAnySearchDAO.from((PlainSchema)this.plainSchemaDAO.findById(schema.getKey()).orElseThrow(() -> new NotFoundException("PlainSchema " + schema.getKey()))) + " WHERE " + schema.getKey() + ".uniqueValue=?1 AND id <> ?2");
        query.setParameter(1, attrValue.getValue());
        query.setParameter(2, (Object)realmKey);
        return ((Number)query.getSingleResult()).intValue() > 0;
    }

    @Override
    public boolean existsPlainAttrUniqueValue(AnyUtils anyUtils, String anyKey, PlainSchema schema, PlainAttrValue attrValue) {
        Query query = this.entityManager.createNativeQuery("SELECT COUNT(id) FROM " + new SearchSupport(anyUtils.anyTypeKind()).table().name() + "," + OracleJPAAnySearchDAO.from((PlainSchema)this.plainSchemaDAO.findById(schema.getKey()).orElseThrow(() -> new NotFoundException("PlainSchema " + schema.getKey()))) + " WHERE " + schema.getKey() + ".uniqueValue=?1 AND id <> ?2");
        query.setParameter(1, attrValue.getValue());
        query.setParameter(2, (Object)anyKey);
        return ((Number)query.getSingleResult()).intValue() > 0;
    }
}

