/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.Groupable;
import org.apache.syncope.core.persistence.api.entity.Membership;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.Relationship;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.jpa.entity.AbstractRelatable;

public abstract class AbstractGroupableRelatable<L extends Any, M extends Membership<L>, R extends Any, REL extends Relationship<L, R>>
extends AbstractRelatable<L, R, REL>
implements Groupable<L, M, R, REL> {
    private static final long serialVersionUID = -2269285197388729673L;

    public List<PlainAttr> getPlainAttrs() {
        return this.getPlainAttrsList().stream().filter(attr -> attr.getMembership() == null).toList();
    }

    public Optional<PlainAttr> getPlainAttr(String plainSchema) {
        return this.getPlainAttrsList().stream().filter(attr -> attr.getMembership() == null && plainSchema.equals(attr.getSchema())).findFirst();
    }

    public Optional<PlainAttr> getPlainAttr(String plainSchema, Membership<?> membership) {
        return this.getPlainAttrsList().stream().filter(attr -> plainSchema.equals(attr.getSchema()) && membership.getKey().equals(attr.getMembership())).findFirst();
    }

    public Collection<PlainAttr> getPlainAttrs(String plainSchema) {
        return this.getPlainAttrsList().stream().filter(attr -> plainSchema.equals(attr.getSchema())).toList();
    }

    public Collection<PlainAttr> getPlainAttrs(Membership<?> membership) {
        return this.getPlainAttrsList().stream().filter(attr -> membership.getKey().equals(attr.getMembership())).toList();
    }

    public Optional<? extends M> getMembership(String groupKey) {
        return this.getMemberships().stream().filter(membership -> groupKey.equals(((Group)membership.getRightEnd()).getKey())).findFirst();
    }
}

