/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.request.AnyCR;
import org.apache.syncope.common.lib.request.AnyObjectCR;
import org.apache.syncope.common.lib.request.GroupCR;
import org.apache.syncope.common.lib.request.UserCR;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.LinkedAccountTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.RelationshipTO;
import org.apache.syncope.common.lib.to.UserTO;

public final class EntityTOUtils {
    public static Map<String, Attr> buildAttrMap(Collection<Attr> attrs) {
        return attrs.stream().collect(Collectors.toUnmodifiableMap(Attr::getSchema, Function.identity(), (exist, repl) -> repl));
    }

    public static Map<Pair<String, String>, RelationshipTO> buildRelationshipMap(Collection<RelationshipTO> relationships) {
        return relationships.stream().collect(Collectors.toUnmodifiableMap(rel -> Pair.of((Object)rel.getType(), (Object)rel.getOtherEndKey()), Function.identity(), (exist, repl) -> repl));
    }

    public static Map<String, MembershipTO> buildMembershipMap(Collection<MembershipTO> memberships) {
        return memberships.stream().collect(Collectors.toUnmodifiableMap(MembershipTO::getGroupKey, Function.identity(), (exist, repl) -> repl));
    }

    public static Map<Pair<String, String>, LinkedAccountTO> buildLinkedAccountMap(Collection<LinkedAccountTO> accounts) {
        return accounts.stream().collect(Collectors.toUnmodifiableMap(account -> Pair.of((Object)account.getResource(), (Object)account.getConnObjectKeyValue()), Function.identity(), (exist, repl) -> repl));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static <A extends AnyTO, C extends AnyCR> void toAnyCR(A anyTO, C anyCR) {
        anyCR.setRealm(anyTO.getRealm());
        anyCR.getAuxClasses().addAll(anyTO.getAuxClasses());
        anyCR.getPlainAttrs().addAll(anyTO.getPlainAttrs());
        anyCR.getResources().addAll(anyTO.getResources());
        if (anyCR instanceof UserCR) {
            UserCR userCR = (UserCR)anyCR;
            if (anyTO instanceof UserTO) {
                UserTO userTO = (UserTO)anyTO;
                userCR.setUsername(userTO.getUsername());
                userCR.setPassword(userTO.getPassword());
                userCR.setSecurityQuestion(userTO.getSecurityQuestion());
                userCR.setSecurityAnswer(userTO.getSecurityAnswer());
                userCR.setMustChangePassword(userTO.isMustChangePassword());
                userCR.getRelationships().addAll(userTO.getRelationships());
                userCR.getMemberships().addAll(userTO.getMemberships());
                userCR.getRoles().addAll(userTO.getRoles());
                return;
            }
        }
        if (anyCR instanceof GroupCR) {
            GroupCR groupCR = (GroupCR)anyCR;
            if (anyTO instanceof GroupTO) {
                GroupTO groupTO = (GroupTO)anyTO;
                groupCR.setName(groupTO.getName());
                groupCR.setUserOwner(groupTO.getUserOwner());
                groupCR.setGroupOwner(groupTO.getGroupOwner());
                groupCR.setUDynMembershipCond(groupTO.getUDynMembershipCond());
                groupCR.getADynMembershipConds().putAll(groupTO.getADynMembershipConds());
                groupCR.getTypeExtensions().addAll(groupTO.getTypeExtensions());
                return;
            }
        }
        if (!(anyCR instanceof AnyObjectCR)) return;
        AnyObjectCR anyObjectCR = (AnyObjectCR)anyCR;
        if (!(anyTO instanceof AnyObjectTO)) return;
        AnyObjectTO anyObjectTO = (AnyObjectTO)anyTO;
        anyObjectCR.setType(anyObjectTO.getType());
        anyObjectCR.setName(anyObjectTO.getName());
        anyObjectCR.getRelationships().addAll(anyObjectTO.getRelationships());
        anyObjectCR.getMemberships().addAll(anyObjectTO.getMemberships());
    }

    /*
     * Enabled aggressive block sorting
     */
    public static <C extends AnyCR, A extends AnyTO> void toAnyTO(C anyCR, A anyTO) {
        anyTO.setRealm(anyCR.getRealm());
        anyTO.getAuxClasses().addAll(anyCR.getAuxClasses());
        anyTO.getPlainAttrs().addAll(anyCR.getPlainAttrs());
        anyTO.getResources().addAll(anyCR.getResources());
        if (anyTO instanceof UserTO) {
            UserTO userTO = (UserTO)anyTO;
            if (anyCR instanceof UserCR) {
                UserCR userCR = (UserCR)anyCR;
                userTO.setUsername(userCR.getUsername());
                userTO.setPassword(userCR.getPassword());
                userTO.setSecurityQuestion(userCR.getSecurityQuestion());
                userTO.setSecurityAnswer(userCR.getSecurityAnswer());
                userTO.setMustChangePassword(userCR.isMustChangePassword());
                userTO.getRelationships().addAll(userCR.getRelationships());
                userTO.getMemberships().addAll(userCR.getMemberships());
                userTO.getRoles().addAll(userCR.getRoles());
                return;
            }
        }
        if (anyTO instanceof GroupTO) {
            GroupTO groupTO = (GroupTO)anyTO;
            if (anyCR instanceof GroupCR) {
                GroupCR groupCR = (GroupCR)anyCR;
                groupTO.setName(groupCR.getName());
                groupTO.setUserOwner(groupCR.getUserOwner());
                groupTO.setGroupOwner(groupCR.getGroupOwner());
                groupTO.setUDynMembershipCond(groupCR.getUDynMembershipCond());
                groupTO.getADynMembershipConds().putAll(groupCR.getADynMembershipConds());
                groupTO.getTypeExtensions().addAll(groupCR.getTypeExtensions());
                return;
            }
        }
        if (!(anyTO instanceof AnyObjectTO)) return;
        AnyObjectTO anyObjectTO = (AnyObjectTO)anyTO;
        if (!(anyCR instanceof AnyObjectCR)) return;
        AnyObjectCR anyObjectCR = (AnyObjectCR)anyCR;
        anyObjectTO.setType(anyObjectCR.getType());
        anyObjectTO.setName(anyObjectCR.getName());
        anyObjectTO.getRelationships().addAll(anyObjectCR.getRelationships());
        anyObjectTO.getMemberships().addAll(anyObjectCR.getMemberships());
    }

    private EntityTOUtils() {
    }
}

