/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.ws.rs.PathParam;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.syncope.common.lib.BaseBean;
import org.apache.syncope.common.lib.request.AnyObjectUR;
import org.apache.syncope.common.lib.request.AttrPatch;
import org.apache.syncope.common.lib.request.GroupUR;
import org.apache.syncope.common.lib.request.StringPatchItem;
import org.apache.syncope.common.lib.request.StringReplacePatchItem;
import org.apache.syncope.common.lib.request.UserUR;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="_class")
@JsonPropertyOrder(value={"_class", "key"})
@Schema(subTypes={UserUR.class, GroupUR.class, AnyObjectUR.class}, discriminatorProperty="_class")
public abstract class AnyUR
implements BaseBean {
    private static final long serialVersionUID = -7445489774552440544L;
    @JacksonXmlProperty(localName="_class", isAttribute=true)
    @JsonProperty(value="_class")
    private String discriminator;
    private String key;
    private StringReplacePatchItem realm;
    private final Set<StringPatchItem> auxClasses = new HashSet<StringPatchItem>();
    private final Set<AttrPatch> plainAttrs = new HashSet<AttrPatch>();
    private final Set<StringPatchItem> resources = new HashSet<StringPatchItem>();

    @Schema(name="_class", requiredMode=Schema.RequiredMode.REQUIRED)
    public abstract String getDiscriminator();

    public void setDiscriminator(String discriminator) {
    }

    @JsonProperty(required=true)
    public String getKey() {
        return this.key;
    }

    @PathParam(value="key")
    public void setKey(String key) {
        this.key = key;
    }

    public StringReplacePatchItem getRealm() {
        return this.realm;
    }

    public void setRealm(StringReplacePatchItem realm) {
        this.realm = realm;
    }

    @JacksonXmlElementWrapper(localName="auxClasses")
    @JacksonXmlProperty(localName="auxClass")
    public Set<StringPatchItem> getAuxClasses() {
        return this.auxClasses;
    }

    @JacksonXmlElementWrapper(localName="plainAttrs")
    @JacksonXmlProperty(localName="plainAttr")
    public Set<AttrPatch> getPlainAttrs() {
        return this.plainAttrs;
    }

    @JacksonXmlElementWrapper(localName="resources")
    @JacksonXmlProperty(localName="resource")
    public Set<StringPatchItem> getResources() {
        return this.resources;
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.realm == null && this.auxClasses.isEmpty() && this.plainAttrs.isEmpty() && this.resources.isEmpty();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.discriminator).append((Object)this.key).append((Object)this.realm).append(this.auxClasses).append(this.plainAttrs).append(this.resources).build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnyUR other = (AnyUR)obj;
        return new EqualsBuilder().append((Object)this.discriminator, (Object)other.discriminator).append((Object)this.key, (Object)other.key).append((Object)this.realm, (Object)other.realm).append(this.auxClasses, other.auxClasses).append(this.plainAttrs, other.plainAttrs).append(this.resources, other.resources).build();
    }

    protected static abstract class Builder<R extends AnyUR, B extends Builder<R, B>> {
        protected R instance;

        Builder(String key) {
            ((AnyUR)this.getInstance()).setKey(key);
        }

        protected abstract R newInstance();

        protected final R getInstance() {
            if (this.instance == null) {
                this.instance = this.newInstance();
            }
            return this.instance;
        }

        public B realm(StringReplacePatchItem realm) {
            ((AnyUR)this.getInstance()).setRealm(realm);
            return (B)this;
        }

        public B auxClass(StringPatchItem auxClass) {
            ((AnyUR)this.getInstance()).getAuxClasses().add(auxClass);
            return (B)this;
        }

        public B auxClasses(StringPatchItem ... auxClasses) {
            ((AnyUR)this.getInstance()).getAuxClasses().addAll(List.of(auxClasses));
            return (B)this;
        }

        public B auxClasses(Collection<StringPatchItem> auxClasses) {
            ((AnyUR)this.getInstance()).getAuxClasses().addAll(auxClasses);
            return (B)this;
        }

        public B plainAttr(AttrPatch plainAttr) {
            ((AnyUR)this.getInstance()).getPlainAttrs().add(plainAttr);
            return (B)this;
        }

        public B plainAttrs(AttrPatch ... plainAttrs) {
            ((AnyUR)this.getInstance()).getPlainAttrs().addAll(List.of(plainAttrs));
            return (B)this;
        }

        public B plainAttrs(Collection<AttrPatch> plainAttrs) {
            ((AnyUR)this.getInstance()).getPlainAttrs().addAll(plainAttrs);
            return (B)this;
        }

        public B resource(StringPatchItem resource) {
            ((AnyUR)this.getInstance()).getResources().add(resource);
            return (B)this;
        }

        public B resources(StringPatchItem ... resources) {
            ((AnyUR)this.getInstance()).getResources().addAll(List.of(resources));
            return (B)this;
        }

        public B resources(Collection<StringPatchItem> resources) {
            ((AnyUR)this.getInstance()).getResources().addAll(resources);
            return (B)this;
        }

        public R build() {
            return this.getInstance();
        }
    }
}

