/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClient;
import software.amazon.awssdk.services.cloudwatch.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudwatch.model.AnomalyDetector;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAnomalyDetectorsRequest;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAnomalyDetectorsResponse;

public class DescribeAnomalyDetectorsIterable
implements SdkIterable<DescribeAnomalyDetectorsResponse> {
    private final CloudWatchClient client;
    private final DescribeAnomalyDetectorsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeAnomalyDetectorsIterable(CloudWatchClient client, DescribeAnomalyDetectorsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeAnomalyDetectorsResponseFetcher();
    }

    public Iterator<DescribeAnomalyDetectorsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AnomalyDetector> anomalyDetectors() {
        Function<DescribeAnomalyDetectorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.anomalyDetectors() != null) {
                return response.anomalyDetectors().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeAnomalyDetectorsResponseFetcher
    implements SyncPageFetcher<DescribeAnomalyDetectorsResponse> {
        private DescribeAnomalyDetectorsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAnomalyDetectorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeAnomalyDetectorsResponse nextPage(DescribeAnomalyDetectorsResponse previousPage) {
            if (previousPage == null) {
                return DescribeAnomalyDetectorsIterable.this.client.describeAnomalyDetectors(DescribeAnomalyDetectorsIterable.this.firstRequest);
            }
            return DescribeAnomalyDetectorsIterable.this.client.describeAnomalyDetectors((DescribeAnomalyDetectorsRequest)((Object)DescribeAnomalyDetectorsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

