/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.retry.interceptor;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.ProxyMethodInvocation;
import org.springframework.lang.Nullable;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryOperations;
import org.springframework.retry.interceptor.MethodInvocationRecoverer;
import org.springframework.retry.interceptor.MethodInvocationRetryCallback;
import org.springframework.retry.support.Args;
import org.springframework.retry.support.RetrySynchronizationManager;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;

public class RetryOperationsInterceptor
implements MethodInterceptor {
    public static final String METHOD = "method";
    public static final String METHOD_ARGS = "methodArgs";
    private RetryOperations retryOperations = new RetryTemplate();
    @Nullable
    private MethodInvocationRecoverer<?> recoverer;
    private String label;

    public void setLabel(String label) {
        this.label = label;
    }

    public void setRetryOperations(RetryOperations retryTemplate) {
        Assert.notNull((Object)retryTemplate, (String)"'retryOperations' cannot be null.");
        this.retryOperations = retryTemplate;
    }

    public void setRecoverer(MethodInvocationRecoverer<?> recoverer) {
        this.recoverer = recoverer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        MethodInvocationRetryCallback<Object, Throwable> retryCallback = new MethodInvocationRetryCallback<Object, Throwable>(invocation, this.label){

            @Override
            public Object doWithRetry(RetryContext context) throws Exception {
                context.setAttribute("context.name", this.label);
                Args args = new Args(this.invocation.getArguments());
                context.setAttribute(RetryOperationsInterceptor.METHOD, this.invocation.getMethod());
                context.setAttribute(RetryOperationsInterceptor.METHOD_ARGS, args);
                context.setAttribute("ARGS", args);
                if (this.invocation instanceof ProxyMethodInvocation) {
                    context.setAttribute("___proxy___", ((ProxyMethodInvocation)this.invocation).getProxy());
                    try {
                        return ((ProxyMethodInvocation)this.invocation).invocableClone().proceed();
                    }
                    catch (Error | Exception e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new IllegalStateException(e);
                    }
                }
                throw new IllegalStateException("MethodInvocation of the wrong type detected - this should not happen with Spring AOP, so please raise an issue if you see this exception");
            }
        };
        ItemRecovererCallback recoveryCallback = this.recoverer != null ? new ItemRecovererCallback(invocation.getArguments(), this.recoverer) : null;
        try {
            Object object = this.retryOperations.execute(retryCallback, recoveryCallback);
            return object;
        }
        finally {
            RetryContext context = RetrySynchronizationManager.getContext();
            if (context != null) {
                context.removeAttribute("___proxy___");
            }
        }
    }

    private record ItemRecovererCallback(Object[] args, MethodInvocationRecoverer<?> recoverer) implements RecoveryCallback<Object>
    {
        @Override
        public Object recover(RetryContext context) {
            return this.recoverer.recover(this.args, context.getLastThrowable());
        }
    }
}

