/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.actions;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.adaptive.AdaptiveAuthenticationPolicy;
import org.apereo.cas.authentication.adaptive.UnauthorizedAuthenticationException;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationRequest;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public abstract class AbstractAuthenticationAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAuthenticationAction.class);
    private final CasDelegatingWebflowEventResolver initialAuthenticationAttemptWebflowEventResolver;
    private final CasWebflowEventResolver serviceTicketRequestWebflowEventResolver;
    private final AdaptiveAuthenticationPolicy adaptiveAuthenticationPolicy;

    @Override
    protected Event doExecuteInternal(RequestContext requestContext) throws Throwable {
        if (!this.evaluateAdaptiveAuthenticationPolicy(requestContext)) {
            String agent = WebUtils.getHttpServletRequestUserAgentFromRequestContext((RequestContext)requestContext);
            GeoLocationRequest geoLocation = WebUtils.getHttpServletRequestGeoLocationFromRequestContext((RequestContext)requestContext);
            String msg = "Adaptive authentication policy does not allow this request for " + agent + " and " + String.valueOf(geoLocation);
            LOGGER.warn(msg);
            Map map = CollectionUtils.wrap((String)UnauthorizedAuthenticationException.class.getSimpleName(), (Object)new UnauthorizedAuthenticationException(msg));
            AuthenticationException error = new AuthenticationException(msg, map, new HashMap(0));
            Event event = new Event((Object)this, "authenticationFailure", (AttributeMap)new LocalAttributeMap("error", (Object)error));
            this.fireEventHooks(event, requestContext);
            return event;
        }
        Event serviceTicketEvent = this.serviceTicketRequestWebflowEventResolver.resolveSingle(requestContext);
        if (serviceTicketEvent != null) {
            this.fireEventHooks(serviceTicketEvent, requestContext);
            return serviceTicketEvent;
        }
        Event finalEvent = this.initialAuthenticationAttemptWebflowEventResolver.resolveSingle(requestContext);
        this.fireEventHooks(finalEvent, requestContext);
        return finalEvent;
    }

    protected boolean evaluateAdaptiveAuthenticationPolicy(RequestContext requestContext) throws Throwable {
        String agent = WebUtils.getHttpServletRequestUserAgentFromRequestContext((RequestContext)requestContext);
        GeoLocationRequest geoLocation = WebUtils.getHttpServletRequestGeoLocationFromRequestContext((RequestContext)requestContext);
        return this.adaptiveAuthenticationPolicy.isAuthenticationRequestAllowed(requestContext, agent, geoLocation);
    }

    protected Event fireEventHooks(Event event, RequestContext ctx) {
        String id = event.getId();
        if (id.equals("error") || id.equals("authenticationFailure")) {
            this.onError(ctx);
        }
        if (id.equals("warn")) {
            this.onWarn(ctx);
        }
        if (id.equals("success")) {
            this.onSuccess(ctx);
        }
        return event;
    }

    protected void onWarn(RequestContext context) {
    }

    protected void onSuccess(RequestContext context) {
    }

    protected void onError(RequestContext context) {
    }

    @Generated
    protected AbstractAuthenticationAction(CasDelegatingWebflowEventResolver initialAuthenticationAttemptWebflowEventResolver, CasWebflowEventResolver serviceTicketRequestWebflowEventResolver, AdaptiveAuthenticationPolicy adaptiveAuthenticationPolicy) {
        this.initialAuthenticationAttemptWebflowEventResolver = initialAuthenticationAttemptWebflowEventResolver;
        this.serviceTicketRequestWebflowEventResolver = serviceTicketRequestWebflowEventResolver;
        this.adaptiveAuthenticationPolicy = adaptiveAuthenticationPolicy;
    }
}

