/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.actions;

import java.util.Comparator;
import java.util.Optional;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.web.flow.decorator.WebflowDecorator;
import org.apereo.cas.web.support.WebUtils;
import org.jooq.lambda.Unchecked;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.StateDefinition;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.ActionExecutionException;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public abstract class BaseCasWebflowAction
extends AbstractAction {
    protected static boolean isLoginFlowActive(RequestContext requestContext) {
        String currentFlowId = Optional.ofNullable(requestContext.getActiveFlow()).map(FlowDefinition::getId).orElse("unknown");
        return currentFlowId.equalsIgnoreCase("login");
    }

    protected Event doPreExecute(RequestContext requestContext) throws Exception {
        ApplicationContext applicationContext = requestContext.getActiveFlow().getApplicationContext();
        FunctionUtils.doIfNotNull((Object)applicationContext, __ -> BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)applicationContext, WebflowDecorator.class).values().stream().filter(BeanSupplier::isNotProxy).sorted((Comparator<WebflowDecorator>)AnnotationAwareOrderComparator.INSTANCE).forEach(Unchecked.consumer(decorator -> decorator.decorate(requestContext))));
        return super.doPreExecute(requestContext);
    }

    protected final Event doExecute(RequestContext requestContext) throws Exception {
        FlowDefinition activeFlow = requestContext.getActiveFlow();
        try {
            WebUtils.putActiveFlow((RequestContext)requestContext);
            return this.doExecuteInternal(requestContext);
        }
        catch (Exception e) {
            throw e;
        }
        catch (Throwable e) {
            String currentState = Optional.ofNullable(requestContext.getCurrentState()).map(StateDefinition::getId).orElse("unknown");
            throw new ActionExecutionException(activeFlow.getId(), currentState, (Action)this, (AttributeMap)requestContext.getAttributes(), e);
        }
    }

    protected abstract Event doExecuteInternal(RequestContext var1) throws Throwable;
}

