/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.proxy;

import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.TokensInheritanceStrategy;
import io.github.bucket4j.distributed.AsyncBucketProxy;
import io.github.bucket4j.distributed.proxy.RecoveryStrategy;
import io.github.bucket4j.distributed.proxy.optimization.Optimization;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;

public interface RemoteAsyncBucketBuilder<K> {
    public RemoteAsyncBucketBuilder<K> withRecoveryStrategy(RecoveryStrategy var1);

    public RemoteAsyncBucketBuilder<K> withOptimization(Optimization var1);

    public RemoteAsyncBucketBuilder<K> withImplicitConfigurationReplacement(long var1, TokensInheritanceStrategy var3);

    public AsyncBucketProxy build(K var1, BucketConfiguration var2);

    public AsyncBucketProxy build(K var1, Supplier<CompletableFuture<BucketConfiguration>> var2);

    default public <K1> RemoteAsyncBucketBuilder<K1> withMapper(final Function<? super K1, ? extends K> mapper) {
        return new RemoteAsyncBucketBuilder<K1>(){

            @Override
            public RemoteAsyncBucketBuilder<K1> withRecoveryStrategy(RecoveryStrategy recoveryStrategy) {
                RemoteAsyncBucketBuilder.this.withRecoveryStrategy(recoveryStrategy);
                return this;
            }

            @Override
            public RemoteAsyncBucketBuilder<K1> withOptimization(Optimization optimization) {
                RemoteAsyncBucketBuilder.this.withOptimization(optimization);
                return this;
            }

            @Override
            public RemoteAsyncBucketBuilder<K1> withImplicitConfigurationReplacement(long desiredConfigurationVersion, TokensInheritanceStrategy tokensInheritanceStrategy) {
                RemoteAsyncBucketBuilder.this.withImplicitConfigurationReplacement(desiredConfigurationVersion, tokensInheritanceStrategy);
                return this;
            }

            @Override
            public AsyncBucketProxy build(K1 key, BucketConfiguration configuration) {
                return RemoteAsyncBucketBuilder.this.build(mapper.apply(key), configuration);
            }

            @Override
            public AsyncBucketProxy build(K1 key, Supplier<CompletableFuture<BucketConfiguration>> configurationSupplier) {
                return RemoteAsyncBucketBuilder.this.build(mapper.apply(key), configurationSupplier);
            }

            @Override
            public <K2> RemoteAsyncBucketBuilder<K2> withMapper(Function<? super K2, ? extends K1> innerMapper) {
                return RemoteAsyncBucketBuilder.this.withMapper(mapper.compose(innerMapper));
            }
        };
    }
}

