/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.profile.action.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.context.ProfileRequestContext;

public abstract class AbstractMessageChannelSecurity
extends AbstractProfileAction {
    @Nonnull
    private Function<ProfileRequestContext, BaseContext> parentContextLookupStrategy = input -> input;
    @Nullable
    private BaseContext parentContext;

    public void setParentContextLookupStrategy(@Nonnull Function<ProfileRequestContext, BaseContext> strategy) {
        this.checkSetterPreconditions();
        this.parentContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Parent context lookup strategy cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.parentContext = this.parentContextLookupStrategy.apply(profileRequestContext);
        return this.parentContext != null;
    }

    @Nullable
    protected BaseContext getParentContext() {
        return this.parentContext;
    }

    @Nonnull
    protected BaseContext ensureParentContext() {
        if (this.parentContext != null) {
            return this.parentContext;
        }
        throw new IllegalStateException("Parent context was null");
    }
}

