/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.request.UserUR;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.UserRequest;
import org.apache.syncope.common.lib.to.UserRequestForm;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.to.WorkflowTaskExecInput;
import org.apache.syncope.common.lib.types.BpmnProcessFormat;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.flowable.api.BpmnProcessManager;
import org.apache.syncope.core.flowable.api.UserRequestHandler;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.UserWorkflowResult;
import org.apache.syncope.core.provisioning.api.data.UserDataBinder;
import org.apache.syncope.core.provisioning.api.propagation.PropagationManager;
import org.apache.syncope.core.provisioning.api.propagation.PropagationReporter;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskExecutor;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.flowable.engine.runtime.ProcessInstance;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class UserRequestLogic
extends AbstractTransactionalLogic<EntityTO> {
    protected final BpmnProcessManager bpmnProcessManager;
    protected final UserRequestHandler userRequestHandler;
    protected final PropagationManager propagationManager;
    protected final PropagationTaskExecutor taskExecutor;
    protected final UserDataBinder binder;
    protected final UserDAO userDAO;

    public UserRequestLogic(BpmnProcessManager bpmnProcessManager, UserRequestHandler userRequestHandler, PropagationManager propagationManager, PropagationTaskExecutor taskExecutor, UserDataBinder binder, UserDAO userDAO) {
        this.bpmnProcessManager = bpmnProcessManager;
        this.userRequestHandler = userRequestHandler;
        this.propagationManager = propagationManager;
        this.taskExecutor = taskExecutor;
        this.binder = binder;
        this.userDAO = userDAO;
    }

    @PreAuthorize(value="isAuthenticated()")
    @Transactional(readOnly=true)
    public Page<UserRequest> listRequests(String userKey, Pageable pageable) {
        if (userKey == null) {
            UserRequestLogic.securityChecks(null, "USER_REQUEST_LIST", "Listing user requests not allowed");
        } else {
            User user = (User)this.userDAO.findById(userKey).orElseThrow(() -> new NotFoundException("User " + userKey));
            UserRequestLogic.securityChecks(user.getUsername(), "USER_REQUEST_LIST", "Listing requests for user" + user.getUsername() + " not allowed");
        }
        return this.userRequestHandler.getUserRequests(userKey, pageable);
    }

    protected UserRequest doStart(String bpmnProcess, User user, WorkflowTaskExecInput inputVariables) {
        this.bpmnProcessManager.exportProcess(bpmnProcess, BpmnProcessFormat.XML, (OutputStream)NullOutputStream.INSTANCE);
        return this.userRequestHandler.start(bpmnProcess, user, inputVariables);
    }

    @PreAuthorize(value="isAuthenticated()")
    public UserRequest startRequest(String bpmnProcess, WorkflowTaskExecInput inputVariables) {
        return this.doStart(bpmnProcess, (User)this.userDAO.findByUsername(AuthContextUtils.getUsername()).orElseThrow(() -> new NotFoundException("Authenticated user")), inputVariables);
    }

    @PreAuthorize(value="hasRole('USER_REQUEST_START')")
    public UserRequest startRequest(String bpmnProcess, String userKey, WorkflowTaskExecInput inputVariables) {
        return this.doStart(bpmnProcess, (User)this.userDAO.authFind(userKey), inputVariables);
    }

    protected static void securityChecks(String username, String entitlement, String errorMessage) {
        if (!AuthContextUtils.getUsername().equals(username) && AuthContextUtils.getAuthorities().stream().noneMatch(auth -> entitlement.equals(auth.getAuthority()))) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.DelegatedAdministration);
            sce.getElements().add(errorMessage);
            throw sce;
        }
    }

    @PreAuthorize(value="isAuthenticated()")
    public void cancelRequest(String executionId, String reason) {
        Pair parsed = this.userRequestHandler.parse(executionId);
        UserRequestLogic.securityChecks((String)this.userDAO.findUsername((String)parsed.getRight()).orElseThrow(() -> new NotFoundException("User " + (String)parsed.getRight())), "USER_REQUEST_CANCEL", "Canceling " + executionId + " not allowed");
        this.userRequestHandler.cancel((ProcessInstance)parsed.getLeft(), reason);
    }

    @PreAuthorize(value="isAuthenticated()")
    public UserRequestForm claimForm(String taskId) {
        UserRequestForm form = this.userRequestHandler.claimForm(taskId);
        UserRequestLogic.securityChecks(form.getUsername(), "USER_REQUEST_FORM_CLAIM", "Claiming form " + taskId + " not allowed");
        return form;
    }

    @PreAuthorize(value="isAuthenticated()")
    public UserRequestForm unclaimForm(String taskId) {
        UserRequestForm form = this.userRequestHandler.unclaimForm(taskId);
        UserRequestLogic.securityChecks(form.getUsername(), "USER_REQUEST_FORM_UNCLAIM", "Unclaiming form " + taskId + " not allowed");
        return form;
    }

    protected void evaluateKey(String userKey) {
        if (userKey == null) {
            UserRequestLogic.securityChecks(null, "USER_REQUEST_FORM_LIST", "Listing forms not allowed");
        } else {
            User user = (User)this.userDAO.findById(userKey).orElseThrow(() -> new NotFoundException("User " + userKey));
            UserRequestLogic.securityChecks(user.getUsername(), "USER_REQUEST_FORM_LIST", "Listing forms for user" + user.getUsername() + " not allowed");
        }
    }

    @PreAuthorize(value="isAuthenticated()")
    public UserRequestForm getForm(String userKey, String taskId) {
        this.evaluateKey(userKey);
        return this.userRequestHandler.getForm(userKey, taskId);
    }

    @PreAuthorize(value="isAuthenticated()")
    @Transactional(readOnly=true)
    public Page<UserRequestForm> listForms(String userKey, Pageable pageable) {
        this.evaluateKey(userKey);
        return this.userRequestHandler.getForms(userKey, pageable);
    }

    @PreAuthorize(value="isAuthenticated()")
    public ProvisioningResult<UserTO> submitForm(UserRequestForm form, boolean nullPriorityAsync) {
        UserTO userTO;
        if (form.getUsername() == null) {
            UserRequestLogic.securityChecks(null, "USER_REQUEST_FORM_SUBMIT", "Submitting forms not allowed");
        } else {
            UserRequestLogic.securityChecks(form.getUsername(), "USER_REQUEST_FORM_SUBMIT", "Submitting forms for user" + form.getUsername() + " not allowed");
        }
        ProvisioningResult result = new ProvisioningResult();
        UserWorkflowResult wfResult = this.userRequestHandler.submitForm(form);
        if (wfResult.getPropByRes() != null && !wfResult.getPropByRes().isEmpty()) {
            List taskInfos = this.propagationManager.getUserUpdateTasks(new UserWorkflowResult((Object)Pair.of((Object)((UserUR)wfResult.getResult()), (Object)Boolean.TRUE), wfResult.getPropByRes(), wfResult.getPropByLinkedAccount(), wfResult.getPerformedTasks()));
            PropagationReporter propagationReporter = this.taskExecutor.execute((Collection)taskInfos, nullPriorityAsync, AuthContextUtils.getUsername());
            result.getPropagationStatuses().addAll(propagationReporter.getStatuses());
        }
        if (this.userDAO.findById(((UserUR)wfResult.getResult()).getKey()).isEmpty()) {
            userTO = new UserTO();
            userTO.setKey(((UserUR)wfResult.getResult()).getKey());
        } else {
            userTO = this.binder.getUserTO(((UserUR)wfResult.getResult()).getKey());
        }
        result.setEntity((EntityTO)userTO);
        return result;
    }

    protected EntityTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        throw new UnresolvedReferenceException();
    }
}

