/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib;

import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractLDAPConf
implements Serializable {
    private static final long serialVersionUID = 3705514707899419599L;
    private String searchFilter;
    private boolean subtreeSearch = true;
    private int pageSize;
    private String baseDn;
    private String ldapUrl;
    private LdapType ldapType = LdapType.GENERIC;
    private String bindDn;
    private String bindCredential;
    private boolean disablePooling;
    private int minPoolSize = 3;
    private int maxPoolSize = 10;
    private LdapConnectionPoolPassivator poolPassivator = LdapConnectionPoolPassivator.BIND;
    private LdapHostnameVerifier hostnameVerifier = LdapHostnameVerifier.DEFAULT;
    private LdapTrustManager trustManager;
    private boolean validateOnCheckout = true;
    private boolean validatePeriodically = true;
    private Duration validateTimeout = Duration.parse("PT5S");
    private Duration validatePeriod = Duration.parse("PT5M");
    private boolean failFast = true;
    private Duration idleTime = Duration.parse("PT10M");
    private Duration prunePeriod = Duration.parse("PT2H");
    private Duration blockWaitTime = Duration.parse("PT3S");
    private LdapConnectionStrategy connectionStrategy;
    private boolean useStartTls;
    private Duration connectTimeout = Duration.parse("PT5S");
    private Duration responseTimeout = Duration.parse("PT5S");
    private boolean allowMultipleDns;
    private boolean allowMultipleEntries;
    private boolean followReferrals = true;
    private List<String> binaryAttributes = Stream.of("objectGUID", "objectSid").collect(Collectors.toList());

    public String getSearchFilter() {
        return this.searchFilter;
    }

    public void setSearchFilter(String searchFilter) {
        this.searchFilter = searchFilter;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public boolean isSubtreeSearch() {
        return this.subtreeSearch;
    }

    public void setSubtreeSearch(boolean subtreeSearch) {
        this.subtreeSearch = subtreeSearch;
    }

    public LdapType getLdapType() {
        return this.ldapType;
    }

    public void setLdapType(LdapType ldapType) {
        this.ldapType = ldapType;
    }

    public String getLdapUrl() {
        return this.ldapUrl;
    }

    public void setLdapUrl(String ldapUrl) {
        this.ldapUrl = ldapUrl;
    }

    public String getBindDn() {
        return this.bindDn;
    }

    public void setBindDn(String bindDn) {
        this.bindDn = bindDn;
    }

    public String getBindCredential() {
        return this.bindCredential;
    }

    public void setBindCredential(String bindCredential) {
        this.bindCredential = bindCredential;
    }

    public String getBaseDn() {
        return this.baseDn;
    }

    public void setBaseDn(String baseDn) {
        this.baseDn = baseDn;
    }

    public boolean isDisablePooling() {
        return this.disablePooling;
    }

    public void setDisablePooling(boolean disablePooling) {
        this.disablePooling = disablePooling;
    }

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public void setMinPoolSize(int minPoolSize) {
        this.minPoolSize = minPoolSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public LdapConnectionPoolPassivator getPoolPassivator() {
        return this.poolPassivator;
    }

    public void setPoolPassivator(LdapConnectionPoolPassivator poolPassivator) {
        this.poolPassivator = poolPassivator;
    }

    public LdapHostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(LdapHostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public LdapTrustManager getTrustManager() {
        return this.trustManager;
    }

    public void setTrustManager(LdapTrustManager trustManager) {
        this.trustManager = trustManager;
    }

    public boolean isValidateOnCheckout() {
        return this.validateOnCheckout;
    }

    public void setValidateOnCheckout(boolean validateOnCheckout) {
        this.validateOnCheckout = validateOnCheckout;
    }

    public boolean isValidatePeriodically() {
        return this.validatePeriodically;
    }

    public void setValidatePeriodically(boolean validatePeriodically) {
        this.validatePeriodically = validatePeriodically;
    }

    public Duration getValidateTimeout() {
        return this.validateTimeout;
    }

    public void setValidateTimeout(Duration validateTimeout) {
        this.validateTimeout = validateTimeout;
    }

    public Duration getValidatePeriod() {
        return this.validatePeriod;
    }

    public void setValidatePeriod(Duration validatePeriod) {
        this.validatePeriod = validatePeriod;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    public Duration getIdleTime() {
        return this.idleTime;
    }

    public void setIdleTime(Duration idleTime) {
        this.idleTime = idleTime;
    }

    public Duration getPrunePeriod() {
        return this.prunePeriod;
    }

    public void setPrunePeriod(Duration prunePeriod) {
        this.prunePeriod = prunePeriod;
    }

    public Duration getBlockWaitTime() {
        return this.blockWaitTime;
    }

    public void setBlockWaitTime(Duration blockWaitTime) {
        this.blockWaitTime = blockWaitTime;
    }

    public LdapConnectionStrategy getConnectionStrategy() {
        return this.connectionStrategy;
    }

    public void setConnectionStrategy(LdapConnectionStrategy connectionStrategy) {
        this.connectionStrategy = connectionStrategy;
    }

    public boolean isUseStartTls() {
        return this.useStartTls;
    }

    public void setUseStartTls(boolean useStartTls) {
        this.useStartTls = useStartTls;
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public Duration getResponseTimeout() {
        return this.responseTimeout;
    }

    public void setResponseTimeout(Duration responseTimeout) {
        this.responseTimeout = responseTimeout;
    }

    public boolean isAllowMultipleDns() {
        return this.allowMultipleDns;
    }

    public void setAllowMultipleDns(boolean allowMultipleDns) {
        this.allowMultipleDns = allowMultipleDns;
    }

    public boolean isAllowMultipleEntries() {
        return this.allowMultipleEntries;
    }

    public void setAllowMultipleEntries(boolean allowMultipleEntries) {
        this.allowMultipleEntries = allowMultipleEntries;
    }

    public boolean isFollowReferrals() {
        return this.followReferrals;
    }

    public void setFollowReferrals(boolean followReferrals) {
        this.followReferrals = followReferrals;
    }

    public List<String> getBinaryAttributes() {
        return this.binaryAttributes;
    }

    public void setBinaryAttributes(List<String> binaryAttributes) {
        this.binaryAttributes = binaryAttributes;
    }

    public static enum LdapType {
        GENERIC,
        AD,
        FreeIPA,
        EDirectory;

    }

    public static enum LdapConnectionPoolPassivator {
        NONE,
        BIND;

    }

    public static enum LdapHostnameVerifier {
        DEFAULT,
        ANY;

    }

    public static enum LdapTrustManager {
        DEFAULT,
        ANY;

    }

    public static enum LdapConnectionStrategy {
        ACTIVE_PASSIVE,
        ROUND_ROBIN,
        RANDOM,
        DNS_SRV;

    }
}

