/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum AuthErrorCode {
    NO_AUTH_ERROR("no_auth_error"),
    AUTH_FAILED_INVALID_SUBJECT("auth_failed_invalid_subject"),
    AUTH_FAILED_INVALID_AUDIENCE("auth_failed_invalid_audience"),
    AUTH_FAILED_INVALID_ISSUER("auth_failed_invalid_issuer"),
    INVALID_CLAIMS("invalid_claims"),
    AUTH_FAILED_INVALID_BEARER_TOKEN("auth_failed_invalid_bearer_token"),
    BEARER_TOKEN_MISSING("bearer_token_missing"),
    UNAUTHENTICATED("unauthenticated"),
    FORBIDDEN("forbidden");

    private String value;

    private AuthErrorCode(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static AuthErrorCode fromValue(String value) {
        for (AuthErrorCode b : AuthErrorCode.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        return String.format("%s=%s", prefix, this.toString());
    }
}

