/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.syncope.ext.openfga.client.ApiClient;
import org.apache.syncope.ext.openfga.client.model.ConsistencyPreference;
import org.apache.syncope.ext.openfga.client.model.ReadRequestTupleKey;

@JsonPropertyOrder(value={"tuple_key", "page_size", "continuation_token", "consistency"})
public class ReadRequest {
    public static final String JSON_PROPERTY_TUPLE_KEY = "tuple_key";
    @Nullable
    private ReadRequestTupleKey tupleKey;
    public static final String JSON_PROPERTY_PAGE_SIZE = "page_size";
    @Nullable
    private Integer pageSize;
    public static final String JSON_PROPERTY_CONTINUATION_TOKEN = "continuation_token";
    @Nullable
    private String continuationToken;
    public static final String JSON_PROPERTY_CONSISTENCY = "consistency";
    @Nullable
    private ConsistencyPreference consistency = ConsistencyPreference.UNSPECIFIED;

    public ReadRequest tupleKey(@Nullable ReadRequestTupleKey tupleKey) {
        this.tupleKey = tupleKey;
        return this;
    }

    @Nullable
    @JsonProperty(value="tuple_key")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ReadRequestTupleKey getTupleKey() {
        return this.tupleKey;
    }

    @JsonProperty(value="tuple_key")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTupleKey(@Nullable ReadRequestTupleKey tupleKey) {
        this.tupleKey = tupleKey;
    }

    public ReadRequest pageSize(@Nullable Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Nullable
    @JsonProperty(value="page_size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPageSize() {
        return this.pageSize;
    }

    @JsonProperty(value="page_size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPageSize(@Nullable Integer pageSize) {
        this.pageSize = pageSize;
    }

    public ReadRequest continuationToken(@Nullable String continuationToken) {
        this.continuationToken = continuationToken;
        return this;
    }

    @Nullable
    @JsonProperty(value="continuation_token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getContinuationToken() {
        return this.continuationToken;
    }

    @JsonProperty(value="continuation_token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContinuationToken(@Nullable String continuationToken) {
        this.continuationToken = continuationToken;
    }

    public ReadRequest consistency(@Nullable ConsistencyPreference consistency) {
        this.consistency = consistency;
        return this;
    }

    @Nullable
    @JsonProperty(value="consistency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ConsistencyPreference getConsistency() {
        return this.consistency;
    }

    @JsonProperty(value="consistency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConsistency(@Nullable ConsistencyPreference consistency) {
        this.consistency = consistency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadRequest readRequest = (ReadRequest)o;
        return Objects.equals(this.tupleKey, readRequest.tupleKey) && Objects.equals(this.pageSize, readRequest.pageSize) && Objects.equals(this.continuationToken, readRequest.continuationToken) && Objects.equals((Object)this.consistency, (Object)readRequest.consistency);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tupleKey, this.pageSize, this.continuationToken, this.consistency});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReadRequest {\n");
        sb.append("    tupleKey: ").append(this.toIndentedString(this.tupleKey)).append("\n");
        sb.append("    pageSize: ").append(this.toIndentedString(this.pageSize)).append("\n");
        sb.append("    continuationToken: ").append(this.toIndentedString(this.continuationToken)).append("\n");
        sb.append("    consistency: ").append(this.toIndentedString((Object)this.consistency)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getTupleKey() != null) {
            joiner.add(this.getTupleKey().toUrlQueryString((String)prefix + JSON_PROPERTY_TUPLE_KEY + suffix));
        }
        if (this.getPageSize() != null) {
            joiner.add(String.format("%spage_size%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(this.getPageSize()))));
        }
        if (this.getContinuationToken() != null) {
            joiner.add(String.format("%scontinuation_token%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(this.getContinuationToken()))));
        }
        if (this.getConsistency() != null) {
            joiner.add(String.format("%sconsistency%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString((Object)this.getConsistency()))));
        }
        return joiner.toString();
    }
}

