/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.MetadataRecoveryStrategy;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.CooperativeStickyAssignor;
import org.apache.kafka.clients.consumer.RangeAssignor;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

public class ConsumerConfigTest {
    private final Deserializer<byte[]> keyDeserializer = new ByteArrayDeserializer();
    private final Deserializer<String> valueDeserializer = new StringDeserializer();
    private final String keyDeserializerClassName = this.keyDeserializer.getClass().getName();
    private final String valueDeserializerClassName = this.valueDeserializer.getClass().getName();
    private final Object keyDeserializerClass = this.keyDeserializer.getClass();
    private final Object valueDeserializerClass = this.valueDeserializer.getClass();
    private final Properties properties = new Properties();

    @BeforeEach
    public void setUp() {
        this.properties.setProperty("key.deserializer", this.keyDeserializerClassName);
        this.properties.setProperty("value.deserializer", this.valueDeserializerClassName);
    }

    @Test
    public void testOverrideClientId() {
        this.properties.setProperty("group.id", "test-group");
        ConsumerConfig config = new ConsumerConfig(this.properties);
        Assertions.assertFalse((boolean)config.getString("client.id").isEmpty());
    }

    @Test
    public void testOverrideEnableAutoCommit() {
        Assertions.assertEquals((Object)false, (Object)new ConsumerConfig(this.properties).getBoolean("enable.auto.commit"));
        this.properties.setProperty("enable.auto.commit", Boolean.FALSE.toString());
        Assertions.assertEquals((Object)false, (Object)new ConsumerConfig(this.properties).getBoolean("enable.auto.commit"));
        this.properties.setProperty("enable.auto.commit", Boolean.TRUE.toString());
        Assertions.assertThrows(InvalidConfigurationException.class, () -> new ConsumerConfig(this.properties));
        this.properties.setProperty("group.id", "test-group");
        Assertions.assertEquals((Object)true, (Object)new ConsumerConfig(this.properties).getBoolean("enable.auto.commit"));
        this.properties.remove("enable.auto.commit");
        Assertions.assertEquals((Object)true, (Object)new ConsumerConfig(this.properties).getBoolean("enable.auto.commit"));
    }

    @Test
    public void testAppendDeserializerToConfig() {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("key.deserializer", this.keyDeserializerClass);
        configs.put("value.deserializer", this.valueDeserializerClass);
        Map newConfigs = ConsumerConfig.appendDeserializerToConfig(configs, null, null);
        Assertions.assertEquals(newConfigs.get("key.deserializer"), (Object)this.keyDeserializerClass);
        Assertions.assertEquals(newConfigs.get("value.deserializer"), (Object)this.valueDeserializerClass);
        configs.clear();
        configs.put("value.deserializer", this.valueDeserializerClass);
        newConfigs = ConsumerConfig.appendDeserializerToConfig(configs, this.keyDeserializer, null);
        Assertions.assertEquals(newConfigs.get("key.deserializer"), (Object)this.keyDeserializerClass);
        Assertions.assertEquals(newConfigs.get("value.deserializer"), (Object)this.valueDeserializerClass);
        configs.clear();
        configs.put("key.deserializer", this.keyDeserializerClass);
        newConfigs = ConsumerConfig.appendDeserializerToConfig(configs, null, this.valueDeserializer);
        Assertions.assertEquals(newConfigs.get("key.deserializer"), (Object)this.keyDeserializerClass);
        Assertions.assertEquals(newConfigs.get("value.deserializer"), (Object)this.valueDeserializerClass);
        configs.clear();
        newConfigs = ConsumerConfig.appendDeserializerToConfig(configs, this.keyDeserializer, this.valueDeserializer);
        Assertions.assertEquals(newConfigs.get("key.deserializer"), (Object)this.keyDeserializerClass);
        Assertions.assertEquals(newConfigs.get("value.deserializer"), (Object)this.valueDeserializerClass);
    }

    @Test
    public void testAppendDeserializerToConfigWithException() {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("key.deserializer", null);
        configs.put("value.deserializer", this.valueDeserializerClass);
        Assertions.assertThrows(ConfigException.class, () -> ConsumerConfig.appendDeserializerToConfig((Map)configs, null, this.valueDeserializer));
        configs.clear();
        configs.put("key.deserializer", this.keyDeserializerClass);
        configs.put("value.deserializer", null);
        Assertions.assertThrows(ConfigException.class, () -> ConsumerConfig.appendDeserializerToConfig((Map)configs, this.keyDeserializer, null));
    }

    @Test
    public void ensureDefaultThrowOnUnsupportedStableFlagToFalse() {
        Assertions.assertFalse((boolean)new ConsumerConfig(this.properties).getBoolean("internal.throw.on.fetch.stable.offset.unsupported"));
    }

    @Test
    public void testDefaultPartitionAssignor() {
        Assertions.assertEquals(Arrays.asList(RangeAssignor.class, CooperativeStickyAssignor.class), (Object)new ConsumerConfig(this.properties).getList("partition.assignment.strategy"));
    }

    @Test
    public void testInvalidGroupInstanceId() {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("key.deserializer", this.keyDeserializerClass);
        configs.put("value.deserializer", this.valueDeserializerClass);
        configs.put("group.instance.id", "");
        ConfigException ce = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> new ConsumerConfig(configs));
        Assertions.assertTrue((boolean)ce.getMessage().contains("group.instance.id"));
    }

    @Test
    public void testInvalidSecurityProtocol() {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("key.deserializer", this.keyDeserializerClass);
        configs.put("value.deserializer", this.valueDeserializerClass);
        configs.put("security.protocol", "abc");
        ConfigException ce = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> new ConsumerConfig(configs));
        Assertions.assertTrue((boolean)ce.getMessage().contains("security.protocol"));
    }

    @Test
    public void testCaseInsensitiveSecurityProtocol() {
        String saslSslLowerCase = SecurityProtocol.SASL_SSL.name.toLowerCase(Locale.ROOT);
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("key.deserializer", this.keyDeserializerClass);
        configs.put("value.deserializer", this.valueDeserializerClass);
        configs.put("security.protocol", saslSslLowerCase);
        ConsumerConfig consumerConfig = new ConsumerConfig(configs);
        Assertions.assertEquals((Object)saslSslLowerCase, consumerConfig.originals().get("security.protocol"));
    }

    @Test
    public void testDefaultConsumerGroupConfig() {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("key.deserializer", this.keyDeserializerClass);
        configs.put("value.deserializer", this.valueDeserializerClass);
        ConsumerConfig consumerConfig = new ConsumerConfig(configs);
        Assertions.assertEquals((Object)"classic", (Object)consumerConfig.getString("group.protocol"));
        Assertions.assertNull((Object)consumerConfig.getString("group.remote.assignor"));
    }

    @Test
    public void testRemoteAssignorConfig() {
        String remoteAssignorName = "SomeAssignor";
        String protocol = "consumer";
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("key.deserializer", this.keyDeserializerClass);
        configs.put("value.deserializer", this.valueDeserializerClass);
        configs.put("group.remote.assignor", remoteAssignorName);
        configs.put("group.protocol", protocol);
        ConsumerConfig consumerConfig = new ConsumerConfig(configs);
        Assertions.assertEquals((Object)protocol, (Object)consumerConfig.getString("group.protocol"));
        Assertions.assertEquals((Object)remoteAssignorName, (Object)consumerConfig.getString("group.remote.assignor"));
    }

    @Test
    public void testDefaultMetadataRecoveryStrategy() {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("key.deserializer", this.keyDeserializerClass);
        configs.put("value.deserializer", this.valueDeserializerClass);
        ConsumerConfig consumerConfig = new ConsumerConfig(configs);
        Assertions.assertEquals((Object)MetadataRecoveryStrategy.NONE.name, (Object)consumerConfig.getString("metadata.recovery.strategy"));
    }

    @Test
    public void testInvalidMetadataRecoveryStrategy() {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("key.deserializer", this.keyDeserializerClass);
        configs.put("value.deserializer", this.valueDeserializerClass);
        configs.put("metadata.recovery.strategy", "abc");
        ConfigException ce = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> new ConsumerConfig(configs));
        Assertions.assertTrue((boolean)ce.getMessage().contains("metadata.recovery.strategy"));
    }

    @ParameterizedTest
    @CsvSource(value={"consumer, true", "classic, true", "Consumer, true", "Classic, true", "invalid, false"})
    public void testProtocolConfigValidation(String protocol, boolean isValid) {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("key.deserializer", this.keyDeserializerClass);
        configs.put("value.deserializer", this.valueDeserializerClass);
        configs.put("group.protocol", protocol);
        if (isValid) {
            ConsumerConfig config = new ConsumerConfig(configs);
            Assertions.assertEquals((Object)protocol, (Object)config.getString("group.protocol"));
        } else {
            Assertions.assertThrows(ConfigException.class, () -> new ConsumerConfig(configs));
        }
    }
}

