/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.view.attributes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.text.StringEscapeUtils;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.validation.CasProtocolAttributesRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCas30ProtocolAttributesRenderer
implements CasProtocolAttributesRenderer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCas30ProtocolAttributesRenderer.class);

    public Collection<String> render(Map<String, Object> attributes) {
        ArrayList<String> formattedAttributes = new ArrayList<String>(attributes.size());
        LOGGER.trace("Beginning to format/render attributes for the response");
        attributes.forEach((attributeName, v) -> {
            Set values = CollectionUtils.toCollection((Object)v);
            values.forEach(value -> {
                String name = CasProtocolAttributesRenderer.sanitizeAttributeName((String)attributeName);
                String fmt = this.buildSingleAttributeDefinitionLine(name, value);
                LOGGER.trace("Formatted attribute for the response: [{}]", (Object)fmt);
                formattedAttributes.add(fmt);
            });
        });
        return formattedAttributes;
    }

    protected String buildSingleAttributeDefinitionLine(String attributeName, Object value) {
        return "<cas:%s>%s</cas:%s>".formatted(attributeName, this.encodeAttributeValue(value), attributeName);
    }

    protected String encodeAttributeValue(Object value) {
        return StringEscapeUtils.escapeXml10((String)value.toString().trim());
    }
}

