/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kafka.coordinator.transaction.ProducerIdsIntegrationTest$;
import kafka.network.SocketServer;
import kafka.server.IntegrationTestUtils$;
import kafka.test.ClusterConfig;
import kafka.test.ClusterInstance;
import kafka.test.annotation.AutoStart;
import kafka.test.annotation.ClusterConfigProperty;
import kafka.test.annotation.ClusterTemplate;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTestDefaults;
import kafka.test.annotation.ClusterTests;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import org.apache.kafka.common.message.InitProducerIdRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.InitProducerIdRequest;
import org.apache.kafka.common.requests.InitProducerIdResponse;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ClusterTestDefaults(serverProperties={@ClusterConfigProperty(key="transaction.state.log.num.partitions", value="1")})
@ExtendWith(value={ClusterTestExtensions.class})
@ScalaSignature(bytes="\u0006\u0005\u0005-v!\u0002\u0007\u000e\u0011\u0003!b!\u0002\f\u000e\u0011\u00039\u0002\"\u0002\u0010\u0002\t\u0003y\u0002\"\u0002\u0011\u0002\t\u0003\tc\u0001\u0002\f\u000e\u0001ABQA\b\u0003\u0005\u0002EBQa\r\u0003\u0005\u0002QBQa\u001c\u0003\u0005\u0002ADQa\u001e\u0003\u0005\u0002aDq!!\u000e\u0005\t\u0003\t9\u0004C\u0004\u0002P\u0011!I!!\u0015\t\u000f\u0005UC\u0001\"\u0003\u0002X\u0005Q\u0002K]8ek\u000e,'/\u00133t\u0013:$Xm\u001a:bi&|g\u000eV3ti*\u0011abD\u0001\fiJ\fgn]1di&|gN\u0003\u0002\u0011#\u0005Y1m\\8sI&t\u0017\r^8s\u0015\u0005\u0011\u0012!B6bM.\f7\u0001\u0001\t\u0003+\u0005i\u0011!\u0004\u0002\u001b!J|G-^2fe&#7/\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f^\n\u0003\u0003a\u0001\"!\u0007\u000f\u000e\u0003iQ\u0011aG\u0001\u0006g\u000e\fG.Y\u0005\u0003;i\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u0015\u0003a)h.[9vKB\u0013x\u000eZ;dKJLEm\u001d\"v[BL%\t\u0015\u000b\u0002EA\u00191\u0005\u000b\u0016\u000e\u0003\u0011R!!\n\u0014\u0002\tU$\u0018\u000e\u001c\u0006\u0002O\u0005!!.\u0019<b\u0013\tICE\u0001\u0003MSN$\bCA\u0016/\u001b\u0005a#BA\u0017\u0012\u0003\u0011!Xm\u001d;\n\u0005=b#!D\"mkN$XM]\"p]\u001aLwm\u0005\u0002\u00051Q\t!\u0007\u0005\u0002\u0016\t\u0005)B/Z:u+:L\u0017/^3Qe>$WoY3s\u0013\u0012\u001cHCA\u001b9!\tIb'\u0003\u000285\t!QK\\5u\u0011\u0015Id\u00011\u0001;\u0003=\u0019G.^:uKJLen\u001d;b]\u000e,\u0007CA\u0016<\u0013\taDFA\bDYV\u001cH/\u001a:J]N$\u0018M\\2fQ\u00111a\bR#\u0011\u0005}\u0012U\"\u0001!\u000b\u0005\u0005c\u0013AC1o]>$\u0018\r^5p]&\u00111\t\u0011\u0002\r\u00072,8\u000f^3s)\u0016\u001cHo]\u0001\u0006m\u0006dW/\u001a\u0017\u0004\r\n<7fB$K\u0017F\u00136\u000b\u0016\t\u0003\u007f!K!!\u0013!\u0003\u0017\rcWo\u001d;feR+7\u000f^\u0001\u0006if\u0004Xm\u001d\u0017\u0002\u0019\u0012\nQ*\u0003\u0002O\u001f\u0006\u0011!l\u0013\u0006\u0003!\u0002\u000bA\u0001V=qK\u00069!M]8lKJ\u001cX$A\u0002\u0002\u001f5,G/\u00193bi\u00064VM]:j_:$\u0013!V\u0005\u0003-^\u000b1\"\u0013\"Q?Jz\u0006hX%Wc)\u0011\u0001,W\u0001\u0010\u001b\u0016$\u0018\rZ1uCZ+'o]5p]*\u0011!lW\u0001\u0007G>lWn\u001c8\u000b\u0005qk\u0016AB:feZ,'O\u0003\u0002\u0013=*\u0011q\fY\u0001\u0007CB\f7\r[3\u000b\u0003\u0005\f1a\u001c:hW\u001d9%jY)S'\u0012d\u0013\u0001\u0014\u0013\u0002K&\u0011amV\u0001\f\u0013\n\u0003vlM01?&3\u0006gK\u0004H\u0015\"\f&k\u00157-\u0003%$\u0013A[\u0005\u0003W>\u000bQa\u0013*B\rR#\u0013!\\\u0005\u0003]^\u000b1\"\u0013\"Q?Nz6gX%Wa\u0005aB/Z:u+:L\u0017/^3Qe>$WoY3s\u0013\u0012\u001c()^7q\u0013\n\u0003FCA\u001br\u0011\u0015It\u00011\u0001;Q\u001191\u000f\u0012<\u0011\u0005}\"\u0018BA;A\u0005=\u0019E.^:uKJ$V-\u001c9mCR,\u0017%\u0001\u0011\u0002oQ,7\u000f\u001e%b]\u0012dW-\u00117m_\u000e\fG/\u001a)s_\u0012,8-\u001a:JIN\u001c\u0016N\\4mKJ+\u0017/^3ti\"\u000bg\u000e\u001a7feRC'/Z1e)\t)\u0014\u0010C\u0003:\u0011\u0001\u0007!\b\u000b\u0007\t\u000f*[\u0018\u000b`?\u007f\u0003\u000f\tI\u0001L\u0001M;\u0005\t\u0011!C1vi>\u001cF/\u0019:uI\u0005y\u0018\u0002BA\u0001\u0003\u0007\t!AT(\u000b\u0007\u0005\u0015\u0001)A\u0005BkR|7\u000b^1si\u0006\u00012/\u001a:wKJ\u0004&o\u001c9feRLWm\u001d\u0017\u0003\u0003\u0017Y\u0013\"!\u0004\u0002\u0014\u0005UA)!\u0007\u0011\u0007}\ny!C\u0002\u0002\u0012\u0001\u0013Qc\u00117vgR,'oQ8oM&<\u0007K]8qKJ$\u00180A\u0002lKf\f#!a\u0006\u0002\u001d9,XNL5p]QD'/Z1eg\u0006\u0012\u00111D\u0001\u0002c!2\u0001\"a\bE\u0003g\u0001B!!\t\u000205\u0011\u00111\u0005\u0006\u0005\u0003K\t9#A\u0002ba&TA!!\u000b\u0002,\u00059!.\u001e9ji\u0016\u0014(bAA\u0017A\u0006)!.\u001e8ji&!\u0011\u0011GA\u0012\u0005\u001d!\u0016.\\3pkRt\u0012\u0001F\u0001'i\u0016\u001cH/T;mi&\u0004H.Z!mY>\u001c\u0017\r^3Qe>$WoY3s\u0013\u0012\u001c(+Z9vKN$HcA\u001b\u0002:!)\u0011(\u0003a\u0001u!\u001a\u0011\"!\u0010\u0011\t\u0005\u0005\u0012qH\u0005\u0005\u0003\u0003\n\u0019C\u0001\u0005ESN\f'\r\\3eQ5IqISA##rlh0a\u0002\u0002H1\nA\n\f\u0002\u0002J-J\u0011QBA\n\u0003+!\u00151J\u0011\u0003\u0003\u001b\n\u0011AM\u0001\u0010m\u0016\u0014\u0018NZ=V]&\fX/Z%egR\u0019Q'a\u0015\t\u000beR\u0001\u0019\u0001\u001e\u0002\u001d9,\u0007\u0010\u001e)s_\u0012,8-\u001a:JIR1\u0011\u0011LA0\u0003_\u00022!GA.\u0013\r\tiF\u0007\u0002\u0005\u0019>tw\rC\u0004\u0002b-\u0001\r!a\u0019\u0002\r\t\u0014xn[3s!\u0011\t)'a\u001b\u000e\u0005\u0005\u001d$bAA5#\u00059a.\u001a;x_J\\\u0017\u0002BA7\u0003O\u0012AbU8dW\u0016$8+\u001a:wKJDq!!\u001d\f\u0001\u0004\t\u0019(\u0001\u0005mSN$XM\\3s!\u0011\t)(a\u001f\u000e\u0005\u0005]$\u0002BA5\u0003sR!AW/\n\t\u0005u\u0014q\u000f\u0002\r\u0019&\u001cH/\u001a8fe:\u000bW.\u001a\u0015\b\t\u0005\u0005\u0015qAAD!\ry\u00141Q\u0005\u0004\u0003\u000b\u0003%aE\"mkN$XM\u001d+fgR$UMZ1vYR\u001cHFAAEW%\ti!a\u0005\u0002\f\u0012\u000bI\"\t\u0002\u0002\u000e\u0006!CO]1og\u0006\u001cG/[8o]M$\u0018\r^3/Y><gF\\;n]A\f'\u000f^5uS>t7\u000f\u000b\u0004\u0005\u0003##\u0015Q\u0014\t\u0005\u0003'\u000bI*\u0004\u0002\u0002\u0016*!\u0011qSA\u0012\u0003%)\u0007\u0010^3og&|g.\u0003\u0003\u0002\u001c\u0006U%AC#yi\u0016tGmV5uQ2\u0012\u0011qT\u0012\u0003\u0003C\u0003B!a)\u0002(6\u0011\u0011Q\u0015\u0006\u0004\u0003[a\u0013\u0002BAU\u0003K\u0013Qc\u00117vgR,'\u000fV3ti\u0016CH/\u001a8tS>t7\u000f")
public class ProducerIdsIntegrationTest {
    public static List<ClusterConfig> uniqueProducerIdsBumpIBP() {
        return ProducerIdsIntegrationTest$.MODULE$.uniqueProducerIdsBumpIBP();
    }

    @ClusterTests(value={@ClusterTest(types={Type.ZK}, brokers=3, metadataVersion=MetadataVersion.IBP_2_8_IV1), @ClusterTest(types={Type.ZK}, brokers=3, metadataVersion=MetadataVersion.IBP_3_0_IV0), @ClusterTest(types={Type.KRAFT}, brokers=3, metadataVersion=MetadataVersion.IBP_3_3_IV0)})
    public void testUniqueProducerIds(ClusterInstance clusterInstance) {
        this.verifyUniqueIds(clusterInstance);
    }

    @ClusterTemplate(value="uniqueProducerIdsBumpIBP")
    public void testUniqueProducerIdsBumpIBP(ClusterInstance clusterInstance) {
        clusterInstance.start();
        this.verifyUniqueIds(clusterInstance);
        clusterInstance.stop();
    }

    @ClusterTest(types={Type.ZK}, brokers=1, autoStart=AutoStart.NO, serverProperties={@ClusterConfigProperty(key="num.io.threads", value="1")})
    @Timeout(value=20L)
    public void testHandleAllocateProducerIdsSingleRequestHandlerThread(ClusterInstance clusterInstance) {
        clusterInstance.start();
        this.verifyUniqueIds(clusterInstance);
        clusterInstance.stop();
    }

    @Disabled
    @ClusterTest(types={Type.ZK}, brokers=1, autoStart=AutoStart.NO, serverProperties={@ClusterConfigProperty(key="num.io.threads", value="2")})
    public void testMultipleAllocateProducerIdsRequest(ClusterInstance clusterInstance) {
        clusterInstance.start();
        this.verifyUniqueIds(clusterInstance);
        clusterInstance.stop();
    }

    private void verifyUniqueIds(ClusterInstance clusterInstance) {
        Seq ids = CollectionConverters$.MODULE$.ListHasAsScala(clusterInstance.brokerSocketServers().stream().flatMap(broker -> IntStream.range(0, 1001).parallel().mapToObj(x$1 -> BoxesRunTime.boxToLong((long)this.nextProducerId(broker, clusterInstance.clientListener())))).collect(Collectors.toList())).asScala().toSeq();
        int brokerCount = clusterInstance.brokerIds().size();
        int expectedTotalCount = 1001 * brokerCount;
        Assertions.assertEquals((int)expectedTotalCount, (int)ids.size(), (String)new StringBuilder(21).append("Expected exactly ").append(expectedTotalCount).append(" IDs").toString());
        Assertions.assertEquals((int)expectedTotalCount, (int)((SeqOps)ids.distinct()).size(), (String)"Found duplicate producer IDs");
    }

    private long nextProducerId(SocketServer broker, ListenerName listener) {
        Deadline deadline = new package.DurationInt(package$.MODULE$.DurationInt(5)).seconds().fromNow();
        boolean shouldRetry = true;
        InitProducerIdResponse response = null;
        while (shouldRetry && deadline.hasTimeLeft()) {
            InitProducerIdRequestData data = new InitProducerIdRequestData().setProducerEpoch((short)-1).setProducerId(-1L).setTransactionalId(null).setTransactionTimeoutMs(10);
            InitProducerIdRequest request = (InitProducerIdRequest)new InitProducerIdRequest.Builder(data).build();
            response = (InitProducerIdResponse)IntegrationTestUtils$.MODULE$.connectAndReceive((AbstractRequest)request, broker, listener, ClassTag$.MODULE$.apply(InitProducerIdResponse.class));
            shouldRetry = response.data().errorCode() == Errors.COORDINATOR_LOAD_IN_PROGRESS.code();
        }
        Assertions.assertTrue((boolean)deadline.hasTimeLeft());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)response.data().errorCode());
        return response.data().producerId();
    }
}

