/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.udp;

import io.micrometer.shaded.io.netty.channel.ChannelFuture;
import io.micrometer.shaded.io.netty.channel.socket.DatagramChannel;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.netty.Connection;
import io.micrometer.shaded.reactor.netty.ConnectionObserver;
import io.micrometer.shaded.reactor.netty.FutureMono;
import io.micrometer.shaded.reactor.netty.ReactorNetty;
import io.micrometer.shaded.reactor.netty.channel.ChannelOperations;
import io.micrometer.shaded.reactor.netty.udp.UdpInbound;
import io.micrometer.shaded.reactor.netty.udp.UdpOutbound;
import io.micrometer.shaded.reactor.util.Logger;
import io.micrometer.shaded.reactor.util.Loggers;
import io.micrometer.shaded.reactor.util.annotation.Nullable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;

final class UdpOperations
extends ChannelOperations<UdpInbound, UdpOutbound>
implements UdpInbound,
UdpOutbound {
    static final Logger log = Loggers.getLogger(UdpOperations.class);

    UdpOperations(Connection c, ConnectionObserver listener) {
        super(c, listener);
    }

    @Override
    public Mono<Void> join(InetAddress multicastAddress, @Nullable NetworkInterface iface) {
        if (!(this.connection().channel() instanceof DatagramChannel)) {
            throw new UnsupportedOperationException();
        }
        DatagramChannel datagramChannel = (DatagramChannel)this.connection().channel();
        if (null == iface && null != datagramChannel.config().getNetworkInterface()) {
            iface = datagramChannel.config().getNetworkInterface();
        }
        ChannelFuture future = null != iface ? datagramChannel.joinGroup(new InetSocketAddress(multicastAddress, datagramChannel.localAddress().getPort()), iface) : datagramChannel.joinGroup(multicastAddress);
        return FutureMono.from(future).doOnSuccess(v -> {
            if (log.isInfoEnabled()) {
                log.info(ReactorNetty.format(future.channel(), "JOIN {}"), multicastAddress);
            }
        });
    }

    @Override
    public Mono<Void> leave(InetAddress multicastAddress, @Nullable NetworkInterface iface) {
        if (!(this.connection().channel() instanceof DatagramChannel)) {
            throw new UnsupportedOperationException();
        }
        DatagramChannel datagramChannel = (DatagramChannel)this.connection().channel();
        if (null == iface && null != datagramChannel.config().getNetworkInterface()) {
            iface = datagramChannel.config().getNetworkInterface();
        }
        ChannelFuture future = null != iface ? datagramChannel.leaveGroup(new InetSocketAddress(multicastAddress, datagramChannel.localAddress().getPort()), iface) : datagramChannel.leaveGroup(multicastAddress);
        return FutureMono.from(future).doOnSuccess(v -> {
            if (log.isInfoEnabled()) {
                log.info(ReactorNetty.format(future.channel(), "JOIN {}"), multicastAddress);
            }
        });
    }
}

