/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.token;

import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.PlainHeader;
import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.SignedJWT;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.RegisteredServiceCipherExecutor;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.function.FunctionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class JwtBuilder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(JwtBuilder.class);
    public static final String TICKET_JWT_BUILDER_BEAN_NAME = "tokenTicketJwtBuilder";
    public static final String ACCESS_TOKEN_JWT_BUILDER_BEAN_NAME = "accessTokenJwtBuilder";
    private final CipherExecutor<Serializable, String> defaultTokenCipherExecutor;
    private final ApplicationContext applicationContext;
    private final ServicesManager servicesManager;
    private final PrincipalResolver principalResolver;
    private final RegisteredServiceCipherExecutor registeredServiceCipherExecutor;
    private final ServiceFactory webApplicationServiceFactory;
    private final CasConfigurationProperties casProperties;

    public JwtBuilder(CipherExecutor<Serializable, String> cipherExecutor, ApplicationContext applicationContext, ServicesManager servicesManager, PrincipalResolver principalResolver, CasConfigurationProperties properties, ServiceFactory webApplicationServiceFactory) {
        this(cipherExecutor, applicationContext, servicesManager, principalResolver, RegisteredServiceCipherExecutor.noOp(), webApplicationServiceFactory, properties);
    }

    public static JWTClaimsSet parse(String jwt) {
        try {
            return JWTParser.parse((String)jwt).getJWTClaimsSet();
        }
        catch (Exception e) {
            LOGGER.trace("Unable to parse [{}] JWT; trying JWT claim set...", (Object)jwt);
            try {
                return JWTClaimsSet.parse((String)jwt);
            }
            catch (Exception ex) {
                LoggingUtils.error((Logger)LOGGER, (Throwable)ex);
                throw new IllegalArgumentException("Unable to parse JWT");
            }
        }
    }

    public static JWSHeader parseHeader(String jwt) {
        return (JWSHeader)FunctionUtils.doUnchecked(() -> {
            SignedJWT signedJWT = SignedJWT.parse((String)jwt);
            return signedJWT.getHeader();
        });
    }

    public static String buildPlain(JWTClaimsSet claimsSet, Optional<RegisteredService> registeredService) {
        PlainHeader.Builder header = new PlainHeader.Builder().type(JOSEObjectType.JWT);
        registeredService.ifPresent(svc -> header.customParam(RegisteredServiceCipherExecutor.CUSTOM_HEADER_REGISTERED_SERVICE_ID, (Object)svc.getId()));
        return new PlainJWT(header.build(), claimsSet).serialize();
    }

    public JWTClaimsSet unpack(String jwtJson) {
        return this.unpack(Optional.empty(), jwtJson);
    }

    public JWTClaimsSet unpack(Optional<RegisteredService> service, String jwtJson) {
        return (JWTClaimsSet)FunctionUtils.doUnchecked(() -> {
            service.ifPresent(svc -> {
                LOGGER.trace("Located service [{}] in service registry", svc);
                RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((RegisteredService)svc);
            });
            JWT jwt = JWTParser.parse((String)jwtJson);
            if (jwt instanceof SignedJWT || jwt instanceof EncryptedJWT) {
                if (service.isPresent()) {
                    RegisteredService registeredService = (RegisteredService)service.get();
                    LOGGER.trace("Locating service signing and encryption keys for [{}]", (Object)registeredService.getServiceId());
                    if (this.registeredServiceCipherExecutor.supports(registeredService)) {
                        LOGGER.trace("Decoding JWT based on keys provided by service [{}]", (Object)registeredService.getServiceId());
                        return JwtBuilder.parse(this.registeredServiceCipherExecutor.decode(jwtJson, Optional.of(registeredService)));
                    }
                }
                return (JWTClaimsSet)FunctionUtils.doIf((boolean)this.defaultTokenCipherExecutor.isEnabled(), () -> {
                    LOGGER.trace("Decoding JWT based on default global keys");
                    return JwtBuilder.parse((String)this.defaultTokenCipherExecutor.decode((Object)jwtJson));
                }, () -> {
                    throw new IllegalArgumentException("Unable to validate JWT signature");
                }).get();
            }
            return JwtBuilder.parse(jwtJson);
        });
    }

    public String build(JwtRequest payload) throws Throwable {
        Set<String> serviceAudience = payload.getServiceAudience();
        Objects.requireNonNull(payload.getIssuer(), "Issuer cannot be undefined");
        Objects.requireNonNull(serviceAudience, "Audience cannot be undefined");
        JWTClaimsSet.Builder claims = new JWTClaimsSet.Builder().audience(new ArrayList<String>(serviceAudience)).issuer(payload.getIssuer()).jwtID(payload.getJwtId()).issueTime(payload.getIssueDate()).subject(payload.getSubject());
        Map<String, List<Object>> attributes = this.collectClaims(payload);
        attributes.entrySet().stream().filter(entry -> !((String)entry.getKey()).startsWith(CentralAuthenticationService.NAMESPACE)).filter(entry -> !((List)entry.getValue()).isEmpty()).forEach(entry -> {
            Object claimValue;
            List value = (List)entry.getValue();
            Object object = claimValue = value.size() == 1 ? CollectionUtils.firstElement((Object)value).orElseThrow() : value;
            if (claimValue instanceof ZonedDateTime) {
                claimValue = claimValue.toString();
            }
            claims.claim((String)entry.getKey(), claimValue);
        });
        claims.expirationTime(payload.getValidUntilDate());
        JWTClaimsSet claimsSet = this.finalizeClaims(claims.build(), payload);
        LOGGER.trace("Locating service [{}] in service registry", serviceAudience);
        RegisteredService registeredService = payload.getRegisteredService().orElseGet(() -> serviceAudience.stream().map(this::locateRegisteredService).filter(Objects::nonNull).findFirst().orElseThrow(() -> {
            String formatted = "There is no application record registered with the CAS service registry that would match %s. Review the applications registered with the CAS service registry and make sure a matching record exists for %s.";
            return UnauthorizedServiceException.denied((String)"There is no application record registered with the CAS service registry that would match %s. Review the applications registered with the CAS service registry and make sure a matching record exists for %s.".formatted(serviceAudience, serviceAudience));
        }));
        return this.build(registeredService, claimsSet);
    }

    public String build(RegisteredService registeredService, JWTClaimsSet claimsSet) {
        RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((RegisteredService)registeredService);
        String jwtJson = claimsSet.toString();
        LOGGER.debug("Generated JWT [{}]", (Object)jwtJson);
        LOGGER.trace("Locating service specific signing and encryption keys for service [{}]", (Object)registeredService.getName());
        if (this.registeredServiceCipherExecutor.supports(registeredService)) {
            LOGGER.trace("Encoding JWT based on keys provided by service [{}]", (Object)registeredService.getServiceId());
            return this.registeredServiceCipherExecutor.encode(jwtJson, Optional.of(registeredService));
        }
        if (this.defaultTokenCipherExecutor.isEnabled()) {
            LOGGER.trace("Encoding JWT based on default global keys for service [{}]", (Object)registeredService.getName());
            return (String)this.defaultTokenCipherExecutor.encode((Object)jwtJson);
        }
        String token = JwtBuilder.buildPlain(claimsSet, Optional.of(registeredService));
        LOGGER.trace("Generating plain JWT as the ticket: [{}]", (Object)token);
        return token;
    }

    protected RegisteredService locateRegisteredService(String serviceAudience) {
        Service service = this.webApplicationServiceFactory.createService(serviceAudience);
        return this.servicesManager.findServiceBy(service);
    }

    protected JWTClaimsSet finalizeClaims(JWTClaimsSet claimsSet, JwtRequest payload) throws Exception {
        return claimsSet;
    }

    protected Map<String, List<Object>> collectClaims(JwtRequest payload) throws Throwable {
        return payload.getAttributes();
    }

    @Generated
    public JwtBuilder(CipherExecutor<Serializable, String> defaultTokenCipherExecutor, ApplicationContext applicationContext, ServicesManager servicesManager, PrincipalResolver principalResolver, RegisteredServiceCipherExecutor registeredServiceCipherExecutor, ServiceFactory webApplicationServiceFactory, CasConfigurationProperties casProperties) {
        this.defaultTokenCipherExecutor = defaultTokenCipherExecutor;
        this.applicationContext = applicationContext;
        this.servicesManager = servicesManager;
        this.principalResolver = principalResolver;
        this.registeredServiceCipherExecutor = registeredServiceCipherExecutor;
        this.webApplicationServiceFactory = webApplicationServiceFactory;
        this.casProperties = casProperties;
    }

    @Generated
    public CipherExecutor<Serializable, String> getDefaultTokenCipherExecutor() {
        return this.defaultTokenCipherExecutor;
    }

    @Generated
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Generated
    public ServicesManager getServicesManager() {
        return this.servicesManager;
    }

    @Generated
    public PrincipalResolver getPrincipalResolver() {
        return this.principalResolver;
    }

    @Generated
    public RegisteredServiceCipherExecutor getRegisteredServiceCipherExecutor() {
        return this.registeredServiceCipherExecutor;
    }

    @Generated
    public ServiceFactory getWebApplicationServiceFactory() {
        return this.webApplicationServiceFactory;
    }

    @Generated
    public CasConfigurationProperties getCasProperties() {
        return this.casProperties;
    }

    public static class JwtRequest {
        private final String jwtId;
        private final Set<String> serviceAudience;
        private final Date issueDate;
        private final String subject;
        private final Date validUntilDate;
        private final String issuer;
        private boolean resolveSubject;
        private final Map<String, List<Object>> attributes;
        private Optional<RegisteredService> registeredService;
        private Optional<Service> service;

        @Generated
        private static Date $default$issueDate() {
            return new Date();
        }

        @Generated
        private static Map<String, List<Object>> $default$attributes() {
            return new LinkedHashMap<String, List<Object>>();
        }

        @Generated
        private static Optional<RegisteredService> $default$registeredService() {
            return Optional.empty();
        }

        @Generated
        private static Optional<Service> $default$service() {
            return Optional.empty();
        }

        @Generated
        protected JwtRequest(JwtRequestBuilder<?, ?> b) {
            this.jwtId = b.jwtId;
            this.serviceAudience = b.serviceAudience;
            this.issueDate = b.issueDate$set ? b.issueDate$value : JwtRequest.$default$issueDate();
            this.subject = b.subject;
            this.validUntilDate = b.validUntilDate;
            this.issuer = b.issuer;
            this.resolveSubject = b.resolveSubject;
            this.attributes = b.attributes$set ? b.attributes$value : JwtRequest.$default$attributes();
            this.registeredService = b.registeredService$set ? b.registeredService$value : JwtRequest.$default$registeredService();
            this.service = b.service$set ? b.service$value : JwtRequest.$default$service();
        }

        @Generated
        public static JwtRequestBuilder<?, ?> builder() {
            return new JwtRequestBuilderImpl();
        }

        @Generated
        public String getJwtId() {
            return this.jwtId;
        }

        @Generated
        public Set<String> getServiceAudience() {
            return this.serviceAudience;
        }

        @Generated
        public Date getIssueDate() {
            return this.issueDate;
        }

        @Generated
        public String getSubject() {
            return this.subject;
        }

        @Generated
        public Date getValidUntilDate() {
            return this.validUntilDate;
        }

        @Generated
        public String getIssuer() {
            return this.issuer;
        }

        @Generated
        public boolean isResolveSubject() {
            return this.resolveSubject;
        }

        @Generated
        public Map<String, List<Object>> getAttributes() {
            return this.attributes;
        }

        @Generated
        public Optional<RegisteredService> getRegisteredService() {
            return this.registeredService;
        }

        @Generated
        public Optional<Service> getService() {
            return this.service;
        }

        @Generated
        public String toString() {
            return "JwtBuilder.JwtRequest(jwtId=" + this.jwtId + ", serviceAudience=" + String.valueOf(this.serviceAudience) + ", issueDate=" + String.valueOf(this.issueDate) + ", subject=" + this.subject + ", validUntilDate=" + String.valueOf(this.validUntilDate) + ", issuer=" + this.issuer + ", resolveSubject=" + this.resolveSubject + ", attributes=" + String.valueOf(this.attributes) + ", registeredService=" + String.valueOf(this.registeredService) + ", service=" + String.valueOf(this.service) + ")";
        }

        @Generated
        public JwtRequest(String jwtId, Set<String> serviceAudience, Date issueDate, String subject, Date validUntilDate, String issuer, boolean resolveSubject, Map<String, List<Object>> attributes, Optional<RegisteredService> registeredService, Optional<Service> service) {
            this.jwtId = jwtId;
            this.serviceAudience = serviceAudience;
            this.issueDate = issueDate;
            this.subject = subject;
            this.validUntilDate = validUntilDate;
            this.issuer = issuer;
            this.resolveSubject = resolveSubject;
            this.attributes = attributes;
            this.registeredService = registeredService;
            this.service = service;
        }

        @Generated
        public JwtRequest withJwtId(String jwtId) {
            return this.jwtId == jwtId ? this : new JwtRequest(jwtId, this.serviceAudience, this.issueDate, this.subject, this.validUntilDate, this.issuer, this.resolveSubject, this.attributes, this.registeredService, this.service);
        }

        @Generated
        public JwtRequest withServiceAudience(Set<String> serviceAudience) {
            return this.serviceAudience == serviceAudience ? this : new JwtRequest(this.jwtId, serviceAudience, this.issueDate, this.subject, this.validUntilDate, this.issuer, this.resolveSubject, this.attributes, this.registeredService, this.service);
        }

        @Generated
        public JwtRequest withIssueDate(Date issueDate) {
            return this.issueDate == issueDate ? this : new JwtRequest(this.jwtId, this.serviceAudience, issueDate, this.subject, this.validUntilDate, this.issuer, this.resolveSubject, this.attributes, this.registeredService, this.service);
        }

        @Generated
        public JwtRequest withSubject(String subject) {
            return this.subject == subject ? this : new JwtRequest(this.jwtId, this.serviceAudience, this.issueDate, subject, this.validUntilDate, this.issuer, this.resolveSubject, this.attributes, this.registeredService, this.service);
        }

        @Generated
        public JwtRequest withValidUntilDate(Date validUntilDate) {
            return this.validUntilDate == validUntilDate ? this : new JwtRequest(this.jwtId, this.serviceAudience, this.issueDate, this.subject, validUntilDate, this.issuer, this.resolveSubject, this.attributes, this.registeredService, this.service);
        }

        @Generated
        public JwtRequest withIssuer(String issuer) {
            return this.issuer == issuer ? this : new JwtRequest(this.jwtId, this.serviceAudience, this.issueDate, this.subject, this.validUntilDate, issuer, this.resolveSubject, this.attributes, this.registeredService, this.service);
        }

        @Generated
        public JwtRequest withResolveSubject(boolean resolveSubject) {
            return this.resolveSubject == resolveSubject ? this : new JwtRequest(this.jwtId, this.serviceAudience, this.issueDate, this.subject, this.validUntilDate, this.issuer, resolveSubject, this.attributes, this.registeredService, this.service);
        }

        @Generated
        public JwtRequest withAttributes(Map<String, List<Object>> attributes) {
            return this.attributes == attributes ? this : new JwtRequest(this.jwtId, this.serviceAudience, this.issueDate, this.subject, this.validUntilDate, this.issuer, this.resolveSubject, attributes, this.registeredService, this.service);
        }

        @Generated
        public JwtRequest withRegisteredService(Optional<RegisteredService> registeredService) {
            return this.registeredService == registeredService ? this : new JwtRequest(this.jwtId, this.serviceAudience, this.issueDate, this.subject, this.validUntilDate, this.issuer, this.resolveSubject, this.attributes, registeredService, this.service);
        }

        @Generated
        public JwtRequest withService(Optional<Service> service) {
            return this.service == service ? this : new JwtRequest(this.jwtId, this.serviceAudience, this.issueDate, this.subject, this.validUntilDate, this.issuer, this.resolveSubject, this.attributes, this.registeredService, service);
        }

        @Generated
        public static abstract class JwtRequestBuilder<C extends JwtRequest, B extends JwtRequestBuilder<C, B>> {
            @Generated
            private String jwtId;
            @Generated
            private Set<String> serviceAudience;
            @Generated
            private boolean issueDate$set;
            @Generated
            private Date issueDate$value;
            @Generated
            private String subject;
            @Generated
            private Date validUntilDate;
            @Generated
            private String issuer;
            @Generated
            private boolean resolveSubject;
            @Generated
            private boolean attributes$set;
            @Generated
            private Map<String, List<Object>> attributes$value;
            @Generated
            private boolean registeredService$set;
            @Generated
            private Optional<RegisteredService> registeredService$value;
            @Generated
            private boolean service$set;
            @Generated
            private Optional<Service> service$value;

            @Generated
            public B jwtId(String jwtId) {
                this.jwtId = jwtId;
                return this.self();
            }

            @Generated
            public B serviceAudience(Set<String> serviceAudience) {
                this.serviceAudience = serviceAudience;
                return this.self();
            }

            @Generated
            public B issueDate(Date issueDate) {
                this.issueDate$value = issueDate;
                this.issueDate$set = true;
                return this.self();
            }

            @Generated
            public B subject(String subject) {
                this.subject = subject;
                return this.self();
            }

            @Generated
            public B validUntilDate(Date validUntilDate) {
                this.validUntilDate = validUntilDate;
                return this.self();
            }

            @Generated
            public B issuer(String issuer) {
                this.issuer = issuer;
                return this.self();
            }

            @Generated
            public B resolveSubject(boolean resolveSubject) {
                this.resolveSubject = resolveSubject;
                return this.self();
            }

            @Generated
            public B attributes(Map<String, List<Object>> attributes) {
                this.attributes$value = attributes;
                this.attributes$set = true;
                return this.self();
            }

            @Generated
            public B registeredService(Optional<RegisteredService> registeredService) {
                this.registeredService$value = registeredService;
                this.registeredService$set = true;
                return this.self();
            }

            @Generated
            public B service(Optional<Service> service) {
                this.service$value = service;
                this.service$set = true;
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "JwtBuilder.JwtRequest.JwtRequestBuilder(jwtId=" + this.jwtId + ", serviceAudience=" + String.valueOf(this.serviceAudience) + ", issueDate$value=" + String.valueOf(this.issueDate$value) + ", subject=" + this.subject + ", validUntilDate=" + String.valueOf(this.validUntilDate) + ", issuer=" + this.issuer + ", resolveSubject=" + this.resolveSubject + ", attributes$value=" + String.valueOf(this.attributes$value) + ", registeredService$value=" + String.valueOf(this.registeredService$value) + ", service$value=" + String.valueOf(this.service$value) + ")";
            }
        }

        @Generated
        private static final class JwtRequestBuilderImpl
        extends JwtRequestBuilder<JwtRequest, JwtRequestBuilderImpl> {
            @Generated
            private JwtRequestBuilderImpl() {
            }

            @Override
            @Generated
            protected JwtRequestBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public JwtRequest build() {
                return new JwtRequest(this);
            }
        }
    }
}

