/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.lops;

import org.apache.sysds.common.Types;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.runtime.instructions.InstructionUtils;

public class UnaryCP
extends Lop {
    private final Types.OpOp1 operation;
    private final int _numThreads;

    public UnaryCP(Lop input, Types.OpOp1 op, Types.DataType dt, Types.ValueType vt, Types.ExecType et, int k) {
        super(Lop.Type.UnaryCP, dt, vt);
        this.operation = op;
        this.addInput(input);
        input.addOutput(this);
        this.lps.setProperties(this.inputs, et);
        this._numThreads = k;
    }

    public UnaryCP(Lop input, Types.OpOp1 op, Types.DataType dt, Types.ValueType vt, Types.ExecType et) {
        this(input, op, dt, vt, et, 1);
    }

    public UnaryCP(Lop input, Types.OpOp1 op, Types.DataType dt, Types.ValueType vt, int k) {
        this(input, op, dt, vt, Types.ExecType.CP, k);
    }

    public UnaryCP(Lop input, Types.OpOp1 op, Types.DataType dt, Types.ValueType vt) {
        this(input, op, dt, vt, Types.ExecType.CP, 1);
    }

    @Override
    public String toString() {
        return "Operation: " + this.getInstructions("", "");
    }

    public String getOpCode() {
        return this.operation.toString();
    }

    @Override
    public String getInstructions(String input, String output) {
        String ret = InstructionUtils.concatOperands(this.getExecType().name(), this.getOpCode(), this.getInputs().get(0).prepScalarInputOperand(this.getExecType()), this.prepOutputOperand(output));
        if (this.getExecType() == Types.ExecType.CP || this.getExecType() == Types.ExecType.FED) {
            ret = InstructionUtils.concatOperands(ret, Integer.toString(this._numThreads));
        }
        return ret;
    }
}

