/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.util.function;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.tinkerpop.gremlin.util.function.ThrowingBiConsumer;
import org.apache.tinkerpop.gremlin.util.function.ThrowingConsumer;
import org.apache.tinkerpop.gremlin.util.function.ThrowingFunction;
import org.apache.tinkerpop.gremlin.util.function.ThrowingSupplier;

public final class FunctionUtils {
    private FunctionUtils() {
    }

    public static <T, U> Function<T, U> wrapFunction(ThrowingFunction<T, U> functionThatThrows) {
        return a -> {
            try {
                return functionThatThrows.apply(a);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static <T> Consumer<T> wrapConsumer(ThrowingConsumer<T> consumerThatThrows) {
        return a -> {
            try {
                consumerThatThrows.accept(a);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static <T, U> BiConsumer<T, U> wrapBiConsumer(ThrowingBiConsumer<T, U> consumerThatThrows) {
        return (a, b) -> {
            try {
                consumerThatThrows.accept(a, b);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static <T> Supplier<T> wrapSupplier(ThrowingSupplier<T> supplierThatThrows) {
        return () -> {
            try {
                return supplierThatThrows.get();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }
}

